/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Objects;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class MarkerCategory
extends MarkerSupportItem {
    final int start;
    final int end;
    private volatile MarkerEntry[] children;
    private final String name;
    private int severity = -1;
    private final Markers markers;

    MarkerCategory(Markers markers, int startIndex, int endIndex, String categoryName) {
        this.markers = markers;
        this.start = startIndex;
        this.end = endIndex;
        this.name = categoryName;
    }

    @Override
    MarkerSupportItem[] getChildren() {
        MarkerSupportItem[] myChildren = this.children;
        if (myChildren != null) {
            return myChildren;
        }
        MarkerEntry[] allMarkers = this.markers.getMarkerEntryArray();
        int markersLength = allMarkers.length;
        if (this.start >= markersLength || this.end >= markersLength) {
            return new MarkerEntry[0];
        }
        int totalSize = this.getChildrenCount();
        myChildren = new MarkerEntry[totalSize];
        System.arraycopy(allMarkers, this.start, myChildren, 0, totalSize);
        MarkerSupportItem[] markerSupportItemArray = myChildren;
        int n = myChildren.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem markerEntry = markerSupportItemArray[n2];
            ((MarkerEntry)markerEntry).setCategory(this);
            ++n2;
        }
        this.children = myChildren;
        return myChildren;
    }

    void resetChildren() {
        this.children = null;
    }

    @Override
    int getChildrenCount() {
        return this.end - this.start + 1;
    }

    @Override
    String getDescription() {
        int size = this.getChildrenCount();
        MarkerContentGenerator generator = this.markers.getBuilder().getGenerator();
        boolean limitsEnabled = generator.isMarkerLimitsEnabled();
        int limit = generator.getMarkerLimits();
        if (limitsEnabled && size > limit) {
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(limit), String.valueOf(this.getChildrenCount())});
        }
        if (size == 1) {
            return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
        }
        return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(size)});
    }

    int getHighestSeverity() {
        if (this.severity >= 0) {
            return this.severity;
        }
        this.severity = 0;
        MarkerSupportItem[] markerSupportItemArray = this.getChildren();
        int n = markerSupportItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem supportItem = markerSupportItemArray[n2];
            if (supportItem.isConcrete()) {
                int elementSeverity = supportItem.getAttributeValue("severity", -1);
                if (elementSeverity > this.severity) {
                    this.severity = elementSeverity;
                }
                if (this.severity == 2) {
                    return this.severity;
                }
            }
            ++n2;
        }
        return this.severity;
    }

    String getName() {
        return this.name;
    }

    @Override
    MarkerSupportItem getParent() {
        return null;
    }

    @Override
    boolean isConcrete() {
        return false;
    }

    @Override
    void clearCache() {
        MarkerSupportItem[] markerSupportItemArray = this.getChildren();
        int n = markerSupportItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem supportItem = markerSupportItemArray[n2];
            supportItem.clearCache();
            ++n2;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.markers);
        return 31 * result + Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkerCategory other = (MarkerCategory)obj;
        return Objects.equals(this.markers, other.markers) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MarkerCategory [name=");
        builder.append(this.name);
        builder.append(", severity=");
        builder.append(this.severity);
        builder.append(", start=");
        builder.append(this.start);
        builder.append(", end=");
        builder.append(this.end);
        builder.append(']');
        return builder.toString();
    }
}

