/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.NativeHandler;

public class Win32Handler
extends NativeHandler {
    private static final int ATTRIBUTES = 122;
    private static final int DWORD_SIZE = 4;
    private static final int FILETIME_SIZE = 8;
    private static final int WCHAR_SIZE = 2;
    private static final int DW_FILE_ATTRIBUTES = 0;
    private static final int FT_CREATION_TIME = 4;
    private static final int FT_LAST_ACCESS_TIME = 12;
    private static final int FT_LAST_WRITE_TIME = 20;
    private static final int N_FILE_SIZE_HIGH = 28;
    private static final int N_FILE_SIZE_LOW = 32;
    private static final int DW_RESERVED_0 = 36;
    private static final int DW_RESERVED_1 = 40;
    private static final int C_FILE_NAME = 44;
    private static final int C_ALTERNATE_FILE_NAME = 564;
    private static final int WIN32_FIND_DATA_SIZE = 592;
    private static final long MAXDWORD = 0xFFFFFFFFL;

    static {
        if (592 != WinBase.WIN32_FIND_DATA.sizeOf()) {
            throw new IllegalStateException("Struct 'WIN32_FIND_DATAW' has unexpected size");
        }
    }

    @Override
    public int getSupportedAttributes() {
        return 122;
    }

    @Override
    public FileInfo fetchFileInfo(String fileName) {
        FileInfo fileInfo = new FileInfo();
        String target = Win32Handler.toLongWindowsPath(fileName);
        if (target.length() == 7 && target.startsWith("\\\\?\\") && target.endsWith(":\\")) {
            fileInfo.setDirectory(true);
            fileInfo.setExists(Files.exists(Path.of(target.substring("\\\\?\\".length()), new String[0]), new LinkOption[0]));
            return fileInfo;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Memory mem = new Memory(592L);){
                long handle = FileAPIh.FindFirstFileW(new WString(target), (Pointer)mem);
                if (handle == FileAPIh.INVALID_HANDLE_VALUE) {
                    int error = Native.getLastError();
                    if (error != 2 && error != 3) {
                        fileInfo.setError(5);
                    }
                    return fileInfo;
                }
                FileAPIh.FindClose(handle);
                Win32Handler.convertFindDataWToFileInfo(mem, fileInfo, fileName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            fileInfo.setError(5);
        }
        return fileInfo;
    }

    @Override
    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        WString lpFileName = new WString(Win32Handler.toLongWindowsPath(fileName));
        long dwFileAttributes = FileAPIh.GetFileAttributesW(lpFileName);
        if (dwFileAttributes == FileAPIh.INVALID_FILE_ATTRIBUTES) {
            return false;
        }
        if (dwFileAttributes == 128L) {
            dwFileAttributes = 0L;
        }
        long fileAttributes = dwFileAttributes;
        boolean archive = info.getAttribute(8);
        boolean readOnly = info.getAttribute(2);
        boolean hidden = info.getAttribute(16);
        fileAttributes = this.set(fileAttributes, 32, archive);
        fileAttributes = this.set(fileAttributes, 1, readOnly);
        if (dwFileAttributes == (fileAttributes = this.set(fileAttributes, 2, hidden))) {
            return true;
        }
        return FileAPIh.SetFileAttributesW(lpFileName, fileAttributes);
    }

    public static String getShortPathName(String longPath) {
        char[] buffer;
        int newLength = Kernel32.INSTANCE.GetShortPathName(longPath = Win32Handler.toLongWindowsPath(longPath), buffer = new char[longPath.length()], buffer.length);
        if (newLength > 0 && newLength < buffer.length) {
            int offset = longPath.startsWith("\\\\?\\UNC") ? "\\\\?\\UNC".length() : "\\\\?\\".length();
            return new String(buffer, offset, newLength);
        }
        return null;
    }

    private static String toLongWindowsPath(String fileName) {
        if (fileName.startsWith("\\\\") && !fileName.startsWith("\\\\?\\UNC")) {
            return "\\\\?\\UNC" + fileName.substring(1);
        }
        if (!fileName.startsWith("\\\\?\\")) {
            return "\\\\?\\" + fileName;
        }
        return fileName;
    }

    private static void convertFindDataWToFileInfo(Memory mem, FileInfo info, String fileName) throws IOException {
        int dwFileAttributes = Win32Handler.readDWORDAsSignedInt(mem, 0);
        Date ftLastWriteTime = Win32Handler.readFILETIME(mem, 20);
        long nFileSizeHigh = Win32Handler.readDWORD(mem, 28);
        long nFileSizeLow = Win32Handler.readDWORD(mem, 32);
        int dwReserved0 = Win32Handler.readDWORDAsSignedInt(mem, 36);
        String cFileName = mem.getWideString(44L);
        long fileLength = nFileSizeHigh * 0x100000000L + nFileSizeLow;
        info.setName(cFileName);
        info.setExists(true);
        info.setLastModified(ftLastWriteTime.getTime());
        info.setLength(fileLength);
        info.setDirectory(Win32Handler.isSet(dwFileAttributes, 16));
        info.setAttribute(8, Win32Handler.isSet(dwFileAttributes, 32));
        info.setAttribute(2, Win32Handler.isSet(dwFileAttributes, 1));
        info.setAttribute(16, Win32Handler.isSet(dwFileAttributes, 2));
        boolean isReparsePoint = Win32Handler.isSet(dwFileAttributes, 1024);
        if (isReparsePoint && dwReserved0 == -1610612724) {
            Path linkTarget = Files.readSymbolicLink(Path.of(fileName, new String[0]));
            info.setAttribute(32, true);
            info.setStringAttribute(64, linkTarget.toString());
        }
    }

    private static int readDWORDAsSignedInt(Memory memory, int offset) {
        return memory.getInt((long)offset);
    }

    private static long readDWORD(Memory memory, int offset) {
        return (long)Win32Handler.readDWORDAsSignedInt(memory, offset) & 0xFFFFFFFFL;
    }

    private static Date readFILETIME(Memory memory, int offset) {
        int low = Win32Handler.readDWORDAsSignedInt(memory, offset);
        int high = Win32Handler.readDWORDAsSignedInt(memory, offset + 4);
        return WinBase.FILETIME.filetimeToDate((int)high, (int)low);
    }

    private static boolean isSet(long field, int bit) {
        return (field & (long)bit) != 0L;
    }

    private long set(long field, int bit, boolean isSet) {
        return isSet ? field | (long)bit : field & (long)(~bit);
    }

    static class FileAPIh {
        private static final long INVALID_HANDLE_VALUE;
        static final long INVALID_FILE_ATTRIBUTES;

        static {
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"Kernel32"));
            INVALID_HANDLE_VALUE = Pointer.nativeValue((Pointer)WinBase.INVALID_HANDLE_VALUE.getPointer());
            INVALID_FILE_ATTRIBUTES = new WinDef.DWORD(-1L).longValue();
        }

        FileAPIh() {
        }

        static native long FindFirstFileW(WString var0, Pointer var1);

        static native long GetFileAttributesW(WString var0);

        static native boolean SetFileAttributesW(WString var0, long var1);

        static native boolean FindClose(long var0);
    }
}

