/*
 * Copyright (c) 2014, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.setup;

/**
 * @author Eike Stepper
 */
public final class AnnotationConstants
{
  public static final String ANNOTATION_BRANDING_INFO = "http://www.eclipse.org/oomph/setup/BrandingInfo"; //$NON-NLS-1$

  public static final String KEY_IMAGE_URI = "imageURI"; //$NON-NLS-1$

  public static final String KEY_README_PATH = "readmePath"; //$NON-NLS-1$

  public static final String KEY_FOLDER_NAME = "folderName"; //$NON-NLS-1$

  public static final String KEY_APP_NAME = "appName"; //$NON-NLS-1$

  public static final String KEY_SITE_URI = "siteURI"; //$NON-NLS-1$

  public static final String KEY_BADGE_LABEL = "badgeLabel"; //$NON-NLS-1$

  public static final String KEY_STATUS = "status"; //$NON-NLS-1$

  public static final String KEY_INCUBATING = "incubating"; //$NON-NLS-1$

  public static final String VALUE_STATUS_OUTDATED = "outdated"; //$NON-NLS-1$

  public static final String VALUE_STATUS_CURRENT = "current"; //$NON-NLS-1$

  public static final String VALUE_STATUS_DISCONTINUED = "discontinued"; //$NON-NLS-1$

  public static final String SHORTCUT = "shortcut"; //$NON-NLS-1$

  public static final String ANNOTATION_STATS_SENDING = "http://www.eclipse.org/oomph/setup/StatsSending"; //$NON-NLS-1$

  public static final String KEY_URI = "uri"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_LABEL = "notificationLabel"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_TOOLTIP = "notificationTooltip"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_PRIORITY = "notificationPriority"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_URI = "notificationURI"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_ANIMATION_STYLE = "notificationAnimationStyle"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_COLOR = "notificationColor"; //$NON-NLS-1$

  public static final String KEY_NOTIFICATION_SCOPE = "notificationScope"; //$NON-NLS-1$

  public static final String ANNOTATION_USER_PREFERENCES = "http://www.eclipse.org/oomph/setup/UserPreferences"; //$NON-NLS-1$

  public static final String ANNOTATION_INHERITED_CHOICES = "http://www.eclipse.org/oomph/setup/InheritedChoices"; //$NON-NLS-1$

  public static final String ANNOTATION_INDUCED_CHOICES = "http://www.eclipse.org/oomph/setup/InducedChoices"; //$NON-NLS-1$

  public static final String ANNOTATION_MATCH_CHOICE = "http://www.eclipse.org/oomph/setup/MatchChoice"; //$NON-NLS-1$

  public static final String ANNOTATION_FEATURE_SUBSTITUTION = "http://www.eclipse.org/oomph/setup/FeatureSubstitution"; //$NON-NLS-1$

  public static final String ANNOTATION_PASSWORD_VERIFICATION = "http://www.eclipse.org/oomph/setup/PasswordVerification"; //$NON-NLS-1$

  public static final String ANNOTATION_GLOBAL_VARIABLE = "http://www.eclipse.org/oomph/setup/GlobalVariable"; //$NON-NLS-1$

  public static final String ANNOTATION_SIMPLE_MODE_DEFAULT_VARIABLE = "http://www.eclipse.org/oomph/setup/SimpleDefaultVariable"; //$NON-NLS-1$

  public static final String ANNOTATION_UNDECLARED_VARIABLE = "http://www.eclipse.org/oomph/setup/UndeclaredVariable"; //$NON-NLS-1$

  public static final String KEY_INHERIT = "inherit"; //$NON-NLS-1$

  public static final String KEY_TARGET = "target"; //$NON-NLS-1$

  public static final String KEY_LABEL = "label"; //$NON-NLS-1$

  public static final String KEY_DESCRIPTION = "description"; //$NON-NLS-1$

  public static final String ANNOTATION_RELEASE_TRAIN = "http://www.eclipse.org/oomph/setup/ReleaseTrain"; //$NON-NLS-1$

  public static final String ANNOTATION_RELEASE_TRAIN_ALTERNATE = "http://www.eclipse.org/oomph/setup/ReleaseTrainAlternate"; //$NON-NLS-1$

  public static final String ANNOTATION_JRE = "http://www.eclipse.org/oomph/setup/JRE"; //$NON-NLS-1$

  public static final String ANNOTATION_JRE_SPECIFIC_TASKS = "http://www.eclipse.org/oomph/setup/JRESpecificTasks"; //$NON-NLS-1$

  public static final String ANNOTATION_CONFIGURATION_REFERENCE = "http://www.eclipse.org/oomph/setup/ConfigurationReference"; //$NON-NLS-1$

  public static final String ANNOTATION_TRUSTED_KEYS = "http://www.eclipse.org/oomph/setup/TrustedKeys"; //$NON-NLS-1$

  public static final String ANNOTATION_TRUSTED_CERTIFICATES = "http://www.eclipse.org/oomph/setup/TrustedCertificates"; //$NON-NLS-1$

  public static final String KEY_FILTER = "filter"; //$NON-NLS-1$

  public static final String ANNOTATION_NOTIFICATION = "http://www.eclipse.org/oomph/setup/Notification"; //$NON-NLS-1$

  public static final String ANNOTATION_SYSTEM_PROPERTIES = "http://www.eclipse.org/oomph/setup/SystemProperties"; //$NON-NLS-1$

  private AnnotationConstants()
  {
  }
}
