/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util.pde;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.oomph.util.internal.pde.UtilPDEPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformListener;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetPlatformUtil {
    private static final List<TargetPlatformListener> LISTENERS = new CopyOnWriteArrayList<TargetPlatformListener>();
    private static final Method GET_WORKSPACE_TARGET_DEFINITION_METHOD;

    static {
        Method method = null;
        try {
            method = ITargetPlatformService.class.getMethod("getWorkspaceTargetDefinition", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        GET_WORKSPACE_TARGET_DEFINITION_METHOD = method;
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            private ITargetDefinition oldTargetDefinition;

            public void aboutToRun(IJobChangeEvent event) {
                this.oldTargetDefinition = null;
                if (event.getJob() instanceof LoadTargetDefinitionJob) {
                    this.oldTargetDefinition = this.getCurrentTargetDefinition();
                }
            }

            public void done(IJobChangeEvent event) {
                try {
                    Job job = event.getJob();
                    if (job instanceof LoadTargetDefinitionJob) {
                        ITargetDefinition newTargetDefinition = this.getCurrentTargetDefinition();
                        TargetPlatformUtil.notifyListeners(this.oldTargetDefinition, newTargetDefinition);
                    }
                }
                finally {
                    this.oldTargetDefinition = null;
                }
            }

            private ITargetDefinition getCurrentTargetDefinition() {
                try {
                    return TargetPlatformUtil.getActiveTargetDefinition();
                }
                catch (Exception ex) {
                    UtilPDEPlugin.INSTANCE.log(ex);
                    return null;
                }
            }
        });
    }

    private TargetPlatformUtil() {
    }

    public static <T> T runWithTargetPlatformService(TargetPlatformRunnable<T> runnable) throws CoreException {
        ITargetPlatformService service = null;
        try {
            service = (ITargetPlatformService)UtilPDEPlugin.INSTANCE.getService(ITargetPlatformService.class);
            T t = runnable.run(service);
            return t;
        }
        finally {
            UtilPDEPlugin.INSTANCE.ungetService(service);
        }
    }

    public static void activateTargetDefinition(ITargetDefinition targetDefinition, IProgressMonitor monitor) throws CoreException {
        ITargetDefinition oldTargetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
        monitor.beginTask("Set active target platform", 100);
        try {
            targetDefinition.resolve((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(targetDefinition);
            IStatus status = job.run((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
        TargetPlatformUtil.notifyListeners(oldTargetDefinition, targetDefinition);
    }

    public static boolean isActiveTargetDefinition(final ITargetDefinition targetDefinition) {
        try {
            return TargetPlatformUtil.runWithTargetPlatformService(new TargetPlatformRunnable<Boolean>(){

                @Override
                public Boolean run(ITargetPlatformService service) throws CoreException {
                    return targetDefinition.getHandle().equals(service.getWorkspaceTargetHandle());
                }
            });
        }
        catch (CoreException ex) {
            UtilPDEPlugin.INSTANCE.log(ex);
            return false;
        }
    }

    public static ITargetDefinition getActiveTargetDefinition() {
        try {
            return TargetPlatformUtil.runWithTargetPlatformService(new TargetPlatformRunnable<ITargetDefinition>(){

                @Override
                public ITargetDefinition run(ITargetPlatformService service) throws CoreException {
                    return TargetPlatformUtil.getActiveTargetDefinition(service);
                }
            });
        }
        catch (CoreException ex) {
            UtilPDEPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static ITargetDefinition getActiveTargetDefinition(ITargetPlatformService service) {
        if (GET_WORKSPACE_TARGET_DEFINITION_METHOD != null) {
            try {
                return (ITargetDefinition)GET_WORKSPACE_TARGET_DEFINITION_METHOD.invoke((Object)service, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        try {
            ITargetHandle handle = service.getWorkspaceTargetHandle();
            if (handle != null) {
                return handle.getTargetDefinition();
            }
        }
        catch (CoreException ex) {
            UtilPDEPlugin.INSTANCE.log(ex);
        }
        return null;
    }

    public static ITargetDefinition getTargetDefinition(final String targetDefinitionName) {
        try {
            return TargetPlatformUtil.runWithTargetPlatformService(new TargetPlatformRunnable<ITargetDefinition>(){

                @Override
                public ITargetDefinition run(ITargetPlatformService service) throws CoreException {
                    ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)new NullProgressMonitor());
                    int n = iTargetHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITargetHandle targetHandle = iTargetHandleArray[n2];
                        try {
                            ITargetDefinition candidate = targetHandle.getTargetDefinition();
                            if (targetDefinitionName.equals(candidate.getName())) {
                                return candidate;
                            }
                        }
                        catch (CoreException coreException) {}
                        ++n2;
                    }
                    return null;
                }
            });
        }
        catch (CoreException ex) {
            UtilPDEPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static void addListener(TargetPlatformListener listener) {
        LISTENERS.add(listener);
    }

    public static void removeListener(TargetPlatformListener listener) {
        LISTENERS.remove(listener);
    }

    private static void notifyListeners(ITargetDefinition oldTargetDefinition, ITargetDefinition newTargetDefinition) {
        for (TargetPlatformListener listener : LISTENERS) {
            try {
                listener.targetDefinitionActivated(oldTargetDefinition, newTargetDefinition);
            }
            catch (Exception ex) {
                UtilPDEPlugin.INSTANCE.log(ex);
            }
        }
    }
}

