/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ProvisioningContext {
    private IProvisioningAgent agent;
    private URI[] artifactRepositories;
    private final List<IInstallableUnit> extraIUs = Collections.synchronizedList(new ArrayList());
    private URI[] metadataRepositories;
    private final Map<String, String> properties = new HashMap<String, String>();
    private Map<String, URI> referencedArtifactRepositories = null;
    private Map<URI, IArtifactRepository> loadedArtifactRepositories = new HashMap<URI, IArtifactRepository>();
    private Map<URI, IMetadataRepository> loadedMetadataRepositories = new HashMap<URI, IMetadataRepository>();
    private Map<URI, IMetadataRepository> allLoadedMetadataRepositories;
    private Map<URI, IArtifactRepository> allLoadedArtifactRepositories;
    private Set<URI> failedArtifactRepositories = new HashSet<URI>();
    private Set<URI> failedMetadataRepositories = new HashSet<URI>();
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator<URI> LOCAL_FIRST_COMPARATOR = (arg0, arg1) -> {
        String protocol0 = arg0.getScheme();
        String protocol1 = arg1.getScheme();
        if (FILE_PROTOCOL.equals(protocol0) && !FILE_PROTOCOL.equals(protocol1)) {
            return -1;
        }
        if (!FILE_PROTOCOL.equals(protocol0) && FILE_PROTOCOL.equals(protocol1)) {
            return 1;
        }
        return 0;
    };
    public static final String FOLLOW_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followRepositoryReferences";
    public static final String CHECK_AUTHORITIES = "org.eclipse.equinox.p2.director.checkAuthorities";
    private static final String FOLLOW_ARTIFACT_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followArtifactRepositoryReferences";
    private static Comparator<IArtifactKey> ARTIFACT_KEY_COMPARATOR = (o1, o2) -> {
        int cmp = o1.getId().compareTo(o2.getId());
        if (cmp == 0) {
            cmp = o1.getVersion().compareTo((Object)o2.getVersion());
        }
        return cmp;
    };

    public ProvisioningContext(IProvisioningAgent agent) {
        this.agent = agent;
        this.metadataRepositories = null;
        this.artifactRepositories = null;
        this.setProperty(FOLLOW_ARTIFACT_REPOSITORY_REFERENCES, Boolean.TRUE.toString());
    }

    public IQueryable<IArtifactKey> getArtifactKeys(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    public IQueryable<IArtifactDescriptor> getArtifactDescriptors(IProgressMonitor monitor) {
        List<IArtifactRepository> repos = this.getLoadedArtifactRepositories(monitor);
        ArrayList<IQueryable> descriptorQueryables = new ArrayList<IQueryable>();
        for (IArtifactRepository repo : repos) {
            descriptorQueryables.add(repo.descriptorQueryable());
        }
        return QueryUtil.compoundQueryable(descriptorQueryables);
    }

    public IQueryable<IArtifactRepository> getArtifactRepositories(IProgressMonitor monitor) {
        return new ArtifactRepositoryQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    private List<IArtifactRepository> getLoadedArtifactRepositories(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        URI[] repositories = this.artifactRepositories == null ? repoManager.getKnownRepositories(0) : this.artifactRepositories;
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        ArrayList<IArtifactRepository> repos = new ArrayList<IArtifactRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)((repositories.length + 1) * 100));
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            this.getLoadedRepository(location, repoManager, repos, sub);
            if (this.referencedArtifactRepositories != null && location != null) {
                this.referencedArtifactRepositories.remove(location.toString());
            }
            ++n2;
        }
        if (this.referencedArtifactRepositories != null && this.referencedArtifactRepositories.size() > 0 && this.shouldFollowArtifactReferences()) {
            SubMonitor innerSub = SubMonitor.convert((IProgressMonitor)sub.newChild(100), (int)(this.referencedArtifactRepositories.size() * 100));
            for (URI referencedURI : this.referencedArtifactRepositories.values()) {
                this.getLoadedRepository(referencedURI, repoManager, repos, innerSub);
            }
        }
        return repos;
    }

    private void getLoadedRepository(URI location, IArtifactRepositoryManager repoManager, List<IArtifactRepository> repos, SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.failedArtifactRepositories.contains(location)) {
            return;
        }
        try {
            IArtifactRepository repository = this.loadedArtifactRepositories.get(location);
            if (repository == null) {
                repository = repoManager.loadRepository(location, (IProgressMonitor)monitor.newChild(100));
                this.loadedArtifactRepositories.put(location, repository);
            }
            repos.add(repository);
        }
        catch (ProvisionException provisionException) {
            this.failedArtifactRepositories.add(location);
        }
    }

    private Set<IMetadataRepository> getLoadedMetadataRepositories(IProgressMonitor monitor) {
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] repositories = this.metadataRepositories == null ? repoManager.getKnownRepositories(0) : this.metadataRepositories;
        HashMap<String, IMetadataRepository> repos = new HashMap<String, IMetadataRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        this.referencedArtifactRepositories = new HashMap<String, URI>();
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI repositorie = uRIArray[n2];
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.loadMetadataRepository(repoManager, repositorie, repos, this.shouldFollowReferences(), (IProgressMonitor)sub.newChild(100));
            ++n2;
        }
        HashSet<IMetadataRepository> set = new HashSet<IMetadataRepository>();
        set.addAll(repos.values());
        return set;
    }

    private void loadMetadataRepository(IMetadataRepositoryManager manager, URI location, HashMap<String, IMetadataRepository> repos, boolean followMetadataRepoReferences, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (repos.containsKey(location.toString()) || this.failedMetadataRepositories.contains(location)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        IMetadataRepository repository = this.loadedMetadataRepositories.get(location);
        if (repository == null) {
            try {
                repository = manager.loadRepository(location, (IProgressMonitor)sub.newChild(500));
                this.loadedMetadataRepositories.put(location, repository);
            }
            catch (ProvisionException provisionException) {
                this.failedMetadataRepositories.add(location);
                return;
            }
        }
        repos.put(location.toString(), repository);
        Collection references = repository.getReferences();
        if (references.size() > 0) {
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
            SubMonitor repoSubMon = SubMonitor.convert((IProgressMonitor)sub.newChild(500), (int)(100 * references.size()));
            for (IRepositoryReference ref : references) {
                try {
                    if (ref.getType() == 0 && followMetadataRepoReferences && this.isEnabled((IRepositoryManager)manager, ref)) {
                        this.loadMetadataRepository(manager, ref.getLocation(), repos, followMetadataRepoReferences, (IProgressMonitor)repoSubMon.newChild(100));
                        continue;
                    }
                    if (ref.getType() != 1 || !this.isEnabled((IRepositoryManager)artifactManager, ref)) continue;
                    this.referencedArtifactRepositories.put(ref.getLocation().toString(), ref.getLocation());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            sub.done();
        }
    }

    private boolean isEnabled(IRepositoryManager manager, IRepositoryReference reference) {
        return manager.contains(reference.getLocation()) && manager.isEnabled(reference.getLocation()) || !manager.contains(reference.getLocation()) && (reference.getOptions() & 1) == 1;
    }

    private boolean shouldFollowReferences() {
        return Boolean.parseBoolean(this.getProperty(FOLLOW_REPOSITORY_REFERENCES));
    }

    private boolean shouldFollowArtifactReferences() {
        return Boolean.parseBoolean(this.getProperty(FOLLOW_ARTIFACT_REPOSITORY_REFERENCES));
    }

    public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedMetadataRepositories(monitor));
    }

    public Map<URI, Set<IInstallableUnit>> getInstallableUnitSources(Collection<? extends IInstallableUnit> ius, IProgressMonitor monitor) {
        TreeMap<URI, Set<IInstallableUnit>> result = new TreeMap<URI, Set<IInstallableUnit>>();
        Transport transport = (Transport)this.agent.getService(Transport.class);
        for (IMetadataRepository repository : this.getAllLoadedMetadataRepositories(monitor)) {
            if (repository instanceof ICompositeRepository) continue;
            URI location = this.getSecureLocation(repository.getLocation(), transport);
            TreeSet repositoryIUs = new TreeSet(repository.query(QueryUtil.ALL_UNITS, monitor).toUnmodifiableSet());
            repositoryIUs.retainAll(ius);
            result.put(location, repositoryIUs);
        }
        return result;
    }

    private URI getSecureLocation(URI uri, Transport transport) {
        try {
            return transport.getSecureLocation(uri);
        }
        catch (CoreException coreException) {
            return uri;
        }
    }

    private Collection<IMetadataRepository> getAllLoadedMetadataRepositories(IProgressMonitor monitor) {
        if (this.allLoadedMetadataRepositories == null) {
            IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
            this.getLoadedMetadataRepositories(monitor);
            this.allLoadedMetadataRepositories = this.getAllLoadedRepositories((arg_0, arg_1) -> ((IMetadataRepositoryManager)repoManager).loadRepository(arg_0, arg_1), this.loadedMetadataRepositories, this.failedMetadataRepositories, monitor);
        }
        return this.allLoadedMetadataRepositories.values();
    }

    private Collection<IArtifactRepository> getAllLoadedArtifactRepositories(IProgressMonitor monitor) {
        if (this.allLoadedArtifactRepositories == null) {
            IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
            this.getLoadedArtifactRepositories(monitor);
            this.allLoadedArtifactRepositories = this.getAllLoadedRepositories((arg_0, arg_1) -> ((IArtifactRepositoryManager)repoManager).loadRepository(arg_0, arg_1), this.loadedArtifactRepositories, this.failedArtifactRepositories, monitor);
        }
        return this.allLoadedArtifactRepositories.values();
    }

    private <T> Map<URI, T> getAllLoadedRepositories(Manager<T> manager, Map<URI, T> loadedRepositories, Set<URI> failedRepositories, IProgressMonitor monitor) {
        HashMap<URI, T> allLoadedRepositories = new HashMap<URI, T>(loadedRepositories);
        if (!loadedRepositories.isEmpty()) {
            for (T repository : loadedRepositories.values()) {
                this.loadComposites(manager, repository, allLoadedRepositories, failedRepositories, monitor);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        return allLoadedRepositories;
    }

    /*
     * WARNING - void declaration
     */
    private <T> void loadComposites(Manager<T> manager, T repository, Map<URI, T> repos, Set<URI> failedRepositories, IProgressMonitor monitor) {
        T t = repository;
        if (t instanceof ICompositeRepository) {
            void composite;
            ICompositeRepository iCompositeRepository = (ICompositeRepository)t;
            ICompositeRepository cfr_ignored_0 = (ICompositeRepository)t;
            for (URI location : composite.getChildren()) {
                this.loadRepository(manager, location, repos, failedRepositories, monitor);
            }
        }
    }

    private <T> void loadRepository(Manager<T> manager, URI location, Map<URI, T> repos, Set<URI> failedRepositories, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (repos.containsKey(location) || this.failedMetadataRepositories.contains(location)) {
            return;
        }
        T repository = repos.get(location);
        if (repository == null) {
            try {
                repository = manager.loadRepository(location, monitor);
                repos.put(location, repository);
                this.loadComposites(manager, repository, repos, failedRepositories, monitor);
            }
            catch (ProvisionException provisionException) {
                this.failedMetadataRepositories.add(location);
                return;
            }
        }
    }

    public Map<URI, Set<IArtifactKey>> getArtifactSources(Collection<? extends IArtifactKey> keys, IProgressMonitor monitor) {
        Transport transport = (Transport)this.agent.getService(Transport.class);
        TreeMap<URI, Set<IArtifactKey>> result = new TreeMap<URI, Set<IArtifactKey>>();
        for (IArtifactRepository repository : this.getAllLoadedArtifactRepositories(monitor)) {
            if (repository instanceof ICompositeRepository) continue;
            URI location = this.getSecureLocation(repository.getLocation(), transport);
            for (IArtifactKey iArtifactKey : keys) {
                if (!repository.contains(iArtifactKey)) continue;
                result.computeIfAbsent(location, it -> new TreeSet<IArtifactKey>(ARTIFACT_KEY_COMPARATOR)).add(iArtifactKey);
            }
        }
        return result;
    }

    public List<IInstallableUnit> getExtraInstallableUnits() {
        return this.extraIUs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setArtifactRepositories(URI ... artifactRepositories) {
        this.artifactRepositories = artifactRepositories;
    }

    public void setMetadataRepositories(URI ... metadataRepositories) {
        this.metadataRepositories = metadataRepositories;
    }

    public void setExtraInstallableUnits(List<IInstallableUnit> extraIUs) {
        this.extraIUs.clear();
        if (extraIUs != null) {
            this.extraIUs.addAll(extraIUs);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{artifactRepos=" + DebugHelper.formatArray(this.artifactRepositories != null ? Arrays.asList(this.artifactRepositories) : null, true, false));
        buffer.append(", metadataRepos=" + DebugHelper.formatArray(this.metadataRepositories != null ? Arrays.asList(this.metadataRepositories) : null, true, false));
        buffer.append(", properties=" + this.getProperties() + "}");
        return buffer.toString();
    }

    class ArtifactRepositoryQueryable
    implements IQueryable<IArtifactRepository> {
        List<IArtifactRepository> repositories;

        ArtifactRepositoryQueryable(List<IArtifactRepository> repositories) {
            this.repositories = repositories;
        }

        public IQueryResult<IArtifactRepository> query(IQuery<IArtifactRepository> query, IProgressMonitor mon) {
            return query.perform(this.repositories.listIterator());
        }
    }

    private static interface Manager<T> {
        public T loadRepository(URI var1, IProgressMonitor var2) throws ProvisionException;
    }
}

