/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.DetailedProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressViewUpdater;
import org.eclipse.e4.ui.progress.internal.ProgressViewerContentProvider;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ProgrammaticProgressView {
    private static final String CLEAR_ALL_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.progress/icons/full/elcl16/progress_remall.png";
    DetailedProgressViewer viewer;
    @Inject
    ESelectionService selectionService;
    @Inject
    EModelService modelService;
    MApplication application;
    MPart part;
    ISelectionChangedListener selectionListener;
    private MCommand clearAllCommand;
    private MCommand showPreferencesCommand;

    @PostConstruct
    public void createPartControl(Composite parent, MApplication application, MPart part, ProgressManager progressManager, IProgressService progressService, FinishedJobs finishedJobs, ProgressViewUpdater viewUpdater) {
        this.application = application;
        this.part = part;
        this.viewer = new DetailedProgressViewer(parent, 258, progressService, finishedJobs);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, finishedJobs, viewUpdater, progressManager, true, true);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput((Object)progressManager);
        this.selectionListener = event -> {
            if (this.selectionService != null) {
                this.selectionService.setSelection((Object)event.getSelection());
            }
        };
        this.viewer.addSelectionChangedListener(this.selectionListener);
        this.createCommands();
        this.createViewMenu();
    }

    @Focus
    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    private void createCommands() {
        this.clearAllCommand = (MCommand)this.modelService.createModelElement(MCommand.class);
        this.clearAllCommand.setElementId("clearAllCommand");
        this.clearAllCommand.setCommandName("clearAllCommand");
        this.application.getCommands().add(this.clearAllCommand);
        this.showPreferencesCommand = (MCommand)this.modelService.createModelElement(MCommand.class);
        this.showPreferencesCommand.setElementId("showPreferencesCommand");
        this.showPreferencesCommand.setCommandName("showPreferencesCommand");
        this.application.getCommands().add(this.showPreferencesCommand);
        MHandler clearAllHandler = (MHandler)this.modelService.createModelElement(MHandler.class);
        clearAllHandler.setCommand(this.clearAllCommand);
        clearAllHandler.setContributionURI("bundleclass://org.eclipse.e4.ui.progress/org.eclipse.e4.ui.progress.ClearAllHandler");
        this.part.getHandlers().add(clearAllHandler);
        MHandler showPreferencesHandler = (MHandler)this.modelService.createModelElement(MHandler.class);
        showPreferencesHandler.setCommand(this.showPreferencesCommand);
        showPreferencesHandler.setContributionURI("bundleclass://org.eclipse.e4.ui.progress/org.eclipse.e4.ui.progress.OpenPreferenceDialogHandler");
        this.part.getHandlers().add(showPreferencesHandler);
    }

    private void createViewMenu() {
        MHandledToolItem clearAllButton = (MHandledToolItem)this.modelService.createModelElement(MHandledToolItem.class);
        clearAllButton.setIconURI(CLEAR_ALL_ICON_URI);
        clearAllButton.setCommand(this.clearAllCommand);
        MToolBar toolBar = (MToolBar)this.modelService.createModelElement(MToolBar.class);
        toolBar.getChildren().add(clearAllButton);
        this.part.setToolbar(toolBar);
        MHandledMenuItem clearAllMenuItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
        clearAllMenuItem.setLabel("Clear All");
        clearAllMenuItem.setIconURI(CLEAR_ALL_ICON_URI);
        clearAllMenuItem.setCommand(this.clearAllCommand);
        MHandledMenuItem preferencesMenuItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
        preferencesMenuItem.setLabel("Preferences");
        preferencesMenuItem.setCommand(this.showPreferencesCommand);
        MMenu menu = (MMenu)this.modelService.createModelElement(MMenu.class);
        menu.getTags().add("ViewMenu");
        menu.getChildren().add(clearAllMenuItem);
        menu.getChildren().add(preferencesMenuItem);
        this.part.getMenus().add(menu);
    }
}

