/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;

public class SaveAsHandler
extends AbstractSaveHandler {
    public SaveAsHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        ISaveablePart saveablePart = this.getSaveablePart(event);
        if (saveablePart != null) {
            saveablePart.doSaveAs();
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        WorkbenchPage page = (WorkbenchPage)window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        MPart activeMPart = this.getActivePart(window);
        IWorkbenchPart activePart = InternalHandlerUtil.getActivePart(context);
        ISaveablePart part = SaveableHelper.getSaveable(activePart);
        if (part == null && activeMPart != null && activeMPart.isDirty()) {
            return EvaluationResult.FALSE;
        }
        ISaveablePart saveablePart = this.getSaveablePart(context);
        if (saveablePart == null) {
            return EvaluationResult.FALSE;
        }
        return saveablePart.isSaveAsAllowed() ? EvaluationResult.TRUE : EvaluationResult.FALSE;
    }
}

