/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private static final String DEBUG_PREFIX = "certificate checker";
    public static final String TRUSTED_KEY_STORE_PROPERTY = "pgp.trustedPublicKeys";
    private Map<IArtifactDescriptor, File> artifacts = new HashMap<IArtifactDescriptor, File>();
    private final IProvisioningAgent agent;
    private Set<PGPPublicKey> trustedKeys;

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new HashMap<IArtifactDescriptor, File>();
    }

    public IStatus start() {
        BundleContext context = EngineActivator.getContext();
        ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            IStatus iStatus = this.checkCertificates(verifierFactory);
            return iStatus;
        }
        finally {
            context.ungetService(contentFactoryRef);
        }
    }

    private IStatus checkCertificates(SignedContentFactory verifierFactory) {
        Certificate[][] unTrustedCertificateChains;
        StringBuilder message;
        int n2;
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.class);
        ArrayList<Certificate> untrustedCertificates = new ArrayList<Certificate>();
        HashMap<IArtifactDescriptor, Collection> untrustedPGPArtifacts = new HashMap<IArtifactDescriptor, Collection>();
        HashMap unsigned = new HashMap();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        HashMap<Certificate, Collection> untrustedArtifacts = new HashMap<Certificate, Collection>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.isEmpty() || serviceUI == null) {
            return status;
        }
        HashSet trustedKeysIds = new HashSet();
        for (Map.Entry<IArtifactDescriptor, File> artifact : this.artifacts.entrySet()) {
            Iterator artifactFile = artifact.getValue();
            try {
                SignedContent content = verifierFactory.getSignedContent((File)((Object)artifactFile));
                if (content.isSigned()) {
                    SignerInfo[] signerInfoArray = content.getSignerInfos();
                    if (!Arrays.stream(signerInfoArray).noneMatch(SignerInfo::isTrusted)) continue;
                    SignerInfo[] signerInfoArray2 = signerInfoArray;
                    n2 = signerInfoArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        SignerInfo element = signerInfoArray2[n3];
                        if (!element.isTrusted()) {
                            Certificate[] certificateChain = element.getCertificateChain();
                            if (!untrustedCertificates.contains(certificateChain[0])) {
                                untrustedCertificates.add(certificateChain[0]);
                                untrustedChain.add(certificateChain);
                            }
                            if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED) {
                                untrustedArtifacts.computeIfAbsent(certificateChain[0], key -> new ArrayList()).add(artifactFile);
                            }
                        }
                        ++n3;
                    }
                    continue;
                }
                Collection collection = PGPSignatureVerifier.getSignatures((IArtifactDescriptor)artifact.getKey());
                if (!collection.isEmpty()) {
                    if (this.trustedKeys == null) {
                        this.trustedKeys = this.buildPGPTrustore();
                    }
                    if (trustedKeysIds.isEmpty() && !this.trustedKeys.isEmpty()) {
                        trustedKeysIds.addAll(this.trustedKeys.stream().map(PGPPublicKey::getKeyID).map(Long::valueOf).collect(Collectors.toSet()));
                    }
                    if (!collection.stream().map(PGPSignature::getKeyID).noneMatch(trustedKeysIds::contains)) continue;
                    untrustedPGPArtifacts.put(artifact.getKey(), collection.stream().map(PGPSignature::getKeyID).map(id -> this.findKey((long)id, (IArtifactDescriptor)artifact.getKey())).filter(Objects::nonNull).collect(Collectors.toList()));
                    continue;
                }
                unsigned.put(artifact.getKey(), artifactFile);
            }
            catch (GeneralSecurityException | PGPException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNSIGNED && !unsigned.isEmpty()) {
            message = new StringBuilder("The following artifacts are unsigned:\n");
            for (File file : unsigned.values()) {
                message.append(NLS.bind((String)"  {0}\n", (Object)file.getPath()));
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedCertificates.isEmpty()) {
            message = new StringBuilder("The following certificates are untrusted:\n");
            for (Certificate cert : untrustedArtifacts.keySet()) {
                message.append(String.valueOf(cert.toString()) + "\n");
                message.append("  used by the following artifacts:\n");
                for (Object file : (Collection)untrustedArtifacts.get(cert)) {
                    message.append(NLS.bind((String)"    {0}\n", (Object)((File)file).getPath()));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        Set untrustedPGPKeys = untrustedPGPArtifacts.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedPGPKeys.isEmpty()) {
            StringBuilder message2 = new StringBuilder("The following PGP Keys are untrusted:\n");
            for (PGPPublicKey untrustedKey : untrustedPGPKeys) {
                message2.append(String.valueOf(Long.toHexString(untrustedKey.getKeyID())) + "\n");
                message2.append("  used by the following artifacts:\n");
                for (Map.Entry entry : untrustedPGPArtifacts.entrySet()) {
                    if (!((Collection)entry.getValue()).stream().anyMatch(signer -> signer.getKeyID() == untrustedKey.getKeyID())) continue;
                    message2.append(NLS.bind((String)"    {0}\n", (Object)((IArtifactDescriptor)entry.getKey()).getArtifactKey()));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message2.toString());
        }
        String policy = this.getUnsignedContentPolicy();
        if (!unsigned.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsigned));
        }
        String[] details = "allow".equals(policy) || unsigned.isEmpty() ? null : (String[])unsigned.values().stream().map(Object::toString).toArray(String[]::new);
        Certificate[][] certificateArray = unTrustedCertificateChains = untrustedCertificates.isEmpty() ? null : (Certificate[][])untrustedChain.toArray(n -> new Certificate[n][]);
        if (details == null && unTrustedCertificateChains == null && untrustedPGPArtifacts.isEmpty()) {
            return status;
        }
        UIServices.TrustInfo trustInfo = serviceUI.getTrustInfo(unTrustedCertificateChains, untrustedPGPKeys, details);
        if (!unsigned.isEmpty() && !trustInfo.trustUnsignedContent()) {
            return Status.CANCEL_STATUS;
        }
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        if (unTrustedCertificateChains != null && trustedCertificates == null) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustedCertificates != null) {
            Certificate[] certificateArray2 = trustedCertificates;
            int n4 = trustedCertificates.length;
            n2 = 0;
            while (n2 < n4) {
                Certificate trustedCertificate = certificateArray2[n2];
                untrustedCertificates.remove(trustedCertificate);
                ++n2;
            }
        }
        trustedKeysIds.addAll(trustInfo.getTrustedPGPKeys().stream().map(PGPPublicKey::getKeyID).collect(Collectors.toSet()));
        untrustedPGPArtifacts.values().removeIf(pgpKeys -> pgpKeys.stream().anyMatch(untrusted -> trustedKeysIds.contains(untrusted.getKeyID())));
        if (!untrustedCertificates.isEmpty() || !untrustedPGPArtifacts.isEmpty()) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustInfo.persistTrust()) {
            return this.persistTrustedCertificates(trustedCertificates);
        }
        return status;
    }

    private PGPPublicKey findKey(long id, IArtifactDescriptor artifact) {
        PGPPublicKey key = PGPSignatureVerifier.keystore.getKey(id);
        if (key != null) {
            return key;
        }
        PGPSignatureVerifier.keystore.addKeys(new String[]{artifact.getProperty("pgp.publicKeys")});
        return PGPSignatureVerifier.keystore.getKey(id);
    }

    /*
     * Loose catch block
     */
    private IStatus persistTrustedCertificates(Certificate[] trustedCertificates) {
        if (trustedCertificates == null) {
            return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        ServiceTracker trustEngineTracker = new ServiceTracker(EngineActivator.getContext(), TrustEngine.class, null);
        trustEngineTracker.open();
        Object[] trustEngines = trustEngineTracker.getServices();
        try {
            if (trustEngines == null) {
                return null;
            }
            Certificate[] certificateArray = trustedCertificates;
            int n = trustedCertificates.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate trustedCertificate = certificateArray[n2];
                Object[] objectArray = trustEngines;
                int n3 = trustEngines.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object engine = objectArray[n4];
                    TrustEngine trustEngine = (TrustEngine)engine;
                    if (!trustEngine.isReadOnly()) {
                        try {
                            trustEngine.addTrustAnchor(trustedCertificate, trustedCertificate.toString());
                            break;
                        }
                        catch (IOException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                        catch (GeneralSecurityException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                    }
                    ++n4;
                }
                ++n2;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            trustEngineTracker.close();
        }
        return Status.OK_STATUS;
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void add(Map<IArtifactDescriptor, File> toAdd) {
        this.artifacts.putAll(toAdd);
    }

    public Set<PGPPublicKey> buildPGPTrustore() {
        IProfile profile = ((IProfileRegistry)this.agent.getService(IProfileRegistry.class)).getProfile("_SELF_");
        HashSet<PGPPublicKey> store = new HashSet<PGPPublicKey>(PGPSignatureVerifier.readPublicKeys((String)profile.getProperty(TRUSTED_KEY_STORE_PROPERTY)));
        store.forEach(arg_0 -> ((PGPSignatureVerifier.PGPPublicKeyStore)PGPSignatureVerifier.keystore).addKey(arg_0));
        return store;
    }
}

