/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.impl.manager.AbstractPrototypeRefPair;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.osgi.framework.ServiceReference;

public class SinglePrototypeRefPair<S, T>
extends AbstractPrototypeRefPair<S, T> {
    private final AtomicReference<AbstractMap.SimpleImmutableEntry<ComponentContextImpl<S>, T>> instance = new AtomicReference();

    public SinglePrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public String toString() {
        return "[SinglePrototypeRefPair: ref: [" + this.getRef() + "] service: [" + this.getServiceObject(null) + "]]";
    }

    @Override
    public T getServiceObject(ComponentContextImpl<S> key) {
        return this.internalGetServiceObject(key, false);
    }

    @Override
    public boolean setServiceObject(ComponentContextImpl<S> key, T serviceObject) {
        return this.instance.compareAndSet(null, new AbstractMap.SimpleImmutableEntry<ComponentContextImpl<S>, T>(key, serviceObject));
    }

    @Override
    protected T remove(ComponentContextImpl<S> key) {
        return this.internalGetServiceObject(key, true);
    }

    private T internalGetServiceObject(ComponentContextImpl<S> key, boolean remove) {
        T result;
        AbstractMap.SimpleImmutableEntry<ComponentContextImpl<S>, T> entry = this.instance.get();
        if (entry == null) {
            return null;
        }
        Object object = result = key == null || entry.getKey().equals(key) ? entry.getValue() : null;
        if (remove && result != null) {
            this.instance.compareAndSet(entry, null);
        }
        return result;
    }

    @Override
    protected Collection<Map.Entry<ComponentContextImpl<S>, T>> clearEntries() {
        Map.Entry entry = this.instance.getAndSet(null);
        return entry == null ? Collections.emptyList() : Collections.singleton(entry);
    }
}

