/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManagerElement;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.ui.AgentAnalyzerDialog;
import org.eclipse.oomph.p2.internal.ui.P2ContentProvider;
import org.eclipse.oomph.p2.internal.ui.P2LabelProvider;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.P2ViewerSorter;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class AgentManagerComposite
extends Composite {
    private TreeViewer treeViewer;
    private Object selectedElement;
    private Button newAgentButton;
    private Button newPoolButton;
    private Button deleteButton;
    private Button analyzeButton;

    public AgentManagerComposite(Composite parent, int style, final Object selection) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        final P2ContentProvider contentProvider = new P2ContentProvider();
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new P2LabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new P2ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AgentManagerComposite.this.selectedElement = ((IStructuredSelection)AgentManagerComposite.this.treeViewer.getSelection()).getFirstElement();
                AgentManagerComposite.this.elementChanged(AgentManagerComposite.this.selectedElement);
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)buttonLayout);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonComposite.setBounds(0, 0, 64, 64);
        this.newAgentButton = new Button(buttonComposite, 0);
        this.newAgentButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newAgentButton.setText("New Agent...");
        this.newAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = AgentManagerComposite.this.openDirectoryDialog("Select the location of the new agent.", PropertiesUtil.USER_HOME);
                if (path != null) {
                    Agent agent = P2Util.getAgentManager().addAgent(new File(path));
                    BundlePool bundlePool = agent.addBundlePool(new File(path, "pool"));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        this.newPoolButton = new Button(buttonComposite, 0);
        this.newPoolButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newPoolButton.setText("New Bundle Pool...");
        this.newPoolButton.setEnabled(false);
        this.newPoolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Agent selectedAgent = (Agent)AgentManagerComposite.this.selectedElement;
                String path = AgentManagerComposite.this.openDirectoryDialog("Select the location of the new pool.", selectedAgent.getLocation().getAbsolutePath());
                if (path != null) {
                    BundlePool bundlePool = selectedAgent.addBundlePool(new File(path));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.deleteButton.setText("Delete...");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentManagerElementImpl agentManagerElement = (AgentManagerElementImpl)AgentManagerComposite.this.selectedElement;
                String type = agentManagerElement.getElementType();
                if (MessageDialog.openQuestion((Shell)AgentManagerComposite.this.getShell(), (String)"Bundle Pool Management", (String)("Are you sure to delete " + type + " " + agentManagerElement + "?\n\nThe physical " + type + " files will remain on disk even if you answer Yes."))) {
                    try {
                        agentManagerElement.delete();
                        AgentManagerComposite.this.treeViewer.refresh();
                    }
                    catch (Exception ex) {
                        P2UIPlugin.INSTANCE.log(ex);
                    }
                }
            }
        });
        this.analyzeButton = new Button(buttonComposite, 0);
        this.analyzeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.analyzeButton.setText("Analyze...");
        this.analyzeButton.setEnabled(false);
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerDialog dialog = new AgentAnalyzerDialog(AgentManagerComposite.this.getShell(), (Agent)AgentManagerComposite.this.selectedElement);
                dialog.open();
                AgentManagerComposite.this.treeViewer.refresh();
            }
        });
        final Button showProfilesButton = new Button(buttonComposite, 32);
        showProfilesButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        showProfilesButton.setText("Show Profiles");
        showProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean showProfiles = showProfilesButton.getSelection();
                contentProvider.setShowProfiles(showProfiles);
                AgentManagerComposite.this.treeViewer.refresh();
            }
        });
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)AgentManagerComposite.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AgentManagerComposite.this.treeViewer.setInput((Object)P2Util.getAgentManager());
                        AgentManagerComposite.this.treeViewer.expandAll();
                    }
                });
                if (selection != null) {
                    AgentManagerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(selection));
                }
            }
        });
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    protected void checkSubclass() {
    }

    protected void elementChanged(Object element) {
        this.newPoolButton.setEnabled(element instanceof Agent);
        this.deleteButton.setEnabled(element instanceof AgentManagerElement && !((AgentManagerElement)element).isUsed());
        this.analyzeButton.setEnabled(element instanceof Agent);
    }

    private String openDirectoryDialog(String message, String path) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText("Bundle Pool Management");
        dialog.setMessage(message);
        dialog.setFilterPath(path);
        return dialog.open();
    }

    private void refreshFor(BundlePool bundlePool) {
        this.treeViewer.refresh();
        this.treeViewer.setExpandedState((Object)bundlePool.getAgent(), true);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)bundlePool));
        this.treeViewer.getTree().setFocus();
    }
}

