/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.bytecode.Field;
import org.eclipse.objectteams.otredyn.bytecode.Member;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.runtime.ClassIdentifierProviderFactory;
import org.eclipse.objectteams.otredyn.runtime.IBinding;
import org.eclipse.objectteams.otredyn.runtime.IBoundClass;
import org.eclipse.objectteams.otredyn.runtime.IMethod;
import org.eclipse.objectteams.otredyn.runtime.ISubclassWiringTask;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer;

public abstract class AbstractBoundClass
implements IBoundClass {
    private Map<Method, WeavingTask> completedBindingTasks;
    private Map<Method, WeavingTask> openBindingTasks;
    private Map<Member, WeavingTask> completedAccessTasks;
    private Map<Member, WeavingTask> openAccessTasks;
    private List<ISubclassWiringTask> wiringTasks;
    private String name;
    private String internalName;
    private String id;
    private String superClassName;
    private String internalSuperClassName;
    private String[] internalSuperInterfaces;
    private AbstractBoundClass superclass;
    private AbstractBoundClass enclosingClass;
    private Map<String, Method> methods;
    private Map<String, Field> fields;
    protected Map<AbstractBoundClass, Object> subclasses;
    private boolean isLoaded;
    private int modifiers;
    private int otClassFlags;
    private boolean implicitTeamActivationEnabled = false;
    private Set<String> methodsForImplicitActivation;
    protected ClassLoader loader;
    protected IWeavingContext weavingContext;

    protected AbstractBoundClass(String name, String id, ClassLoader loader) {
        if (name.indexOf(47) != -1) {
            new RuntimeException(name).printStackTrace(System.out);
        }
        this.name = name;
        this.internalName = name.replace('.', '/');
        this.id = id;
        this.loader = loader;
        this.completedBindingTasks = new IdentityHashMap<Method, WeavingTask>();
        this.openBindingTasks = new IdentityHashMap<Method, WeavingTask>();
        this.openAccessTasks = new IdentityHashMap<Member, WeavingTask>();
        this.completedAccessTasks = new IdentityHashMap<Member, WeavingTask>();
        this.methods = new HashMap<String, Method>();
        this.fields = new HashMap<String, Field>();
        this.subclasses = new IdentityHashMap<AbstractBoundClass, Object>();
        if (!name.equals("AnonymousSubclass")) {
            AbstractBoundClass anonymousSubclass = ClassRepository.getInstance().getAnonymousSubclass(this);
            this.subclasses.put(anonymousSubclass, null);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAnonymous() {
        return this.getName().equals("AnonymousSubclass");
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setSuperClassName(String superClassName) {
        if (superClassName == null) {
            return;
        }
        this.superClassName = superClassName.replace('/', '.');
        this.internalSuperClassName = superClassName.replace('.', '/');
    }

    public void setSuperInterfaces(String[] interfaces) {
        if (interfaces == null) {
            return;
        }
        this.internalSuperInterfaces = interfaces;
    }

    public boolean isJavaLangObject() {
        return this.name.equals("java.lang.Object");
    }

    public boolean isInterface() {
        this.parseBytecode();
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isTeam() {
        this.parseBytecode();
        return (this.modifiers & 0x8000) != 0;
    }

    public int nestingDepth() {
        this.parseBytecode();
        if ((this.modifiers & 8) != 0) {
            return 0;
        }
        if (this.enclosingClass != null) {
            return this.enclosingClass.nestingDepth() + 1;
        }
        return 0;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setOTClassFlags(int flags) {
        this.otClassFlags = flags;
    }

    public boolean isRole() {
        return (this.otClassFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public void enableImplicitActivation() {
        this.implicitTeamActivationEnabled = true;
    }

    public void registerMethodForImplicitActivation(String methodNameAndDesc) {
        if (this.methodsForImplicitActivation == null) {
            this.methodsForImplicitActivation = new HashSet<String>();
        }
        this.methodsForImplicitActivation.add(methodNameAndDesc);
    }

    public boolean hasMethodImplicitActivation(String methodNameAndDesc) {
        if (this.implicitTeamActivationEnabled) {
            return true;
        }
        if (this.methodsForImplicitActivation == null) {
            return false;
        }
        return this.methodsForImplicitActivation.contains(methodNameAndDesc);
    }

    public void transformAtLoadTime(IWeavingContext weavingContext) {
        this.weavingContext = weavingContext;
        this.handleTaskList();
    }

    public void setLoaded() {
        this.isLoaded = true;
    }

    public synchronized AbstractBoundClass getSuperclass() {
        String superclassId;
        this.parseBytecode();
        if (this.superClassName != null && this.superclass == null && (superclassId = ClassIdentifierProviderFactory.getClassIdentifierProvider().getSuperclassIdentifier(this.id, this.internalSuperClassName)) != null) {
            this.superclass = ClassRepository.getInstance().getBoundClass(this.superClassName, superclassId, this.loader);
            this.superclass.addSubclass(this);
        }
        return this.superclass;
    }

    public String[] getSuperInterfaceNames() {
        this.parseBytecode();
        return this.internalSuperInterfaces;
    }

    public synchronized AbstractBoundClass getEnclosingClass() {
        this.parseBytecode();
        int pos = this.internalName.lastIndexOf(36);
        if (pos != -1) {
            String enclosingClassName = this.internalName.substring(0, pos);
            String enclosingClassID = ClassIdentifierProviderFactory.getClassIdentifierProvider().getSuperclassIdentifier(this.id, enclosingClassName);
            if (enclosingClassID != null) {
                this.enclosingClass = ClassRepository.getInstance().getBoundClass(enclosingClassName, enclosingClassID, this.loader);
                this.enclosingClass.addSubclass(this);
            }
        }
        return this.enclosingClass;
    }

    public synchronized String getEnclosingClassName() {
        this.parseBytecode();
        int pos = this.internalName.lastIndexOf(36);
        if (pos != -1) {
            return this.internalName.substring(0, pos);
        }
        return null;
    }

    public abstract void parseBytecode();

    public String getInternalSuperClassName() {
        this.parseBytecode();
        return this.internalSuperClassName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getSuperClassName() {
        this.parseBytecode();
        return this.superClassName;
    }

    public void addMethod(String name, String desc, boolean isStatic, int accessFlags) {
        String methodKey = this.getMethodKey(name, desc);
        Method method = this.methods.get(methodKey);
        if (method == null) {
            method = new Method(name, desc, isStatic, accessFlags);
            method.setImplemented(true);
            this.methods.put(methodKey, method);
        } else {
            method.setImplemented(true);
            method.setStatic(isStatic);
        }
    }

    private String getMethodKey(String name, String desc) {
        int pos = desc.indexOf(41);
        return String.valueOf(name) + desc.substring(0, pos + 1);
    }

    public void addField(String name, String desc, boolean isStatic, int accessFlags) {
        Field field = this.fields.get(name);
        if (field == null) {
            field = new Field(name, desc, isStatic, accessFlags);
            this.fields.put(name, field);
        } else {
            field.setStatic(isStatic);
        }
    }

    public synchronized Method getMethod(String name, String desc, int flags, boolean allowCovariantReturn) {
        this.parseBytecode();
        String methodKey = this.getMethodKey(name, desc);
        Method method = this.methods.get(methodKey);
        if (!allowCovariantReturn && method != null && !method.getSignature().equals(desc)) {
            method = null;
        }
        if (method == null) {
            method = new Method(name, desc, (flags & 2) != 0, 0);
            this.methods.put(methodKey, method);
        }
        return method;
    }

    Method getMethod(WeavingTask task) {
        return this.getMethod(task.getMemberName(), task.getMemberSignature(), task.getBaseFlags(), task.isHandleCovariantReturn());
    }

    Method getMethod(Method method, WeavingTask task) {
        return this.getMethod(method.getName(), method.getSignature(), task.getBaseFlags(), task.isHandleCovariantReturn());
    }

    public synchronized Method getMethod(String name, String desc, boolean allowCovariantReturn, boolean isStatic) {
        this.parseBytecode();
        String methodKey = this.getMethodKey(name, desc);
        Method method = this.methods.get(methodKey);
        if (!allowCovariantReturn && method != null && !method.getSignature().equals(desc)) {
            method = null;
        }
        if (method == null) {
            method = new Method(name, desc);
            method.setStatic(isStatic);
            this.methods.put(methodKey, method);
        }
        assert (method.isStatic() == isStatic) : "Mismatching static/non-static methods " + this.getName() + '.' + name + desc;
        return method;
    }

    public synchronized Field getField(String name, String desc) {
        this.parseBytecode();
        Field field = this.fields.get(name);
        if (field == null) {
            field = new Field(name, desc);
            this.fields.put(name, field);
        }
        return field;
    }

    public String getMethodIdentifier(IMethod method) {
        return String.valueOf(this.getId()) + method.getName() + method.getSignature();
    }

    protected void addSubclass(AbstractBoundClass subclass) {
        this.subclasses.put(subclass, null);
    }

    protected void removeSubclass(AbstractBoundClass subclass) {
        this.subclasses.remove(subclass);
    }

    private Collection<AbstractBoundClass> getSubclasses() {
        return this.subclasses.keySet();
    }

    public synchronized void handleTaskList() {
        WeavingTask newTask;
        WeavingTask task;
        Set<Map.Entry<Method, WeavingTask>> bindingEntrySet = this.openBindingTasks.entrySet();
        Set<Map.Entry<Member, WeavingTask>> accessEntrySet = this.openAccessTasks.entrySet();
        if (bindingEntrySet.size() > 0 || accessEntrySet.size() > 0) {
            this.startTransformation();
            this.parseBytecode();
            this.prepareAsPossibleBaseClass();
            this.prepareTeamActivation();
            this.prepareLiftingParticipant();
        } else if (this.isFirstTransformation()) {
            this.startTransformation();
            this.prepareAsPossibleBaseClass();
            this.prepareTeamActivation();
            this.prepareLiftingParticipant();
            this.endTransformation();
        }
        HashSet<AbstractBoundClass> affectedClasses = new HashSet<AbstractBoundClass>();
        for (Map.Entry<Method, WeavingTask> entry : bindingEntrySet) {
            task = entry.getValue();
            Method method = entry.getKey();
            switch (task.getType()) {
                case WEAVE_BINDING_OF_SUBCLASS: {
                    if (method.isImplemented()) {
                        this.weaveBindingOfSubclass(task);
                        break;
                    }
                    AbstractBoundClass superclass = this.getSuperclass();
                    if (superclass == null) break;
                    superclass.addWeavingTask(task, true);
                    affectedClasses.add(superclass);
                    this.weaveSuperCallInCallOrig(task);
                    break;
                }
                case WEAVE_BINDING: {
                    Object subMethod;
                    AbstractBoundClass subclass;
                    Object superMethod;
                    AbstractBoundClass superclass;
                    if (method.isStatic()) {
                        this.weaveBindingInStaticMethod(task);
                        break;
                    }
                    if (method.isImplemented()) {
                        this.weaveBindingInImplementedMethod(task);
                    } else {
                        this.weaveBindingInNotImplementedMethod(task);
                    }
                    if (this.weavingContext.isWeavable(this.getSuperClassName()) && (superMethod = (superclass = this.getSuperclass()).getMethod(method, task)) != null) {
                        WeavingTask newTask2 = new WeavingTask(WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS, (Method)superMethod, task);
                        superclass.addWeavingTask(newTask2, true);
                        affectedClasses.add(superclass);
                    }
                    superMethod = this.getSubclasses().iterator();
                    while (superMethod.hasNext()) {
                        subclass = (AbstractBoundClass)superMethod.next();
                        subMethod = subclass.getMethod(method, task);
                        newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_BINDING, (Method)subMethod, task);
                        subclass.addWeavingTask(newTask, true);
                        affectedClasses.add(subclass);
                        TeamManager.mergeJoinpoints((IBoundClass)this, (IBoundClass)subclass, (IMethod)method, (IMethod)subMethod, (boolean)task.isHandleCovariantReturn());
                    }
                    break;
                }
                case WEAVE_INHERITED_BINDING: {
                    Object subMethod;
                    AbstractBoundClass subclass;
                    if (method.isImplemented()) {
                        this.weaveBindingInImplementedMethod(task);
                    } else {
                        this.weaveBindingInNotImplementedMethod(task);
                    }
                    this.replaceWickedSuperCalls(this.getSuperclass(), method);
                    Object superMethod = this.getSubclasses().iterator();
                    while (superMethod.hasNext()) {
                        subclass = superMethod.next();
                        subMethod = subclass.getMethod(method, task);
                        newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_BINDING, (Method)subMethod, task);
                        subclass.addWeavingTask(newTask, true);
                        affectedClasses.add(subclass);
                        TeamManager.mergeJoinpoints((IBoundClass)this, (IBoundClass)subclass, (IMethod)method, (IMethod)subMethod, (boolean)task.isHandleCovariantReturn());
                    }
                    break;
                }
            }
            this.completedBindingTasks.put(method, task);
        }
        for (Map.Entry<Member, WeavingTask> entry : accessEntrySet) {
            task = entry.getValue();
            Member member = entry.getKey();
            switch (task.getType()) {
                case WEAVE_FIELD_ACCESS: {
                    this.prepareForFirstMemberAccess();
                    Field field = this.getField(task.getMemberName(), task.getMemberSignature());
                    this.weaveFieldAccess(field, field.getGlobalId(this));
                    if (field.isStatic()) break;
                    for (AbstractBoundClass subclass : this.getSubclasses()) {
                        newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_MEMBER_ACCESS);
                        subclass.addWeavingTask(newTask, true);
                        affectedClasses.add(subclass);
                    }
                    break;
                }
                case WEAVE_METHOD_ACCESS: {
                    this.prepareForFirstMemberAccess();
                    Method method = this.getMethod(task);
                    this.weaveMethodAccess(method, method.getGlobalId(this));
                    if (method.isStatic()) break;
                    for (AbstractBoundClass subclass : this.getSubclasses()) {
                        WeavingTask newTask3 = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_MEMBER_ACCESS);
                        subclass.addWeavingTask(newTask3, true);
                        affectedClasses.add(subclass);
                    }
                    break;
                }
                case WEAVE_INHERITED_MEMBER_ACCESS: {
                    this.prepareForFirstMemberAccess();
                    break;
                }
                case WEAVE_BASE_INFRASTRUCTURE: {
                    this.prepareForFirstTransformation();
                }
            }
            this.completedAccessTasks.put(member, task);
        }
        for (AbstractBoundClass abstractBoundClass : affectedClasses) {
            if (!abstractBoundClass.isLoaded) continue;
            abstractBoundClass.handleTaskList();
        }
        if (this.openBindingTasks.size() > 0 || this.openAccessTasks.size() > 0) {
            this.endTransformation();
        }
        this.openBindingTasks.clear();
        this.openAccessTasks.clear();
    }

    public void handleAddingOfBinding(IBinding binding) {
        WeavingTaskType type = null;
        WeavingTask task = null;
        switch (binding.getType()) {
            case CALLIN_BINDING: {
                type = WeavingTaskType.WEAVE_BINDING;
                break;
            }
            case FIELD_ACCESS: {
                type = WeavingTaskType.WEAVE_FIELD_ACCESS;
                break;
            }
            case METHOD_ACCESS: {
                type = WeavingTaskType.WEAVE_METHOD_ACCESS;
                break;
            }
            case ROLE_BASE_BINDING: {
                task = new WeavingTask(WeavingTaskType.WEAVE_BASE_INFRASTRUCTURE);
                break;
            }
            default: {
                throw new RuntimeException("Unknown binding type: " + binding.getType().name());
            }
        }
        if (task == null) {
            task = new WeavingTask(type, binding.getMemberName(), binding.getMemberSignature(), binding.getBaseFlags(), binding.isHandleCovariantReturn());
        }
        this.addWeavingTask(task, false);
    }

    private void addWeavingTask(WeavingTask task, boolean standBy) {
        boolean isNewTask = this.addWeavingTaskLazy(task);
        if (this.isLoaded && isNewTask && !standBy) {
            this.handleTaskList();
        }
    }

    private boolean addWeavingTaskLazy(WeavingTask task) {
        WeavingTaskType type = task.getType();
        boolean isNewTask = false;
        isNewTask = type == WeavingTaskType.WEAVE_BINDING || type == WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS || type == WeavingTaskType.WEAVE_INHERITED_BINDING ? this.addBindingWeavingTask(task) : this.addAccessWeavingTask(task);
        return isNewTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAccessWeavingTask(WeavingTask task) {
        WeavingTaskType type = task.getType();
        Member member = null;
        switch (type) {
            case WEAVE_FIELD_ACCESS: {
                member = this.getField(task.getMemberName(), task.getMemberSignature());
                break;
            }
            case WEAVE_METHOD_ACCESS: {
                member = this.getMethod(task);
                break;
            }
            case WEAVE_INHERITED_MEMBER_ACCESS: 
            case WEAVE_BASE_INFRASTRUCTURE: {
                this.openAccessTasks.put(null, task);
                return true;
            }
        }
        Method method = member;
        synchronized (method) {
            block10: {
                WeavingTask prevTask = this.completedAccessTasks.get(member);
                if (prevTask == null) {
                    prevTask = this.openAccessTasks.get(member);
                }
                if (prevTask != null) break block10;
                this.openAccessTasks.put(member, task);
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addBindingWeavingTask(WeavingTask task) {
        Method method;
        Method method2 = method = this.getMethod(task);
        synchronized (method2) {
            WeavingTask prevTask = this.completedBindingTasks.get(method);
            if (prevTask == null) {
                prevTask = this.openBindingTasks.get(method);
            }
            if (prevTask == null) {
                task.setDoAllTransformations(true);
                this.openBindingTasks.put(method, task);
                return true;
            }
            switch (prevTask.getType()) {
                case WEAVE_BINDING: {
                    return false;
                }
                case WEAVE_BINDING_OF_SUBCLASS: {
                    if (task.getType() != WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS) {
                        this.openBindingTasks.put(method, task);
                        return true;
                    }
                    return false;
                }
                case WEAVE_INHERITED_BINDING: {
                    return false;
                }
            }
            throw new RuntimeException("Unknown WeavingTaskType: " + prevTask.getType().name());
        }
    }

    protected boolean mergeTasks(AbstractBoundClass clazz) {
        boolean isNewTask = false;
        for (Map.Entry<Method, WeavingTask> entry : clazz.openBindingTasks.entrySet()) {
            isNewTask |= this.addWeavingTaskLazy(entry.getValue());
        }
        for (Map.Entry<Member, WeavingTask> entry : clazz.openAccessTasks.entrySet()) {
            isNewTask |= this.addWeavingTaskLazy(entry.getValue());
        }
        return isNewTask;
    }

    private void weaveBindingInStaticMethod(WeavingTask task) {
        this.prepareForFirstStaticTransformation();
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)this.getMethodIdentifier(method));
        int boundMethodId = method.getGlobalId(this);
        this.moveCodeToCallOrig(method, boundMethodId);
        this.createDispatchCodeInOrgMethod(method, joinpointId, boundMethodId);
    }

    private void weaveBindingInNotImplementedMethod(WeavingTask task) {
        if ((task.getBaseFlags() & 2) == 0) {
            this.prepareForFirstTransformation();
        } else {
            this.prepareForFirstStaticTransformation();
        }
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)this.getMethodIdentifier(method));
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
            boolean isWeavable = true;
            AbstractBoundClass superClass = this.getSuperclass();
            while (superClass != null) {
                if (superClass.isJavaLangObject()) {
                    isWeavable = false;
                    break;
                }
                Method superMethod = superClass.getMethod(task);
                if (superMethod.isImplemented()) {
                    isWeavable = ObjectTeamsTransformer.isWeavable(superClass.getInternalName());
                    break;
                }
                superClass = superClass.getSuperclass();
            }
            if (isWeavable) {
                this.createSuperCallInCallOrig(boundMethodId);
            } else {
                this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, true);
            }
        } else {
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
        }
    }

    private void weaveSuperCallInCallOrig(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.createSuperCallInCallOrig(boundMethodId);
        }
    }

    private void weaveBindingInImplementedMethod(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)this.getMethodIdentifier(method));
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.moveCodeToCallOrig(method, boundMethodId);
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
            this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, false);
        } else {
            this.createDispatchCodeInCallAllBindings(joinpointId, joinpointId);
        }
    }

    private void weaveBindingOfSubclass(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int boundMethodId = method.getGlobalId(this);
        this.moveCodeToCallOrig(method, boundMethodId);
        this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, false);
    }

    protected abstract void replaceWickedSuperCalls(AbstractBoundClass var1, Method var2);

    public String toString() {
        return String.valueOf(this.name) + "[" + this.id + "]";
    }

    protected abstract void startTransformation();

    protected abstract void endTransformation();

    protected abstract void prepareAsPossibleBaseClass();

    protected abstract void prepareTeamActivation();

    protected abstract void prepareLiftingParticipant();

    protected abstract void createSuperCallInCallOrig(int var1);

    protected abstract void createCallAllBindingsCallInOrgMethod(Method var1, int var2, boolean var3);

    protected abstract void createDispatchCodeInCallAllBindings(int var1, int var2);

    protected abstract void moveCodeToCallOrig(Method var1, int var2);

    protected abstract void prepareForFirstTransformation();

    protected abstract void prepareForFirstStaticTransformation();

    public abstract boolean isFirstTransformation();

    protected abstract void createDispatchCodeInOrgMethod(Method var1, int var2, int var3);

    protected abstract void prepareForFirstMemberAccess();

    protected abstract void weaveFieldAccess(Field var1, int var2);

    protected abstract void weaveMethodAccess(Method var1, int var2);

    public abstract boolean isTransformationActive();

    public abstract byte[] getBytecode();

    public void dump(byte[] classfileBuffer, String postfix) {
    }

    public Collection<String> getBoundBaseClasses() {
        return null;
    }

    public abstract int compare(String var1, String var2);

    public void addWiringTask(ISubclassWiringTask wiringTask) {
        if (this.wiringTasks == null) {
            this.wiringTasks = new ArrayList<ISubclassWiringTask>();
        }
        this.wiringTasks.add(wiringTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWiringTasks(AbstractBoundClass superclass, AbstractBoundClass subclass) {
        if (this.wiringTasks == null) {
            return;
        }
        List<ISubclassWiringTask> list = this.wiringTasks;
        synchronized (list) {
            for (ISubclassWiringTask task : this.wiringTasks) {
                task.wire((IBoundClass)superclass, (IBoundClass)subclass);
            }
            this.wiringTasks.clear();
        }
    }

    private static class WeavingTask {
        private WeavingTaskType weavingTaskType;
        private String memberName;
        private String memberSignature;
        private int baseFlags;
        private boolean doAllTransformations;
        private boolean isHandleCovariantReturn;

        public WeavingTask(WeavingTaskType weavingTaskType, String memberName, String memberSignature, int baseFlags, boolean handleCovariantReturn) {
            this.weavingTaskType = weavingTaskType;
            this.memberName = memberName;
            this.memberSignature = memberSignature;
            this.isHandleCovariantReturn = handleCovariantReturn;
            this.baseFlags = baseFlags;
        }

        public WeavingTask(WeavingTaskType weavingTaskType, Method method, WeavingTask upstream) {
            this(weavingTaskType, method.getName(), method.getSignature(), upstream.getBaseFlags(), upstream.isHandleCovariantReturn());
        }

        public WeavingTask(WeavingTaskType type) {
            this(type, null, null, 0, false);
        }

        public WeavingTaskType getType() {
            return this.weavingTaskType;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public String getMemberSignature() {
            return this.memberSignature;
        }

        public int getBaseFlags() {
            return this.baseFlags;
        }

        public boolean doAllTransformations() {
            return this.doAllTransformations;
        }

        public void setDoAllTransformations(boolean doAllTransformations) {
            this.doAllTransformations = doAllTransformations;
        }

        public boolean isHandleCovariantReturn() {
            return this.isHandleCovariantReturn;
        }
    }

    private static enum WeavingTaskType {
        WEAVE_BINDING_OF_SUBCLASS,
        WEAVE_BINDING,
        WEAVE_INHERITED_BINDING,
        WEAVE_METHOD_ACCESS,
        WEAVE_FIELD_ACCESS,
        WEAVE_INHERITED_MEMBER_ACCESS,
        WEAVE_BASE_INFRASTRUCTURE;

    }
}

