/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.utility.Iterate;

@Beta
public class ParallelFlatCollectIterable<T, V>
extends AbstractParallelIterableImpl<V, Batch<V>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> delegate;
    private final Function<? super T, ? extends Iterable<V>> function;

    public ParallelFlatCollectIterable(AbstractParallelIterable<T, ? extends Batch<T>> delegate, Function<? super T, ? extends Iterable<V>> function) {
        this.delegate = delegate;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<V>> split() {
        return this.delegate.split().collect((Function & Serializable)batch -> batch.flatCollect(this.function));
    }

    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach((Procedure & Serializable)each -> Iterate.forEach((Iterable)this.function.valueOf(each), procedure));
    }

    public V detect(Predicate<? super V> predicate) {
        AtomicReference result = new AtomicReference();
        this.delegate.anySatisfy((Predicate & Serializable)each -> Iterate.anySatisfy((Iterable)this.function.valueOf(each), (Predicate & Serializable)each1 -> {
            if (predicate.accept(each1)) {
                result.compareAndSet(null, each1);
                return true;
            }
            return false;
        }));
        return result.get();
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy((Predicate & Serializable)each -> Iterate.anySatisfy((Iterable)this.function.valueOf(each), predicate));
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy((Predicate & Serializable)each -> Iterate.allSatisfy((Iterable)this.function.valueOf(each), predicate));
    }

    public Object[] toArray() {
        return this.delegate.toList().flatCollect(this.function).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().flatCollect(this.function).toArray((Object[])array);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().flatCollect(this.function).groupBy(function);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.delegate.toBag().flatCollect(this.function).groupByEach(function);
    }

    @Override
    public <V1> MapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().flatCollect(this.function).groupByUniqueKey(function);
    }
}

