/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.config;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.action.ClearFilterAction;
import org.eclipse.nebula.widgets.nattable.filterrow.action.ToggleFilterRowAction;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.filterrow.event.ClearFilterIconMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterRowMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.viewport.action.ShowColumnInViewportAction;

public class DefaultFilterRowConfiguration
extends AbstractRegistryConfiguration {
    public FilterRowPainter cellPainter = new FilterRowPainter();
    public TextMatchingMode textMatchingMode = TextMatchingMode.CONTAINS;
    public int showHideKeyConstant = 0x100000C;

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new PaddingDecorator(this.cellPainter, 0, 0, 0, 5), DisplayMode.NORMAL, "FILTER_ROW");
        configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, Boolean.TRUE, DisplayMode.NORMAL, "FILTER_ROW");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, IEditableRule.ALWAYS_EDITABLE, DisplayMode.NORMAL, "FILTER_ROW");
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, this.textMatchingMode);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, new DefaultDisplayConverter());
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, DefaultComparator.getInstance());
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerFirstMouseDownBinding(new FilterRowMouseEventMatcher(), new ShowColumnInViewportAction());
        uiBindingRegistry.registerFirstSingleClickBinding(new FilterRowMouseEventMatcher(), new MouseEditAction());
        uiBindingRegistry.registerFirstSingleClickBinding(new ClearFilterIconMouseEventMatcher(this.cellPainter), new ClearFilterAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(this.showHideKeyConstant), new ToggleFilterRowAction());
    }
}

