/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.InternalClipboardStructuralChangeListener;
import org.eclipse.nebula.widgets.nattable.copy.action.ClearClipboardAction;
import org.eclipse.nebula.widgets.nattable.copy.action.PasteDataAction;
import org.eclipse.nebula.widgets.nattable.copy.action.PasteOrMoveSelectionAction;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.action.DeleteSelectionAction;
import org.eclipse.nebula.widgets.nattable.edit.command.DeleteSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainter;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleEventMatcher;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.FormulaEditDisplayConverter;
import org.eclipse.nebula.widgets.nattable.formula.FormulaResultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.formula.action.FormulaFillHandleDragMode;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.command.FormulaCopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.command.FormulaFillHandlePasteCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.command.FormulaPasteDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.SWT;

public class DefaultFormulaConfiguration
implements IConfiguration {
    private FormulaDataProvider dataProvider;
    private SelectionLayer selectionLayer;
    private InternalCellClipboard clipboard;

    public DefaultFormulaConfiguration(FormulaDataProvider dataProvider, SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        this.dataProvider = dataProvider;
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, IEditableRule.ALWAYS_EDITABLE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, new FormulaEditDisplayConverter(this.dataProvider), DisplayMode.EDIT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, new FormulaResultDisplayConverter(this.dataProvider), DisplayMode.NORMAL, "BODY");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, new TextCellEditor(true, true, true));
        Style copyBorderStyle = new Style();
        copyBorderStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DASHED));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, copyBorderStyle, DisplayMode.NORMAL, "copyBorderStyle");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerFirstKeyBinding(new KeyEventMatcher(127), new DeleteSelectionAction());
        uiBindingRegistry.registerFirstKeyBinding(new KeyEventMatcher(SWT.MOD1, 118), new PasteDataAction());
        uiBindingRegistry.registerFirstKeyBinding(new KeyEventMatcher(0, 13), new PasteOrMoveSelectionAction(this.clipboard));
        uiBindingRegistry.registerFirstKeyBinding(new KeyEventMatcher(0, 27), new ClearClipboardAction(this.clipboard));
        uiBindingRegistry.registerFirstMouseDragMode(new FillHandleEventMatcher((FillHandleLayerPainter)this.selectionLayer.getLayerPainter()), new FormulaFillHandleDragMode(this.selectionLayer, this.clipboard, this.dataProvider));
    }

    @Override
    public void configureLayer(ILayer layer) {
        layer.registerCommandHandler(new DeleteSelectionCommandHandler(this.selectionLayer));
        layer.registerCommandHandler(new ExportCommandHandler(this.selectionLayer));
        this.selectionLayer.registerCommandHandler(new DisableFormulaEvaluationCommandHandler(this.dataProvider));
        this.selectionLayer.registerCommandHandler(new EnableFormulaEvaluationCommandHandler(this.dataProvider));
        this.selectionLayer.addLayerListener(new InternalClipboardStructuralChangeListener(this.clipboard));
        if (!(this.selectionLayer.getLayerPainter() instanceof FillHandleLayerPainter)) {
            this.selectionLayer.setLayerPainter(new FillHandleLayerPainter(this.clipboard));
        } else {
            ((FillHandleLayerPainter)this.selectionLayer.getLayerPainter()).setClipboard(this.clipboard);
        }
        layer.registerCommandHandler(new FormulaCopyDataCommandHandler(this.selectionLayer, this.clipboard));
        layer.registerCommandHandler(new FormulaPasteDataCommandHandler(this.selectionLayer, this.clipboard, this.dataProvider));
        layer.registerCommandHandler(new FormulaFillHandlePasteCommandHandler(this.selectionLayer, this.clipboard, this.dataProvider));
    }
}

