/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class SizeConfig
implements IPersistable {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING = ".percentageSizing";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES = ".percentageSizingIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZES = ".percentageSizes";
    public static final String PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE = ".distributeRemainingSpace";
    public static final String PERSISTENCE_KEY_DEFAULT_MIN_SIZE = ".defaultMinSize";
    public static final String PERSISTENCE_KEY_MIN_SIZES = ".minSizes";
    protected int defaultSize;
    protected final Map<Integer, Integer> defaultSizeMap = new TreeMap<Integer, Integer>();
    protected final Map<Integer, Integer> sizeMap = new TreeMap<Integer, Integer>();
    protected final Map<Integer, Boolean> resizablesMap = new TreeMap<Integer, Boolean>();
    protected boolean resizableByDefault = true;
    protected final Map<Integer, Double> percentageSizeMap = new TreeMap<Integer, Double>();
    protected final Map<Integer, Boolean> percentageSizingMap = new TreeMap<Integer, Boolean>();
    protected boolean percentageSizing = false;
    protected int availableSpace = -1;
    protected final Map<Integer, Integer> realSizeMap = new TreeMap<Integer, Integer>();
    protected final Map<Integer, Integer> aggregatedSizeCacheMap = new HashMap<Integer, Integer>();
    protected boolean isAggregatedSizeCacheValid = true;
    protected IDpiConverter dpiConverter;
    private boolean distributeRemainingSpace = true;
    private int defaultMinSize = 0;
    private final Map<Integer, Integer> minSizeMap = new TreeMap<Integer, Integer>();
    private boolean fixPercentageValuesOnResize = true;

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        this.saveMap(this.defaultSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties);
        this.saveMap(this.sizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        this.saveMap(this.resizablesMap, String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING, String.valueOf(this.percentageSizing));
        this.saveMap(this.percentageSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZES, properties);
        this.saveMap(this.percentageSizingMap, String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE, String.valueOf(this.distributeRemainingSpace));
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_MIN_SIZE, String.valueOf(this.defaultMinSize));
        this.saveMap(this.minSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_MIN_SIZES, properties);
    }

    private void saveMap(Map<Integer, ?> map, String key, Properties properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.setProperty(key, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String persistedDefaultMinSize;
        String persistedDistributeRemainingSpace;
        String persistedPercentageSizing;
        String persistedResizableDefault;
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.percentageSizeMap.clear();
        this.percentageSizingMap.clear();
        this.resizablesMap.clear();
        this.aggregatedSizeCacheMap.clear();
        this.minSizeMap.clear();
        this.resizableByDefault = true;
        this.percentageSizing = false;
        this.distributeRemainingSpace = false;
        this.isAggregatedSizeCacheValid = false;
        this.defaultMinSize = 0;
        String persistedDefaultSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (persistedDefaultSize != null && persistedDefaultSize.length() > 0) {
            this.defaultSize = Integer.valueOf(persistedDefaultSize);
        }
        if ((persistedResizableDefault = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)) != null && persistedResizableDefault.length() > 0) {
            this.resizableByDefault = Boolean.valueOf(persistedResizableDefault);
        }
        if ((persistedPercentageSizing = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING)) != null && persistedPercentageSizing.length() > 0) {
            this.percentageSizing = Boolean.valueOf(persistedPercentageSizing);
        }
        if ((persistedDistributeRemainingSpace = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE)) != null && persistedDistributeRemainingSpace.length() > 0) {
            this.distributeRemainingSpace = Boolean.valueOf(persistedDistributeRemainingSpace);
        }
        if ((persistedDefaultMinSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_MIN_SIZE)) != null && persistedDefaultMinSize.length() > 0) {
            this.defaultMinSize = Integer.valueOf(persistedDefaultMinSize);
        }
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
        this.loadDoubleMap(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZES, properties, this.percentageSizeMap);
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, properties, this.percentageSizingMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_MIN_SIZES, properties, this.minSizeMap);
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    private void loadIntegerMap(String key, Properties properties, Map<Integer, Integer> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Integer.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadBooleanMap(String key, Properties properties, Map<Integer, Boolean> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Boolean.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadDoubleMap(String key, Properties properties, Map<Integer, Double> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Double.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    public void setDefaultSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSize = size;
        this.isAggregatedSizeCacheValid = false;
    }

    public int getDefaultSize() {
        return this.upScale(this.defaultSize);
    }

    public void setDefaultSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSizeMap.put(position, size);
        this.isAggregatedSizeCacheValid = false;
    }

    private int getDefaultSize(int position) {
        Integer size = this.defaultSizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.defaultSize;
    }

    public int getAggregateSize(int position) {
        if (position < 0) {
            return -1;
        }
        if (position == 0) {
            return 0;
        }
        if (this.isAllPositionsSameSize() && !this.isPercentageSizing()) {
            return position * this.upScale(this.defaultSize);
        }
        if (!this.isAggregatedSizeCacheValid) {
            this.aggregatedSizeCacheMap.clear();
            this.isAggregatedSizeCacheValid = true;
        }
        if (!this.aggregatedSizeCacheMap.containsKey(position)) {
            int aggregatedSize = this.calculateAggregatedSize(position);
            this.aggregatedSizeCacheMap.put(position, aggregatedSize);
        }
        return this.aggregatedSizeCacheMap.get(position);
    }

    public int getSize(int position) {
        Integer size = null;
        if (this.isPercentageSizing()) {
            Integer value = this.realSizeMap.get(position);
            if (value != null) {
                return value;
            }
        } else if (this.sizeMap.containsKey(position)) {
            size = this.sizeMap.get(position);
        }
        if (size != null) {
            return this.upScale(size);
        }
        return this.upScale(this.getDefaultSize(position));
    }

    public int getMinSize(int position) {
        if (this.minSizeMap.containsKey(position)) {
            return this.upScale(this.minSizeMap.get(position));
        }
        return this.upScale(this.getDefaultMinSize());
    }

    public void setMinSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.minSizeMap.put(position, size);
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public int getDefaultMinSize() {
        return this.defaultMinSize;
    }

    public void setDefaultMinSize(int defaultMinSize) {
        if (defaultMinSize < 0) {
            throw new IllegalArgumentException("defaultMinSize < 0");
        }
        this.defaultMinSize = defaultMinSize;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public boolean isMinSizeConfigured() {
        return this.defaultMinSize > 0 || !this.minSizeMap.isEmpty();
    }

    public boolean isMinSizeConfigured(int position) {
        return this.minSizeMap.containsKey(position) && this.minSizeMap.get(position) > 0 || this.defaultMinSize > 0;
    }

    public void setSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.isPositionResizable(position)) {
            if (!this.isPercentageSizing(position)) {
                Integer oldValue = this.sizeMap.get(position);
                int diff = oldValue != null ? size - oldValue : size - this.getDefaultSize(position);
                this.sizeMap.put(position, size);
                if (this.isPercentageSizing() && this.fixPercentageValuesOnResize && this.availableSpace > 0) {
                    int percentageSpace = this.calculateAvailableSpace(this.availableSpace);
                    this.fixPercentageValues(percentageSpace);
                    double diffPercentage = (double)diff * 100.0 / (double)percentageSpace;
                    this.updateAdjacent(position, diffPercentage, percentageSpace);
                }
            } else if (this.availableSpace > 0) {
                boolean minSizeUpdate;
                int percentageSpace = this.calculateAvailableSpace(this.availableSpace);
                double percentage = (double)size * 100.0 / (double)percentageSpace;
                boolean bl = minSizeUpdate = this.isMinSizeConfigured(position) && size < this.getMinSize(position);
                if (this.fixPercentageValuesOnResize) {
                    this.fixPercentageValues(percentageSpace);
                }
                Double oldValue = this.percentageSizeMap.get(position);
                double diff = percentage;
                if (oldValue != null && !minSizeUpdate) {
                    diff -= oldValue.doubleValue();
                } else if (this.realSizeMap.containsKey(position)) {
                    double calculated = (double)this.realSizeMap.get(position).intValue() * 100.0 / (double)percentageSpace;
                    diff -= calculated;
                }
                if (minSizeUpdate) {
                    for (Map.Entry<Integer, Double> entry : this.percentageSizeMap.entrySet()) {
                        double calculated;
                        if (entry.getKey() == position || !this.isPercentageSizing(entry.getKey()) || !((calculated = (double)this.realSizeMap.get(entry.getKey()).intValue() * 100.0 / (double)percentageSpace) < entry.getValue())) continue;
                        this.percentageSizeMap.put(entry.getKey(), calculated);
                    }
                    this.setMinSize(position, size);
                }
                this.percentageSizeMap.put(position, percentage);
                diff = this.updateAdjacent(position, diff, percentageSpace);
                if (diff != 0.0 && oldValue == null) {
                    this.percentageSizeMap.remove(position);
                }
            }
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
            this.isAggregatedSizeCacheValid = false;
        }
    }

    private void fixPercentageValues(int percentageSpace) {
        for (Map.Entry<Integer, Integer> entry : this.realSizeMap.entrySet()) {
            int pos = entry.getKey();
            if (!this.isPercentageSizing(pos)) continue;
            if (!this.percentageSizeMap.containsKey(pos)) {
                double calculatedPercentage = (double)entry.getValue().intValue() * 100.0 / (double)percentageSpace;
                this.percentageSizeMap.put(pos, calculatedPercentage);
                continue;
            }
            int calculated = this.calculatePercentageValue(this.percentageSizeMap.get(pos), percentageSpace);
            if (this.isMinSizeConfigured(pos) && calculated < this.getMinSize(pos)) {
                double minPercentageValue = (double)this.getMinSize(pos) * 100.0 / (double)percentageSpace;
                this.percentageSizeMap.put(pos, minPercentageValue);
                continue;
            }
            if (!this.distributeRemainingSpace || !this.realSizeMap.containsKey(pos) || calculated >= this.realSizeMap.get(pos)) continue;
            double distributedPercentageValue = (double)this.realSizeMap.get(pos).intValue() * 100.0 / (double)percentageSpace;
            this.percentageSizeMap.put(pos, distributedPercentageValue);
        }
    }

    private double updateAdjacent(int originalPosition, double diff, int percentageSpace) {
        int nextPosition = originalPosition + 1;
        while (diff != 0.0 && this.realSizeMap.containsKey(nextPosition)) {
            if (this.isPositionResizable(nextPosition)) {
                diff = this.updateAdjacentPosition(nextPosition, diff, percentageSpace);
            }
            ++nextPosition;
        }
        int previousPosition = originalPosition - 1;
        while (diff != 0.0 && this.realSizeMap.containsKey(previousPosition)) {
            if (this.isPositionResizable(previousPosition)) {
                diff = this.updateAdjacentPosition(previousPosition, diff, percentageSpace);
            }
            --previousPosition;
        }
        return diff;
    }

    private double updateAdjacentPosition(int position, double diff, int percentageSpace) {
        boolean percentageConfigured = this.percentageSizeMap.containsKey(position);
        if (percentageConfigured || this.isPercentageSizing(position) && this.realSizeMap.containsKey(position)) {
            if (this.isPercentageSizing(position) && percentageConfigured) {
                double currentValue = this.percentageSizeMap.get(position);
                if (diff < currentValue) {
                    double newPercentageValue = currentValue - diff;
                    if (this.isMinSizeConfigured(position) && this.calculatePercentageValue(newPercentageValue, percentageSpace) < this.getMinSize(position)) {
                        double minPercentageValue = (double)this.getMinSize(position) * 100.0 / (double)percentageSpace;
                        double newDiff = diff - (currentValue - minPercentageValue);
                        this.percentageSizeMap.put(position, minPercentageValue);
                        return newDiff;
                    }
                    this.percentageSizeMap.put(position, newPercentageValue);
                    return 0.0;
                }
                diff -= currentValue + 1.0;
                this.percentageSizeMap.put(position, 1.0);
            }
            return 0.0;
        }
        return diff;
    }

    public void setPercentage(int position, int percentage) {
        this.setPercentage(position, Integer.valueOf(percentage).doubleValue());
    }

    public void setPercentage(int position, double percentage) {
        if (percentage < 0.0) {
            throw new IllegalArgumentException("percentage < 0");
        }
        if (this.isPositionResizable(position)) {
            this.percentageSizingMap.put(position, Boolean.TRUE);
            this.percentageSizeMap.put(position, percentage);
            this.realSizeMap.put(position, this.calculatePercentageValue(percentage, this.availableSpace));
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(int position) {
        Boolean resizable = this.resizablesMap.get(position);
        if (resizable != null) {
            return resizable;
        }
        return this.resizableByDefault;
    }

    public void setPositionResizable(int position, boolean resizable) {
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0 && this.percentageSizeMap.size() == 0;
    }

    public boolean isPercentageSizing() {
        if (!this.percentageSizingMap.isEmpty()) {
            for (Boolean pSize : this.percentageSizingMap.values()) {
                if (!pSize.booleanValue()) continue;
                return true;
            }
        }
        return this.percentageSizing;
    }

    public void setPercentageSizing(boolean percentageSizing) {
        this.percentageSizing = percentageSizing;
        this.isAggregatedSizeCacheValid = false;
    }

    public boolean isPercentageSizing(int position) {
        Boolean percentageSizing = this.percentageSizingMap.get(position);
        if (percentageSizing != null) {
            return percentageSizing;
        }
        return this.percentageSizing;
    }

    public void setPercentageSizing(int position, boolean percentageSizing) {
        this.percentageSizingMap.put(position, percentageSizing);
        this.isAggregatedSizeCacheValid = false;
    }

    public void calculatePercentages(int space, int positionCount) {
        if (space > -1 && this.isPercentageSizing()) {
            double remaining;
            Double remainingColSpace;
            this.isAggregatedSizeCacheValid = false;
            this.availableSpace = space;
            int percentageSpace = this.calculateAvailableSpace(space);
            double sum = 0.0;
            int real = 0;
            int realSum = 0;
            int fixedSum = 0;
            int minSizeIncrease = 0;
            ArrayList<Integer> noInfoPositions = new ArrayList<Integer>();
            ArrayList<Integer> fixedPercentagePositions = new ArrayList<Integer>();
            Integer positionValue = null;
            Double positionPercentageValue = null;
            int i = 0;
            while (i < positionCount) {
                positionValue = this.sizeMap.get(i);
                positionPercentageValue = this.percentageSizeMap.get(i);
                if (positionPercentageValue == null && this.isPercentageSizing(i)) {
                    noInfoPositions.add(i);
                } else if (positionValue == null && !this.isPercentageSizing(i)) {
                    positionValue = this.getDefaultSize(i);
                }
                if (positionPercentageValue != null && this.isPercentageSizing(i)) {
                    int minSize;
                    real = this.calculatePercentageValue(positionPercentageValue, percentageSpace);
                    if (real < (minSize = this.getMinSize(i))) {
                        minSizeIncrease += this.upScale(minSize - real);
                        real = minSize;
                    } else {
                        sum += positionPercentageValue.doubleValue();
                    }
                    fixedPercentagePositions.add(i);
                    realSum += real;
                    this.realSizeMap.put(i, real);
                } else if (positionValue != null) {
                    real = this.upScale(positionValue);
                    fixedSum += real;
                    realSum += real;
                    this.realSizeMap.put(i, real);
                }
                ++i;
            }
            int[] correction = this.correctPercentageValues(sum, positionCount);
            if (correction != null) {
                sum = correction[0];
                realSum = correction[1] + fixedSum;
            }
            if (!fixedPercentagePositions.isEmpty() && realSum > space) {
                ArrayList<Integer> noMinWidth = new ArrayList<Integer>();
                int sumMod = 0;
                Iterator it = fixedPercentagePositions.iterator();
                while (it.hasNext()) {
                    int n = (Integer)it.next();
                    if (this.realSizeMap.get(n).intValue() == this.getMinSize(n)) {
                        sumMod = (int)((double)sumMod + this.percentageSizeMap.get(n));
                        it.remove();
                        continue;
                    }
                    noMinWidth.add(n);
                }
                Iterator iterator = noMinWidth.iterator();
                while (iterator.hasNext()) {
                    int pos2 = (Integer)iterator.next();
                    Double percentage = this.percentageSizeMap.get(pos2);
                    double ratio = percentage / sum;
                    int dist = (int)Math.round((double)minSizeIncrease * ratio);
                    int newValue = this.realSizeMap.get(pos2) - dist;
                    newValue = newValue > 0 ? newValue : 0;
                    realSum -= this.realSizeMap.get(pos2) - newValue;
                    this.realSizeMap.put(pos2, newValue);
                }
                sum += (double)sumMod;
            }
            if (!noInfoPositions.isEmpty() && this.isMinSizeConfigured()) {
                double remaining2 = space - realSum;
                remainingColSpace = remaining2 / (double)noInfoPositions.size();
                Iterator iterator = noInfoPositions.iterator();
                while (iterator.hasNext()) {
                    int position = (Integer)iterator.next();
                    int minSize = this.getMinSize(position);
                    if (!((double)minSize > remainingColSpace)) continue;
                    realSum += minSize;
                    this.realSizeMap.put(position, minSize);
                    iterator.remove();
                }
                if (realSum > space && !fixedPercentagePositions.isEmpty()) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    Iterator it2 = fixedPercentagePositions.iterator();
                    while (it2.hasNext()) {
                        int pos = (Integer)it2.next();
                        if (this.realSizeMap.get(pos).intValue() == this.getMinSize(pos)) continue;
                        arrayList.add(pos);
                    }
                    int exceed = realSum - space;
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        int pos = (Integer)iterator2.next();
                        Double percentage = this.percentageSizeMap.get(pos);
                        double ratio = percentage / sum;
                        int dist = (int)Math.round((double)exceed * ratio);
                        int newValue = this.realSizeMap.get(pos) - dist;
                        newValue = newValue > 0 ? newValue : 0;
                        realSum -= this.realSizeMap.get(pos) - newValue;
                        this.realSizeMap.put(pos, newValue);
                    }
                }
            }
            if (!noInfoPositions.isEmpty()) {
                double remaining3 = space - realSum;
                remainingColSpace = remaining3 / (double)noInfoPositions.size();
                for (Integer n : noInfoPositions) {
                    sum += remainingColSpace / (double)space * 100.0;
                    int minSize = this.getMinSize(n);
                    this.realSizeMap.put(n, remainingColSpace < (double)minSize ? minSize : remainingColSpace.intValue());
                }
                sum = 100.0;
            }
            if (sum < 100.0 && !fixedPercentagePositions.isEmpty() && this.distributeRemainingSpace && (remaining = Double.valueOf(space - realSum).doubleValue()) > 0.0) {
                double eligibleSum = 0.0;
                Iterator minSize = fixedPercentagePositions.iterator();
                while (minSize.hasNext()) {
                    int pos = (Integer)minSize.next();
                    eligibleSum += this.percentageSizeMap.get(pos).doubleValue();
                }
                minSize = fixedPercentagePositions.iterator();
                while (minSize.hasNext()) {
                    int pos = (Integer)minSize.next();
                    if (this.getMinSize(pos) == this.realSizeMap.get(pos).intValue()) continue;
                    Double percentage = this.percentageSizeMap.get(pos);
                    double ratio = percentage / eligibleSum;
                    int dist = (int)(remaining * ratio);
                    this.realSizeMap.put(pos, this.realSizeMap.get(pos) + dist);
                }
                sum = 100.0;
            }
            if (sum == 100.0) {
                int valueSum = 0;
                int lastPos = -1;
                for (Map.Entry<Integer, Integer> entry : this.realSizeMap.entrySet()) {
                    valueSum += entry.getValue().intValue();
                    lastPos = Math.max(lastPos, entry.getKey());
                }
                if (space > 0 && valueSum < space) {
                    int missingPixels = space - valueSum;
                    boolean bl = false;
                    int i2 = missingPixels;
                    while (i2 > 0) {
                        int n;
                        if (!this.realSizeMap.containsKey(n)) {
                            n = 0;
                        }
                        Integer posValue = this.realSizeMap.get(n);
                        while (!(posValue == null || posValue != 0 && this.isPercentageSizing(n) && this.getMinSize(n) != posValue.intValue())) {
                            posValue = this.realSizeMap.get(++n);
                        }
                        if (posValue != null) {
                            this.realSizeMap.put(n, posValue + 1);
                            ++n;
                        }
                        --i2;
                    }
                }
            }
            if (realSum > this.availableSpace) {
                int extend = realSum - this.availableSpace;
                while (extend > 0) {
                    int remainingExtend = this.correctExtend(extend, fixedPercentagePositions);
                    extend = remainingExtend == extend ? 0 : remainingExtend;
                }
            }
        }
    }

    private int calculatePercentageValue(double percentage, int space) {
        double factor = percentage / 100.0;
        return (int)((double)space * factor);
    }

    protected int calculateAvailableSpace(int space) {
        if (!this.percentageSizingMap.isEmpty() && this.percentageSizing) {
            for (Map.Entry<Integer, Boolean> entry : this.percentageSizingMap.entrySet()) {
                if (entry.getValue().booleanValue() || !this.sizeMap.containsKey(entry.getKey())) continue;
                space -= this.upScale(this.sizeMap.get(entry.getKey()));
            }
        }
        return space;
    }

    @Deprecated
    protected int[] correctPercentageValues(int sum, int positionCount) {
        return this.correctPercentageValues(Integer.valueOf(sum).doubleValue(), positionCount);
    }

    protected int[] correctPercentageValues(double sum, int positionCount) {
        TreeMap<Integer, Integer> toModify = new TreeMap<Integer, Integer>();
        int fixedSum = 0;
        double modifySum = 0.0;
        int i = 0;
        while (i < positionCount) {
            Integer positionValue = this.sizeMap.get(i);
            Double positionPercentageValue = this.percentageSizeMap.get(i);
            if (positionPercentageValue != null && this.isPercentageSizing(i) && (!this.isMinSizeConfigured(i) || this.isMinSizeConfigured(i) && this.realSizeMap.get(i).intValue() != this.getMinSize(i))) {
                toModify.put(i, this.realSizeMap.get(i));
                modifySum += positionPercentageValue.doubleValue();
            } else if (!this.isPercentageSizing(i) && positionValue != null) {
                fixedSum += positionValue.intValue();
            }
            ++i;
        }
        if (sum > 100.0) {
            double excess = sum - 100.0;
            int excessPixel = (int)((double)(this.availableSpace - fixedSum) * excess / 100.0);
            double newPercentageSum = 0.0;
            int realSum = 0;
            for (Map.Entry mod : toModify.entrySet()) {
                double ratio = this.percentageSizeMap.get(mod.getKey()) / modifySum;
                int exc = (int)Math.ceil((double)excessPixel * ratio);
                int newValue = (Integer)mod.getValue() - exc;
                if (this.isMinSizeConfigured((Integer)mod.getKey()) && newValue < this.getMinSize((Integer)mod.getKey())) {
                    newValue = this.getMinSize((Integer)mod.getKey());
                }
                double newPercentage = Double.valueOf(newValue) / Double.valueOf(this.availableSpace - fixedSum) * 100.0;
                newPercentageSum += newPercentage;
                realSum += newValue;
                this.realSizeMap.put((Integer)mod.getKey(), newValue);
            }
            if (newPercentageSum > 100.0 && excessPixel > 0) {
                return this.correctPercentageValues(newPercentageSum, positionCount);
            }
            return new int[]{100, realSum};
        }
        return null;
    }

    private int calculateAggregatedSize(int position) {
        int size;
        int resizeAggregate = 0;
        int resizedColumns = 0;
        boolean percentageSizing = this.isPercentageSizing();
        Map<Integer, Integer> mapToUse = percentageSizing ? this.realSizeMap : this.sizeMap;
        for (Integer resizedPosition : mapToUse.keySet()) {
            if (resizedPosition >= position) break;
            ++resizedColumns;
            size = mapToUse.get(resizedPosition);
            resizeAggregate += percentageSizing ? size : this.upScale(size);
        }
        for (Integer defaultPosition : this.defaultSizeMap.keySet()) {
            if (defaultPosition >= position) break;
            if (mapToUse.containsKey(defaultPosition)) continue;
            ++resizedColumns;
            size = this.defaultSizeMap.get(defaultPosition);
            resizeAggregate += this.upScale(size);
        }
        int result = (position - resizedColumns) * this.upScale(this.defaultSize);
        return result += resizeAggregate;
    }

    private int correctExtend(int extend, List<Integer> fixedPercentagePositions) {
        int remainingExtend = extend;
        double eligibleSum = 0.0;
        for (int pos : fixedPercentagePositions) {
            eligibleSum += this.percentageSizeMap.get(pos).doubleValue();
        }
        for (int pos : fixedPercentagePositions) {
            if (remainingExtend <= 0 || this.getMinSize(pos) == this.realSizeMap.get(pos).intValue()) continue;
            Double percentage = this.percentageSizeMap.get(pos);
            double ratio = percentage / eligibleSum;
            int dist = extend == 1 ? 1 : (int)((double)extend * ratio);
            int oldValue = this.realSizeMap.get(pos);
            int newValue = oldValue - dist;
            if (this.isMinSizeConfigured(pos) && newValue < this.getMinSize(pos)) {
                newValue = this.getMinSize(pos);
                dist = oldValue - newValue;
            } else if (newValue < 0) {
                newValue = 0;
                dist = oldValue;
            }
            this.realSizeMap.put(pos, newValue);
            remainingExtend -= dist;
        }
        return remainingExtend;
    }

    public void updatePercentageValues(int positionCount) {
        this.calculatePercentages(this.availableSpace, positionCount);
    }

    public int upScale(int value) {
        if (this.dpiConverter == null) {
            return value;
        }
        return this.dpiConverter.convertPixelToDpi(value);
    }

    public int downScale(int value) {
        if (this.dpiConverter == null) {
            return value;
        }
        return this.dpiConverter.convertDpiToPixel(value);
    }

    public void setDpiConverter(IDpiConverter dpiConverter) {
        this.dpiConverter = dpiConverter;
        this.isAggregatedSizeCacheValid = false;
    }

    public void reset() {
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.resizablesMap.clear();
        this.percentageSizeMap.clear();
        this.percentageSizingMap.clear();
        this.realSizeMap.clear();
        this.aggregatedSizeCacheMap.clear();
        this.minSizeMap.clear();
    }

    public void resetConfiguredSize(int position) {
        this.sizeMap.remove(position);
        this.percentageSizeMap.remove(position);
        this.isAggregatedSizeCacheValid = false;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public void resetConfiguredMinSize(int position) {
        this.minSizeMap.remove(position);
        this.isAggregatedSizeCacheValid = false;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public int getConfiguredSize(int position) {
        Integer configuredSize = this.sizeMap.get(position);
        return configuredSize != null ? configuredSize : -1;
    }

    public double getConfiguredPercentageSize(int position) {
        Double configuredSize = this.percentageSizeMap.get(position);
        return configuredSize != null ? configuredSize : -1.0;
    }

    public int getConfiguredMinSize(int position) {
        Integer configuredMinSize = this.minSizeMap.get(position);
        return configuredMinSize != null ? configuredMinSize : -1;
    }

    public boolean isDistributeRemainingSpace() {
        return this.distributeRemainingSpace;
    }

    public void setDistributeRemainingSpace(boolean distributeRemaining) {
        this.distributeRemainingSpace = distributeRemaining;
    }

    public boolean isFixPercentageValuesOnResize() {
        return this.fixPercentageValuesOnResize;
    }

    public void setFixPercentageValuesOnResize(boolean enabled) {
        this.fixPercentageValuesOnResize = enabled;
    }
}

