/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;

public class BindingTable {
    public static final BindingComparator BEST_SEQUENCE = new BindingComparator();
    private Context tableId;
    private ArrayList<Binding> bindings = new ArrayList();
    private Map<TriggerSequence, Binding> bindingsByTrigger = new HashMap<TriggerSequence, Binding>();
    private Map<ParameterizedCommand, ArrayList<Binding>> bindingsByCommand = new HashMap<ParameterizedCommand, ArrayList<Binding>>();
    private Map<TriggerSequence, ArrayList<Binding>> bindingsByPrefix = new HashMap<TriggerSequence, ArrayList<Binding>>();
    private Map<TriggerSequence, ArrayList<Binding>> conflicts = new HashMap<TriggerSequence, ArrayList<Binding>>();
    private Map<TriggerSequence, ArrayList<Binding>> orderedBindingsByTrigger = new HashMap<TriggerSequence, ArrayList<Binding>>();

    private static int compareSchemes(String[] activeSchemeIds, String schemeId1, String schemeId2) {
        if (activeSchemeIds == null || activeSchemeIds.length == 0) {
            return 0;
        }
        if (!schemeId2.equals(schemeId1)) {
            int i = 0;
            while (i < activeSchemeIds.length) {
                String schemePointer = activeSchemeIds[i];
                if (schemeId2.equals(schemePointer)) {
                    return 1;
                }
                if (schemeId1.equals(schemePointer)) {
                    return -1;
                }
                ++i;
            }
        }
        return 0;
    }

    public BindingTable(Context context) {
        this.tableId = context;
    }

    public Context getTableId() {
        return this.tableId;
    }

    public String getId() {
        return this.tableId.getId();
    }

    public Collection<Binding> getConflicts() {
        ArrayList<Binding> conflictsList = new ArrayList<Binding>();
        for (ArrayList<Binding> conflictsForTrigger : this.conflicts.values()) {
            if (conflictsForTrigger == null) continue;
            conflictsList.addAll(conflictsForTrigger);
        }
        return conflictsList;
    }

    public Collection<Binding> getConflictsFor(TriggerSequence triggerSequence) {
        return this.conflicts.get(triggerSequence);
    }

    public void addBinding(Binding binding) {
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        ArrayList<Object> bindingList = this.orderedBindingsByTrigger.get(binding.getTriggerSequence());
        Binding possibleConflict = this.bindingsByTrigger.get(binding.getTriggerSequence());
        if (bindingList == null || bindingList.isEmpty()) {
            if (possibleConflict != null) {
                if (bindingList == null) {
                    bindingList = new ArrayList();
                    this.orderedBindingsByTrigger.put(binding.getTriggerSequence(), bindingList);
                }
                bindingList.add(binding);
                bindingList.add(possibleConflict);
                Collections.sort(bindingList, BEST_SEQUENCE);
            }
        } else {
            bindingList.add(binding);
            Collections.sort(bindingList, BEST_SEQUENCE);
        }
        if (possibleConflict != null && bindingList != null && !bindingList.isEmpty() && bindingList.get(0) != possibleConflict) {
            this.removeBindingSimple(possibleConflict);
            possibleConflict = null;
        }
        this.evaluateOrderedBindings(binding.getTriggerSequence(), binding);
    }

    private void addBindingSimple(Binding binding) {
        this.bindings.add(binding);
        this.bindingsByTrigger.put(binding.getTriggerSequence(), binding);
        ArrayList<Object> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
        if (sequences == null) {
            sequences = new ArrayList();
            this.bindingsByCommand.put(binding.getParameterizedCommand(), sequences);
        }
        sequences.add(binding);
        Collections.sort(sequences, BEST_SEQUENCE);
        TriggerSequence[] prefs = binding.getTriggerSequence().getPrefixes();
        int i = 1;
        while (i < prefs.length) {
            ArrayList<Object> bindings = this.bindingsByPrefix.get(prefs[i]);
            if (bindings == null) {
                bindings = new ArrayList();
                this.bindingsByPrefix.put(prefs[i], bindings);
            }
            bindings.add(binding);
            ++i;
        }
    }

    private void removeBindingSimple(Binding binding) {
        this.bindings.remove(binding);
        this.bindingsByTrigger.remove(binding.getTriggerSequence());
        ArrayList<Binding> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
        if (sequences != null) {
            sequences.remove(binding);
        }
        TriggerSequence[] prefs = binding.getTriggerSequence().getPrefixes();
        int i = 1;
        while (i < prefs.length) {
            ArrayList<Binding> bindings = this.bindingsByPrefix.get(prefs[i]);
            if (bindings != null) {
                bindings.remove(binding);
            }
            ++i;
        }
    }

    public void removeBinding(Binding binding) {
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        ArrayList<Binding> bindingList = this.orderedBindingsByTrigger.get(binding.getTriggerSequence());
        Binding possibleConflict = this.bindingsByTrigger.get(binding.getTriggerSequence());
        if (possibleConflict == binding) {
            this.removeBindingSimple(binding);
            if (bindingList != null) {
                bindingList.remove(binding);
                if (bindingList.isEmpty()) {
                    this.orderedBindingsByTrigger.remove(binding.getTriggerSequence());
                } else {
                    this.evaluateOrderedBindings(binding.getTriggerSequence(), null);
                }
            }
        } else if (bindingList != null) {
            bindingList.remove(binding);
            if (bindingList.isEmpty()) {
                this.orderedBindingsByTrigger.remove(binding.getTriggerSequence());
            } else {
                this.evaluateOrderedBindings(binding.getTriggerSequence(), null);
            }
        }
    }

    private void evaluateOrderedBindings(TriggerSequence sequence, Binding binding) {
        ArrayList<Binding> bindingList = this.orderedBindingsByTrigger.get(sequence);
        if (bindingList != null) {
            if (bindingList.isEmpty()) {
                this.orderedBindingsByTrigger.remove(sequence);
            } else if (bindingList.size() > 1) {
                Binding msb = bindingList.get(0);
                Binding lsb = bindingList.get(1);
                int rc = BindingTable.compareSchemes(BEST_SEQUENCE.getActiveSchemes(), msb.getSchemeId(), lsb.getSchemeId());
                if (rc == 0) {
                    ArrayList<Object> conflictList = this.conflicts.get(sequence);
                    if (conflictList == null) {
                        conflictList = new ArrayList();
                        this.conflicts.put(sequence, conflictList);
                    } else {
                        conflictList.clear();
                    }
                    Iterator<Binding> i = bindingList.iterator();
                    Binding prev = i.next();
                    conflictList.add(prev);
                    while (i.hasNext() && rc == 0) {
                        Binding next = i.next();
                        rc = BindingTable.compareSchemes(BEST_SEQUENCE.getActiveSchemes(), prev.getSchemeId(), next.getSchemeId());
                        if (rc == 0) {
                            conflictList.add(next);
                        }
                        prev = next;
                    }
                } else {
                    this.conflicts.remove(sequence);
                    if (this.bindingsByTrigger.get(sequence) == null) {
                        this.addBindingSimple(msb);
                    }
                }
            } else {
                if (this.bindingsByTrigger.get(sequence) == null) {
                    this.addBindingSimple(bindingList.get(0));
                }
                this.orderedBindingsByTrigger.remove(sequence);
            }
        } else if (binding != null) {
            this.conflicts.remove(sequence);
            if (this.bindingsByTrigger.get(sequence) == null) {
                this.addBindingSimple(binding);
            }
        }
    }

    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingsByTrigger.get(trigger);
    }

    public Binding getBestSequenceFor(ParameterizedCommand command) {
        ArrayList<Binding> sequences = this.bindingsByCommand.get(command);
        if (sequences != null && sequences.size() > 0) {
            return sequences.get(0);
        }
        return null;
    }

    public Collection<Binding> getSequencesFor(ParameterizedCommand command) {
        ArrayList<Binding> triggers = this.bindingsByCommand.get(command);
        return (Collection)(triggers == null ? Collections.EMPTY_LIST : triggers.clone());
    }

    public Collection<Binding> getPartialMatches(TriggerSequence sequence) {
        return this.bindingsByPrefix.get(sequence);
    }

    public boolean isPartialMatch(TriggerSequence seq) {
        return this.bindingsByPrefix.get(seq) != null;
    }

    public Collection<Binding> getBindings() {
        return Collections.unmodifiableCollection(this.bindings);
    }

    static class BindingComparator
    implements Comparator<Binding> {
        private String[] activeSchemeIds;

        BindingComparator() {
        }

        public void setActiveSchemes(String[] activeSchemeIds) {
            this.activeSchemeIds = activeSchemeIds;
        }

        public String[] getActiveSchemes() {
            return this.activeSchemeIds;
        }

        @Override
        public int compare(Binding o1, Binding o2) {
            Trigger[] currentTriggers;
            int rc = BindingTable.compareSchemes(this.activeSchemeIds, o1.getSchemeId(), o2.getSchemeId());
            if (rc != 0) {
                return rc;
            }
            Trigger[] bestTriggers = o1.getTriggerSequence().getTriggers();
            int compareTo = bestTriggers.length - (currentTriggers = o2.getTriggerSequence().getTriggers()).length;
            if (compareTo != 0) {
                return compareTo;
            }
            compareTo = this.countStrokes(bestTriggers) - this.countStrokes(currentTriggers);
            if (compareTo != 0) {
                return compareTo;
            }
            return o1.getTriggerSequence().format().length() - o2.getTriggerSequence().format().length();
        }

        private final int countStrokes(Trigger[] triggers) {
            int strokeCount = triggers.length;
            int i = 0;
            while (i < triggers.length) {
                Trigger trigger = triggers[i];
                if (trigger instanceof KeyStroke) {
                    IKeyLookup lookup;
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    int modifierKeys = keyStroke.getModifierKeys();
                    if ((modifierKeys & (lookup = KeyLookupFactory.getDefault()).getAlt()) != 0) {
                        strokeCount += 8;
                    }
                    if ((modifierKeys & lookup.getCtrl()) != 0) {
                        strokeCount += 2;
                    }
                    if ((modifierKeys & lookup.getShift()) != 0) {
                        strokeCount += 4;
                    }
                    if ((modifierKeys & lookup.getCommand()) != 0) {
                        strokeCount += 2;
                    }
                } else {
                    strokeCount += 99;
                }
                ++i;
            }
            return strokeCount;
        }
    }
}

