/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._150_Column_and_row_grouping;

import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.poi.HSSFExcelExporter;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.stack.ColumnGroupBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class _000_Column_groups
extends AbstractNatExample {
    private final ColumnGroupModel columnGroupModel = new ColumnGroupModel();
    private ColumnHeaderLayer columnHeaderLayer;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(800, 400, new _000_Column_groups());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates column grouping functionality:\n\n* GROUP SELECTED COLUMNS with ctrl-g.\n* UNGROUP SELECTED COLUMNS with ctrl-u.\n* EXPAND/COLLAPSE A COLUMN GROUP by double-clicking on the column group header.\n* DRAG COLUMNS IN/OUT OF COLUMN GROUPS: If a column is dragged to the beginning of a column group, it is included in the column group. If it is dragged to the end of a column group, it is removed from the column group.\n* POPUP MENU: Right-clicking on a column in the column header will bring up a popup menu that will allow you to HIDE, SHOW or AUTO-RESIZE the selected columns (note: auto-resize takes a while because there are a lot of rows). There is also an option to launch the COLUMN CHOOSER dialog.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = RowDataListFixture.getPropertyNames();
        Map propertyToLabelMap = RowDataListFixture.getPropertyToLabelMap();
        DefaultBodyDataProvider bodyDataProvider = new DefaultBodyDataProvider(RowDataListFixture.getList((int)200), propertyNames);
        ColumnGroupBodyLayerStack bodyLayer = new ColumnGroupBodyLayerStack((IUniqueIndexLayer)new DataLayer((IDataProvider)bodyDataProvider), new ColumnGroupModel[]{this.columnGroupModel});
        DefaultColumnHeaderDataProvider defaultColumnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)defaultColumnHeaderDataProvider);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)this.columnHeaderLayer, bodyLayer.getSelectionLayer(), this.columnGroupModel);
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Group 1", new int[]{1, 2});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("UnBreakable group 2", new int[]{4, 5, 6, 7});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("UnBreakable group 3", new int[]{8, 9, 10});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Group 4", new int[]{11, 12, 13});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Group 5", new int[]{14, 15, 16, 17});
        columnGroupHeaderLayer.setStaticColumnIndexesByGroup("Group 5", new int[]{15, 17});
        columnGroupHeaderLayer.setGroupUnbreakable(4);
        columnGroupHeaderLayer.setGroupUnbreakable(8);
        columnGroupHeaderLayer.setGroupAsCollapsed(11);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)defaultColumnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnGroupHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayer, (ILayer)columnGroupHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(bodyLayer.getSelectionLayer(), bodyLayer.getColumnHideShowLayer(), this.columnHeaderLayer, (DataLayer)columnHeaderDataLayer, columnGroupHeaderLayer, this.columnGroupModel);
        bodyLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withColumnChooserMenuItem();
            }
        });
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)new HSSFExcelExporter());
            }
        });
        final Menu columnGroupHeaderMenu = new PopupMenuBuilder(natTable).withRenameColumnGroupMenuItem().withRemoveColumnGroupMenuItem().build();
        natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerFirstMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_GROUP_HEADER", 3), (IMouseAction)new PopupMenuAction(columnGroupHeaderMenu));
            }
        });
        natTable.configure();
        return natTable;
    }
}

