/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._700_AdditionalFunctions;

import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _751_CopyExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _751_CopyExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to register a different copy handling for a NatTable grid that adds the header information to the copied body values and uses the configured IDisplayConverter to create the String representation of the copied values.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        DefaultBodyDataProvider bodyDataProvider = new DefaultBodyDataProvider(PersonService.getPersons((int)100), propertyNames);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        CopyDataCommandHandler copyHandler = new CopyDataCommandHandler(selectionLayer, (ILayer)columnHeaderDataLayer, (ILayer)rowHeaderDataLayer);
        copyHandler.setCopyFormattedText(true);
        gridLayer.registerCommandHandler((ILayerCommandHandler)copyHandler);
        final NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button addColumnButton = new Button(buttonPanel, 8);
        addColumnButton.setText("Copy");
        addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new CopyDataToClipboardCommand("\t", System.getProperty("line.separator"), natTable.getConfigRegistry()));
            }
        });
        return panel;
    }
}

