/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.Address;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _509_SortHeaderLayerExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _509_SortHeaderLayerExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the SortHeaderLayer within a grid that uses a custom ISortModel.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        List data = PersonService.getPersonsWithAddress((int)10);
        ReflectiveColumnPropertyAccessor accessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(data, (IColumnAccessor)accessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        ConfigRegistry configRegistry = new ConfigRegistry();
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new PersonWithAddressSortModel(data));
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.configure();
        return natTable;
    }

    class PersonWithAddressSortModel
    implements ISortModel {
        protected SortDirectionEnum[] sortDirections;
        protected boolean[] sorted;
        protected int currentSortColumn = -1;
        protected SortDirectionEnum currentSortDirection = SortDirectionEnum.ASC;
        private List<PersonWithAddress> persons;

        public PersonWithAddressSortModel(List<PersonWithAddress> persons) {
            this.persons = persons;
            this.sortDirections = new SortDirectionEnum[9];
            Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
            this.sorted = new boolean[9];
            Arrays.fill(this.sorted, false);
            this.sort(0, SortDirectionEnum.ASC, false);
        }

        public List<Integer> getSortedColumnIndexes() {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            if (this.currentSortColumn > -1) {
                indexes.add(this.currentSortColumn);
            }
            return indexes;
        }

        public boolean isColumnIndexSorted(int columnIndex) {
            return this.sorted[columnIndex];
        }

        public SortDirectionEnum getSortDirection(int columnIndex) {
            return this.sortDirections[columnIndex];
        }

        public int getSortOrder(int columnIndex) {
            return 0;
        }

        public void clear() {
            Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
            Arrays.fill(this.sorted, false);
            this.currentSortColumn = -1;
        }

        public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
            if (!this.isColumnIndexSorted(columnIndex)) {
                this.clear();
            }
            if (sortDirection.equals((Object)SortDirectionEnum.NONE)) {
                sortDirection = SortDirectionEnum.ASC;
            }
            Collections.sort(this.persons, new PersonWithAddressComparator(columnIndex, sortDirection));
            this.sortDirections[columnIndex] = sortDirection;
            this.sorted[columnIndex] = !sortDirection.equals((Object)SortDirectionEnum.NONE);
            this.currentSortColumn = columnIndex;
            this.currentSortDirection = sortDirection;
        }

        public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
            return null;
        }

        public Comparator<?> getColumnComparator(int columnIndex) {
            return null;
        }

        class PersonWithAddressComparator
        implements Comparator<PersonWithAddress> {
            int colIdx = 0;
            SortDirectionEnum sortDirection;

            public PersonWithAddressComparator(int columnIndex, SortDirectionEnum sortDirection) {
                this.colIdx = columnIndex;
                this.sortDirection = sortDirection;
            }

            @Override
            public int compare(PersonWithAddress pwa1, PersonWithAddress pwa2) {
                Object compareObject1 = null;
                Object compareObject2 = null;
                Address address1 = pwa1.getAddress();
                Address address2 = pwa2.getAddress();
                switch (this.colIdx) {
                    case 0: {
                        compareObject1 = pwa1.getFirstName();
                        compareObject2 = pwa2.getFirstName();
                        break;
                    }
                    case 1: {
                        compareObject1 = pwa1.getLastName();
                        compareObject2 = pwa2.getLastName();
                        break;
                    }
                    case 2: {
                        compareObject1 = pwa1.getGender().ordinal();
                        compareObject2 = pwa2.getGender().ordinal();
                        break;
                    }
                    case 3: {
                        compareObject1 = pwa1.isMarried();
                        compareObject2 = pwa2.isMarried();
                        break;
                    }
                    case 4: {
                        compareObject1 = pwa1.getBirthday();
                        compareObject2 = pwa2.getBirthday();
                        break;
                    }
                    case 5: {
                        compareObject1 = address1.getStreet();
                        compareObject2 = address2.getStreet();
                        break;
                    }
                    case 6: {
                        compareObject1 = address1.getHousenumber();
                        compareObject2 = address2.getHousenumber();
                        break;
                    }
                    case 7: {
                        compareObject1 = address1.getPostalCode();
                        compareObject2 = address2.getPostalCode();
                        break;
                    }
                    case 8: {
                        compareObject1 = address1.getCity();
                        compareObject2 = address2.getCity();
                    }
                }
                int result = 0;
                result = compareObject1 == null ? (compareObject2 != null ? -1 : 0) : (compareObject2 != null ? compareObject1.compareTo(compareObject2) : 1);
                if (this.sortDirection.equals((Object)SortDirectionEnum.DESC)) {
                    result *= -1;
                }
                return result;
            }
        }
    }
}

