/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayer
extends AbstractRowHideShowLayer {
    public static final String TREE_COLUMN_CELL = "TREE_COLUMN_CELL";
    public static final int TREE_COLUMN_NUMBER = 0;
    private final ITreeRowModel<?> treeRowModel;
    private final Set<Integer> hiddenRowIndexes;
    private IndentedTreeImagePainter indentedTreeImagePainter;
    private ICellPainter treeImagePainter;

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel) {
        this(underlyingLayer, treeRowModel, true);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.treeRowModel = treeRowModel;
        this.hiddenRowIndexes = new TreeSet<Integer>();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultTreeLayerConfiguration(this));
        }
        this.indentedTreeImagePainter = new IndentedTreeImagePainter(treeRowModel);
        this.treeImagePainter = this.indentedTreeImagePainter.getTreeImagePainter();
        this.registerCommandHandler(new TreeExpandCollapseCommandHandler(this));
    }

    public ITreeRowModel<?> getModel() {
        return this.treeRowModel;
    }

    public ICellPainter getTreeImagePainter() {
        return this.treeImagePainter;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack stack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (columnPosition == 0) {
            stack.addLabelOnTop(TREE_COLUMN_CELL);
        }
        return stack;
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        LabelStack stack = super.getRegionLabelsByXY(x, y);
        if (this.getColumnPositionByX(x) == 0) {
            stack.addLabelOnTop(TREE_COLUMN_CELL);
        }
        return stack;
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        ICellPainter cellPainter = super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        if (columnPosition == 0) {
            cellPainter = new BackgroundPainter(new CellPainterDecorator(cellPainter, CellEdgeEnum.LEFT, this.indentedTreeImagePainter));
        }
        return cellPainter;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return this.hiddenRowIndexes;
    }

    public void expandOrCollapseIndex(int parentIndex) {
        if (this.treeRowModel.isCollapsed(parentIndex)) {
            this.expandTreeRow(parentIndex);
        } else {
            this.collapseTreeRow(parentIndex);
        }
    }

    public void collapseTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.collapse(parentIndex);
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        for (Integer rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions));
    }

    public void expandTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.expand(parentIndex);
        this.hiddenRowIndexes.removeAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }
}

