/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tickupdate.ITickUpdateHandler;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tickupdate.command.TickUpdateCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TickUpdateCommandHandler
extends AbstractLayerCommandHandler<TickUpdateCommand> {
    private SelectionLayer selectionLayer;

    public TickUpdateCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(TickUpdateCommand command) {
        PositionCoordinate[] selectedPositions = this.selectionLayer.getSelectedCellPositions();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        if (selectedPositions.length > 1) {
            ICellEditor lastSelectedCellEditor = EditUtils.lastSelectedCellEditor(this.selectionLayer, configRegistry);
            if (EditUtils.isEditorSame(this.selectionLayer, configRegistry, lastSelectedCellEditor) && EditUtils.allCellsEditable(this.selectionLayer, configRegistry)) {
                PositionCoordinate[] positionCoordinateArray = selectedPositions;
                int n = selectedPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionCoordinate position = positionCoordinateArray[n2];
                    this.updateSingleCell(command, position);
                    ++n2;
                }
            }
        } else {
            this.updateSingleCell(command, this.selectionLayer.getLastSelectedCellPosition());
        }
        return true;
    }

    private void updateSingleCell(TickUpdateCommand command, PositionCoordinate selectedPosition) {
        ILayerCell cell = this.selectionLayer.getCellByPosition(selectedPosition.columnPosition, selectedPosition.rowPosition);
        IEditableRule editableRule = command.getConfigRegistry().getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", cell.getConfigLabels().getLabels());
        if (editableRule.isEditable(cell, command.getConfigRegistry())) {
            this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, selectedPosition.columnPosition, selectedPosition.rowPosition, this.getNewCellValue(command, cell)));
        }
    }

    private Object getNewCellValue(TickUpdateCommand command, ILayerCell cell) {
        ITickUpdateHandler tickUpdateHandler = command.getConfigRegistry().getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, "EDIT", cell.getConfigLabels().getLabels());
        Object dataValue = cell.getDataValue();
        if (tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(dataValue)) {
            if (command.isIncrement()) {
                return tickUpdateHandler.getIncrementedValue(dataValue);
            }
            return tickUpdateHandler.getDecrementedValue(dataValue);
        }
        return dataValue;
    }

    @Override
    public Class<TickUpdateCommand> getCommandClass() {
        return TickUpdateCommand.class;
    }
}

