/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort;

import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortStatePersistor;
import org.eclipse.nebula.widgets.nattable.sort.command.SortCommandHandler;
import org.eclipse.nebula.widgets.nattable.sort.config.DefaultSortConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortHeaderLayer<T>
extends AbstractLayerTransform
implements IPersistable {
    private final ISortModel sortModel;

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel) {
        this(underlyingLayer, sortModel, true);
    }

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.sortModel = sortModel;
        this.registerPersistable(new SortStatePersistor(sortModel));
        this.registerCommandHandler(new SortCommandHandler(sortModel, this));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSortConfiguration());
        }
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.sortModel != null && this.sortModel.isColumnIndexSorted(columnIndex = this.getColumnIndexByPosition(columnPosition))) {
            SortDirectionEnum sortDirection = this.sortModel.getSortDirection(columnIndex);
            switch (sortDirection) {
                case ASC: {
                    configLabels.addLabel("SORT_UP");
                    break;
                }
                case DESC: {
                    configLabels.addLabel("SORT_DOWN");
                }
            }
            String sortConfig = "SORT_SEQ_" + this.sortModel.getSortOrder(columnIndex);
            configLabels.addLabel(sortConfig);
        }
        return configLabels;
    }

    protected ISortModel getSortModel() {
        return this.sortModel;
    }
}

