/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayer
implements ILayer {
    private String regionName;
    protected ILayerPainter layerPainter;
    private IClientAreaProvider clientAreaProvider = IClientAreaProvider.DEFAULT;
    private IConfigLabelAccumulator configLabelAccumulator;
    private final Map<Class<? extends ILayerCommand>, ILayerCommandHandler<? extends ILayerCommand>> commandHandlers = new LinkedHashMap<Class<? extends ILayerCommand>, ILayerCommandHandler<? extends ILayerCommand>>();
    private final Map<Class<? extends ILayerEvent>, ILayerEventHandler<? extends ILayerEvent>> eventHandlers = new HashMap<Class<? extends ILayerEvent>, ILayerEventHandler<? extends ILayerEvent>>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private final Set<ILayerListener> listeners = new LinkedHashSet<ILayerListener>();
    private final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();

    @Override
    public void dispose() {
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        LabelStack regionLabels = new LabelStack(new String[0]);
        if (this.regionName != null) {
            regionLabels.addLabel(this.regionName);
        }
        return regionLabels;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack configLabels = new LabelStack(new String[0]);
        if (this.configLabelAccumulator != null) {
            this.configLabelAccumulator.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
        }
        if (this.regionName != null) {
            configLabels.addLabel(this.regionName);
        }
        return configLabels;
    }

    public IConfigLabelAccumulator getConfigLabelAccumulator() {
        return this.configLabelAccumulator;
    }

    public void setConfigLabelAccumulator(IConfigLabelAccumulator cellLabelAccumulator) {
        this.configLabelAccumulator = cellLabelAccumulator;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        for (IPersistable persistable : this.persistables) {
            persistable.saveState(prefix, properties);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        for (IPersistable persistable : this.persistables) {
            persistable.loadState(prefix, properties);
        }
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    public void addConfiguration(IConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public void clearConfiguration() {
        this.configurations.clear();
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(configRegistry);
            configuration.configureUiBindings(uiBindingRegistry);
        }
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        for (Class<? extends ILayerCommand> commandClass : this.commandHandlers.keySet()) {
            ILayerCommandHandler<? extends ILayerCommand> commandHandler;
            if (!commandClass.isInstance(command) || !(commandHandler = this.commandHandlers.get(commandClass)).doCommand(this, command)) continue;
            return true;
        }
        return false;
    }

    protected void registerCommandHandlers() {
    }

    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        this.commandHandlers.put(commandHandler.getCommandClass(), commandHandler);
    }

    public void unregisterCommandHandler(Class<? extends ILayerCommand> commandClass) {
        this.commandHandlers.remove(commandClass);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        for (Class<? extends ILayerEvent> eventClass : this.eventHandlers.keySet()) {
            if (!eventClass.isInstance(event)) continue;
            ILayerEventHandler<? extends ILayerEvent> eventHandler = this.eventHandlers.get(eventClass);
            eventHandler.handleLayerEvent(event);
        }
        if (event.convertToLocal(this)) {
            this.fireLayerEvent(event);
        }
    }

    public void registerEventHandler(ILayerEventHandler<?> eventHandler) {
        this.eventHandlers.put(eventHandler.getLayerEventClass(), eventHandler);
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        if (this.listeners.size() > 0) {
            Iterator<ILayerListener> it = this.listeners.iterator();
            boolean isLastListener = false;
            do {
                ILayerListener l = it.next();
                isLastListener = !it.hasNext();
                ILayerEvent eventToFire = isLastListener ? event : event.cloneEvent();
                l.handleLayerEvent(eventToFire);
            } while (!isLastListener);
        }
    }

    @Override
    public ILayerPainter getLayerPainter() {
        if (this.layerPainter == null) {
            this.layerPainter = new GridLineCellLayerPainter();
        }
        return this.layerPainter;
    }

    protected void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount() || rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return null;
        }
        return new LayerCell(this, columnPosition, rowPosition);
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        ILayer cellLayer = cell.getLayer();
        int originColumnPosition = cell.getOriginColumnPosition();
        int originRowPosition = cell.getOriginRowPosition();
        int x = cellLayer.getStartXOfColumnPosition(originColumnPosition);
        int y = cellLayer.getStartYOfRowPosition(originRowPosition);
        int width = 0;
        int i = 0;
        while (i < cell.getColumnSpan()) {
            width += cellLayer.getColumnWidthByPosition(originColumnPosition + i);
            ++i;
        }
        int height = 0;
        int i2 = 0;
        while (i2 < cell.getRowSpan()) {
            height += cellLayer.getRowHeightByPosition(originRowPosition + i2);
            ++i2;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        return "NORMAL";
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        return configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
    }
}

