/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRowHideShowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private Map<Integer, Integer> cachedVisibleRowIndexOrder;
    private Map<Integer, Integer> cachedVisibleRowPositionOrder;
    private Map<Integer, Integer> cachedHiddenRowIndexToPositionMap;
    private final Map<Integer, Integer> startYCache = new HashMap<Integer, Integer>();

    public AbstractRowHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged()) {
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.getCachedVisibleRowIndexes().size();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return -1;
        }
        Integer rowIndex = this.getCachedVisibleRowPositons().get(rowPosition);
        if (rowIndex != null) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        Integer position = this.getCachedVisibleRowIndexes().get(rowIndex);
        return position != null ? position : -1;
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(underlyingRowPosition);
        int rowPosition = this.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        Integer hiddenRowPosition = this.cachedHiddenRowIndexToPositionMap.get(rowIndex);
        if (hiddenRowPosition != null) {
            return hiddenRowPosition;
        }
        return -1;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>();
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int startRowPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start, underlyingRowPositionRange.end);
            int endRowPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingRowPositionRange.end, underlyingRowPositionRange.start);
            if (startRowPosition <= -1) continue;
            localRowPositionRanges.add(new Range(startRowPosition, endRowPosition));
        }
        return localRowPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartRowPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartRowPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndRowPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndRowPosition + 1;
    }

    @Override
    public int getHeight() {
        int lastRowPosition = this.getRowCount() - 1;
        return this.getStartYOfRowPosition(lastRowPosition) + this.getRowHeightByPosition(lastRowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartYOfRowPosition(int localRowPosition) {
        Integer cachedStartY = this.startYCache.get(localRowPosition);
        if (cachedStartY != null) {
            return cachedStartY;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingRowPosition(localRowPosition);
        int underlyingStartY = underlyingLayer.getStartYOfRowPosition(underlyingPosition);
        for (Integer hiddenIndex : this.getHiddenRowIndexes()) {
            int hiddenPosition = underlyingLayer.getRowPositionByIndex(hiddenIndex);
            if (hiddenPosition > underlyingPosition) continue;
            underlyingStartY -= underlyingLayer.getRowHeightByPosition(hiddenPosition);
        }
        this.startYCache.put(localRowPosition, underlyingStartY);
        return underlyingStartY;
    }

    public abstract boolean isRowIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenRowIndexes();

    protected void invalidateCache() {
        this.cachedVisibleRowIndexOrder = null;
        this.cachedVisibleRowPositionOrder = null;
        this.startYCache.clear();
    }

    private Map<Integer, Integer> getCachedVisibleRowIndexes() {
        if (this.cachedVisibleRowIndexOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowIndexOrder;
    }

    private Map<Integer, Integer> getCachedVisibleRowPositons() {
        if (this.cachedVisibleRowPositionOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowPositionOrder;
    }

    protected void cacheVisibleRowIndexes() {
        this.cachedVisibleRowIndexOrder = new HashMap<Integer, Integer>();
        this.cachedVisibleRowPositionOrder = new HashMap<Integer, Integer>();
        this.cachedHiddenRowIndexToPositionMap = new HashMap<Integer, Integer>();
        this.startYCache.clear();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int rowPosition = 0;
        int parentRowPosition = 0;
        while (parentRowPosition < underlyingLayer.getRowCount()) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(parentRowPosition);
            if (!this.isRowIndexHidden(rowIndex)) {
                this.cachedVisibleRowIndexOrder.put(rowIndex, rowPosition);
                this.cachedVisibleRowPositionOrder.put(rowPosition, rowIndex);
                ++rowPosition;
            } else {
                this.cachedHiddenRowIndexToPositionMap.put(rowIndex, rowPosition);
            }
            ++parentRowPosition;
        }
    }
}

