/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModelListener;
import org.eclipse.nebula.widgets.nattable.group.model.RowGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowGroupModel<T>
implements IRowGroupModel<T> {
    private final Map<String, IRowGroup<T>> namesToGroups;
    private final Map<T, IRowGroup<T>> rowToGroups = new ConcurrentHashMap<T, IRowGroup<T>>();
    private final Set<IRowGroupModelListener> listeners;
    private final RowCache<T> rowCache;
    private boolean suppressNoficiations = false;

    public RowGroupModel() {
        this.namesToGroups = new ConcurrentHashMap<String, IRowGroup<T>>();
        this.rowCache = new RowCache();
        this.listeners = new HashSet<IRowGroupModelListener>();
    }

    @Override
    public T getRowFromIndexCache(int rowIndex) {
        return this.rowCache.getRowFromIndexCache(rowIndex);
    }

    @Override
    public int getIndexFromRowCache(T row) {
        return this.rowCache.getIndexFromRowCache(row);
    }

    @Override
    public void invalidateIndexCache() {
        this.rowCache.invalidateIndexCache();
    }

    @Override
    public void setDataProvider(IRowDataProvider<T> dataProvider) {
        this.rowCache.setDataProvider(dataProvider);
    }

    @Override
    public IRowDataProvider<T> getDataProvider() {
        return this.rowCache.getDataProvider();
    }

    @Override
    public void notifyListeners() {
        this.invalidateIndexCache();
        if (!this.suppressNoficiations) {
            for (IRowGroupModelListener listener : this.listeners) {
                listener.rowGroupModelChanged();
            }
        }
    }

    public void setSuppressNoficiations(boolean suppressNoficiations) {
        this.suppressNoficiations = suppressNoficiations;
    }

    public boolean isSuppressNoficiations() {
        return this.suppressNoficiations;
    }

    void addMemberRow(T row, RowGroup<T> rowGroup) {
        this.rowToGroups.put(row, rowGroup);
    }

    void removeMemberRow(T row) {
        this.rowToGroups.remove(row);
    }

    @Override
    public void addRowGroups(List<IRowGroup<T>> rowGroups) {
        for (IRowGroup<T> rowGroup : rowGroups) {
            this.namesToGroups.put(rowGroup.getGroupName(), rowGroup);
        }
        this.notifyListeners();
    }

    @Override
    public boolean addRowGroup(IRowGroup<T> rowGroup) {
        if (this.namesToGroups.containsKey(rowGroup.getGroupName())) {
            return false;
        }
        this.namesToGroups.put(rowGroup.getGroupName(), rowGroup);
        this.notifyListeners();
        return true;
    }

    @Override
    public boolean removeRowGroup(IRowGroup<T> rowGroup) {
        boolean removed = this.namesToGroups.containsKey(rowGroup.getGroupName());
        if (removed) {
            this.namesToGroups.remove(rowGroup.getGroupName());
            this.notifyListeners();
        }
        return removed;
    }

    @Override
    public List<IRowGroup<T>> getRowGroups() {
        return Collections.unmodifiableList(new ArrayList<IRowGroup<T>>(this.namesToGroups.values()));
    }

    @Override
    public IRowGroup<T> getRowGroupForName(String groupName) {
        return this.namesToGroups.get(groupName);
    }

    @Override
    public IRowGroup<T> getRowGroupForRow(T row) {
        if (this.rowToGroups.containsKey(row)) {
            return this.getUltimateParent(this.rowToGroups.get(row));
        }
        return null;
    }

    private IRowGroup<T> getUltimateParent(IRowGroup<T> group) {
        return group.getParentGroup() == null ? group : this.getUltimateParent(group.getParentGroup());
    }

    @Override
    public boolean isEmpty() {
        return this.namesToGroups.isEmpty();
    }

    @Override
    public void clear() {
        this.namesToGroups.clear();
        this.rowToGroups.clear();
        this.rowCache.invalidateIndexCache();
        this.notifyListeners();
    }

    @Override
    public void registerRowGroupModelListener(IRowGroupModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterRowGroupModelListener(IRowGroupModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
    }

    @Override
    public void loadState(String prefix, Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ===== Row Group Model ==== \n");
        Map<String, IRowGroup<T>> map = this.namesToGroups;
        synchronized (map) {
            for (IRowGroup<T> rowGroup : this.namesToGroups.values()) {
                sb.append(((RowGroup)rowGroup).toString());
            }
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowCache<E> {
        private IRowDataProvider<E> dataProvider;
        private final Map<Integer, E> indexesToRows = new LinkedHashMap<Integer, E>();
        private final Map<E, Integer> rowsToIndexes = new LinkedHashMap<E, Integer>();

        public IRowDataProvider<E> getDataProvider() {
            return this.dataProvider;
        }

        public void setDataProvider(IRowDataProvider<E> dataProvider) {
            this.dataProvider = dataProvider;
        }

        public E getRowFromIndexCache(int rowIndex) {
            if (this.indexesToRows.containsKey(rowIndex)) {
                return this.indexesToRows.get(rowIndex);
            }
            E row = this.dataProvider.getRowObject(rowIndex);
            if (this.rowsToIndexes.containsKey(row)) {
                this.invalidateIndexCache();
            }
            this.rowsToIndexes.put(row, rowIndex);
            this.indexesToRows.put(rowIndex, row);
            return row;
        }

        public int getIndexFromRowCache(E row) {
            if (this.rowsToIndexes.containsKey(row)) {
                return this.rowsToIndexes.get(row);
            }
            int rowIndex = this.dataProvider.indexOfRowObject(row);
            if (this.indexesToRows.containsKey(rowIndex)) {
                this.invalidateIndexCache();
            }
            this.indexesToRows.put(rowIndex, row);
            this.rowsToIndexes.put(row, rowIndex);
            return rowIndex;
        }

        public void invalidateIndexCache() {
            this.indexesToRows.clear();
            this.rowsToIndexes.clear();
        }
    }
}

