/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ActiveCellEditor {
    private static ICellEditor cellEditor;
    private static Control activeCellEditorControl;
    private static int columnPosition;
    private static int rowPosition;
    private static int columnIndex;
    private static int rowIndex;

    static {
        columnPosition = -1;
        rowPosition = -1;
        columnIndex = -1;
        rowIndex = -1;
    }

    public static void activate(ICellEditor cellEditor, Composite parent, Object originalCanonicalValue, Character initialEditValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
        ActiveCellEditor.close();
        ActiveCellEditor.cellEditor = cellEditor;
        columnPosition = cell.getColumnPosition();
        rowPosition = cell.getRowPosition();
        columnIndex = cell.getColumnIndex();
        rowIndex = cell.getRowIndex();
        activeCellEditorControl = cellEditor.activateCell(parent, originalCanonicalValue, initialEditValue, editMode, editHandler, cell, configRegistry);
    }

    public static boolean commit() {
        if (ActiveCellEditor.isValid()) {
            return cellEditor.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
        }
        return true;
    }

    public static void close() {
        if (ActiveCellEditor.isValid()) {
            cellEditor.close();
        }
        cellEditor = null;
        if (activeCellEditorControl != null && !activeCellEditorControl.isDisposed()) {
            activeCellEditorControl.dispose();
        }
        activeCellEditorControl = null;
        columnPosition = -1;
        rowPosition = -1;
        columnIndex = -1;
        rowIndex = -1;
    }

    public static ICellEditor getCellEditor() {
        return cellEditor;
    }

    public static Control getControl() {
        if (ActiveCellEditor.isValid()) {
            return activeCellEditorControl;
        }
        return null;
    }

    public static int getColumnPosition() {
        return columnPosition;
    }

    public static int getRowPosition() {
        return rowPosition;
    }

    public static int getColumnIndex() {
        return columnIndex;
    }

    public static int getRowIndex() {
        return rowIndex;
    }

    public static Object getCanonicalValue() {
        if (ActiveCellEditor.isValid()) {
            return cellEditor.getCanonicalValue();
        }
        return null;
    }

    public static boolean validateCanonicalValue() {
        if (ActiveCellEditor.isValid()) {
            return cellEditor.validateCanonicalValue();
        }
        return true;
    }

    public static boolean isValid() {
        return cellEditor != null && !cellEditor.isClosed();
    }
}

