/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractRowCommand
implements ILayerCommand {
    private RowPositionCoordinate rowPositionCoordinate;

    protected AbstractRowCommand(ILayer layer, int rowPosition) {
        this.rowPositionCoordinate = new RowPositionCoordinate(layer, rowPosition);
    }

    protected AbstractRowCommand(AbstractRowCommand command) {
        this.rowPositionCoordinate = command.rowPositionCoordinate;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.rowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.rowPositionCoordinate, targetLayer);
        return this.rowPositionCoordinate != null;
    }

    public int getRowPosition() {
        return this.rowPositionCoordinate.getRowPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " rowPosition=" + this.rowPositionCoordinate.getRowPosition();
    }
}

