/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.wikitext.html.internal.BlockStrategy;
import org.eclipse.mylyn.wikitext.html.internal.ElementStrategies;
import org.eclipse.mylyn.wikitext.html.internal.HtmlElementStrategy;
import org.eclipse.mylyn.wikitext.html.internal.NoOpBlockStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SubstitutionBlockStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SupportedBlockStrategy;
import org.eclipse.mylyn.wikitext.html.internal.UnsupportedBlockStrategy;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

class BlockStrategies
extends ElementStrategies<DocumentBuilder.BlockType, BlockStrategy, HtmlElementStrategy<DocumentBuilder.BlockType>> {
    private static final Map<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>> blockTypeToAlternatives = BlockStrategies.createBlockTypeToAlternatives();

    private static Map<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>> createBlockTypeToAlternatives() {
        HashMap<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>> alternatives = new HashMap<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>>();
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.BULLETED_LIST, DocumentBuilder.BlockType.NUMERIC_LIST);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.NUMERIC_LIST, DocumentBuilder.BlockType.BULLETED_LIST);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.CODE, DocumentBuilder.BlockType.PREFORMATTED, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.DEFINITION_LIST, DocumentBuilder.BlockType.NUMERIC_LIST, DocumentBuilder.BlockType.BULLETED_LIST);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.DIV, DocumentBuilder.BlockType.PARAGRAPH);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.FOOTNOTE, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.INFORMATION, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.LIST_ITEM, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.DEFINITION_ITEM, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.DEFINITION_TERM, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.NOTE, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.PANEL, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.PREFORMATTED, DocumentBuilder.BlockType.CODE, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.QUOTE, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.TABLE_CELL_HEADER, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.TABLE_CELL_NORMAL, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.TIP, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        BlockStrategies.addAlternatives(alternatives, DocumentBuilder.BlockType.WARNING, DocumentBuilder.BlockType.PARAGRAPH, DocumentBuilder.BlockType.DIV);
        return Map.copyOf(alternatives);
    }

    private static void addAlternatives(Map<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>> alternatives, DocumentBuilder.BlockType blockType, DocumentBuilder.BlockType ... blockTypes) {
        Preconditions.checkState((!alternatives.containsKey(blockType) ? 1 : 0) != 0, (String)"Duplicate %s", (Object)blockType);
        Preconditions.checkArgument((blockTypes.length > 0 ? 1 : 0) != 0);
        alternatives.put(blockType, List.of(blockTypes));
    }

    BlockStrategies(Set<DocumentBuilder.BlockType> blockTypes) {
        super(DocumentBuilder.BlockType.class, blockTypes, Collections.emptyList());
    }

    @Override
    void addImplicitElementTypes(Map<DocumentBuilder.BlockType, BlockStrategy> elementStrategyByElementType, Set<DocumentBuilder.BlockType> elementTypes) {
        if (elementTypes.contains(DocumentBuilder.BlockType.TABLE)) {
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.TABLE_ROW);
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.TABLE_CELL_HEADER);
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.TABLE_CELL_NORMAL);
        }
        if (elementTypes.contains(DocumentBuilder.BlockType.BULLETED_LIST) || elementTypes.contains(DocumentBuilder.BlockType.NUMERIC_LIST)) {
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.LIST_ITEM);
        }
        if (elementTypes.contains(DocumentBuilder.BlockType.DEFINITION_LIST)) {
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.DEFINITION_ITEM);
            this.addSupportedElementType(elementStrategyByElementType, DocumentBuilder.BlockType.DEFINITION_TERM);
        }
    }

    @Override
    BlockStrategy getSupportedStrategy(DocumentBuilder.BlockType elementType) {
        return SupportedBlockStrategy.instance;
    }

    @Override
    BlockStrategy getUnsupportedElementStrategy(DocumentBuilder.BlockType elementType) {
        switch (elementType) {
            case BULLETED_LIST: 
            case DEFINITION_LIST: 
            case NUMERIC_LIST: 
            case TABLE: {
                return NoOpBlockStrategy.instance;
            }
        }
        return UnsupportedBlockStrategy.instance;
    }

    @Override
    BlockStrategy createSubstitutionElementStrategy(DocumentBuilder.BlockType alternative) {
        return new SubstitutionBlockStrategy(alternative);
    }

    @Override
    Map<DocumentBuilder.BlockType, List<DocumentBuilder.BlockType>> getElementTypeToAlternatives() {
        return blockTypeToAlternatives;
    }

    @Override
    BlockStrategy getElementStrategy(HtmlElementStrategy<DocumentBuilder.BlockType> strategy) {
        throw new UnsupportedOperationException();
    }
}

