/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.parser.Locator;

public class SimpleLocator
implements Locator {
    private final int lineNumber;
    private final int lineDocumentOffset;
    private final int lineLength;
    private final int lineCharacterOffset;
    private final int lineSegmentEndOffset;

    public SimpleLocator(Line line) {
        this(line, 0, line.getText().length());
    }

    public SimpleLocator(Line line, int lineCharacterOffset, int lineSegmentEndOffset) {
        Preconditions.checkNotNull((Object)line);
        this.lineNumber = line.getLineNumber() + 1;
        this.lineDocumentOffset = line.getOffset();
        this.lineLength = line.getText().length();
        this.lineCharacterOffset = lineCharacterOffset;
        this.lineSegmentEndOffset = lineSegmentEndOffset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineDocumentOffset() {
        return this.lineDocumentOffset;
    }

    public int getDocumentOffset() {
        return this.getLineDocumentOffset() + this.getLineCharacterOffset();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getLineCharacterOffset() {
        return this.lineCharacterOffset;
    }

    public int getLineSegmentEndOffset() {
        return this.lineSegmentEndOffset;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Locator.class).add("lineNumber", this.lineNumber).add("lineDocumentOffset", this.lineDocumentOffset).add("lineLength", this.lineLength).add("lineCharacterOffset", this.lineCharacterOffset).add("lineSegmentEndOffset", this.lineSegmentEndOffset).toString();
    }
}

