/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Util {
    public static Image scaleImage(Image image, int maxWidth, int maxHeight) {
        int newHeight;
        int newWidth;
        Rectangle bounds = image.getBounds();
        float widthRatio = (float)bounds.width / (float)maxWidth;
        float heightRatio = (float)bounds.height / (float)maxHeight;
        if (widthRatio > heightRatio) {
            newWidth = maxWidth;
            newHeight = Math.min(maxHeight, (int)((float)bounds.height / widthRatio));
        } else {
            newWidth = Math.min(maxWidth, (int)((float)bounds.width / heightRatio));
            newHeight = maxHeight;
        }
        Image scaledImage = new Image(image.getDevice(), newWidth, newHeight);
        GC gc = new GC((Drawable)scaledImage);
        try {
            gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, newWidth, newHeight);
        }
        finally {
            gc.dispose();
        }
        return scaledImage;
    }

    public static int computeMessageType(IStatus status) {
        int messageType;
        switch (status.getSeverity()) {
            case 0: 
            case 1: {
                messageType = 1;
                break;
            }
            case 2: {
                messageType = 2;
                break;
            }
            default: {
                messageType = 3;
            }
        }
        return messageType;
    }
}

