/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;

public class LazyOverrideCheckResult
implements IOverrideCheckResult {
    private final AbstractResolvedOperation thisOperation;
    private final JvmOperation givenOperation;
    private final IOverrideCheckResult.OverrideCheckDetails primaryDetail;
    private EnumSet<IOverrideCheckResult.OverrideCheckDetails> details;
    protected static final EnumSet<IOverrideCheckResult.OverrideCheckDetails> overridingIfAnyOf = EnumSet.of(IOverrideCheckResult.OverrideCheckDetails.OVERRIDE, IOverrideCheckResult.OverrideCheckDetails.IMPLEMENTATION, IOverrideCheckResult.OverrideCheckDetails.REDECLARATION, IOverrideCheckResult.OverrideCheckDetails.REPEATED, IOverrideCheckResult.OverrideCheckDetails.SHADOWED);
    protected static final EnumSet<IOverrideCheckResult.OverrideCheckDetails> problemIfAnyOf = EnumSet.of(IOverrideCheckResult.OverrideCheckDetails.ARITY_MISMATCH, new IOverrideCheckResult.OverrideCheckDetails[]{IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.IS_FINAL, IOverrideCheckResult.OverrideCheckDetails.NAME_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.NO_INHERITANCE, IOverrideCheckResult.OverrideCheckDetails.NOT_VISIBLE, IOverrideCheckResult.OverrideCheckDetails.PARAMETER_TYPE_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.REDUCED_VISIBILITY, IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.SAME_ERASURE, IOverrideCheckResult.OverrideCheckDetails.STATIC_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.TYPE_PARAMETER_MISMATCH, IOverrideCheckResult.OverrideCheckDetails.UNCHECKED_CONVERSION_REQUIRED, IOverrideCheckResult.OverrideCheckDetails.VAR_ARG_MISMATCH});

    public LazyOverrideCheckResult(AbstractResolvedOperation thisOperation, JvmOperation givenOperation, IOverrideCheckResult.OverrideCheckDetails detail) {
        this.thisOperation = thisOperation;
        this.givenOperation = givenOperation;
        this.primaryDetail = detail;
    }

    @Override
    public boolean isOverridingOrImplementing() {
        return overridingIfAnyOf.contains((Object)this.primaryDetail);
    }

    @Override
    public boolean hasProblems() {
        if (!this.isOverridingOrImplementing()) {
            return true;
        }
        EnumSet<IOverrideCheckResult.OverrideCheckDetails> details = this.getDetails();
        return !Sets.intersection(problemIfAnyOf, details).isEmpty();
    }

    @Override
    public EnumSet<IOverrideCheckResult.OverrideCheckDetails> getDetails() {
        if (this.details != null) {
            return this.details;
        }
        this.details = this.getComputedDetails();
        return this.details;
    }

    protected EnumSet<IOverrideCheckResult.OverrideCheckDetails> getComputedDetails() {
        return this.thisOperation.getOverrideTester().getAllDetails(this.thisOperation, this.givenOperation, this.primaryDetail);
    }

    @Override
    public IResolvedOperation getThisOperation() {
        return this.thisOperation;
    }

    @Override
    public JvmOperation getGivenOperation() {
        return this.givenOperation;
    }
}

