/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.types;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.xtext.xbase.ide.types.ClasspathTypeDescriptor;
import org.eclipse.xtext.xbase.ide.types.ITypeDescriptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ClasspathScanner {
    private static final Splitter PROPERTY_CLASSPATH_SPLITTER = Splitter.on((char)File.pathSeparatorChar);
    private static final Splitter MANIFEST_CLASSPATH_SPLITTER = Splitter.on((String)" ").omitEmptyStrings();
    private Cache<Pair<ClassLoader, Collection<String>>, Iterable<ITypeDescriptor>> classLoaderDescriptors;
    private Cache<Pair<URI, Collection<String>>, Iterable<ITypeDescriptor>> uriDescriptors;

    protected Cache<Pair<ClassLoader, Collection<String>>, Iterable<ITypeDescriptor>> createClassLoaderCache() {
        CacheBuilder _newBuilder = CacheBuilder.newBuilder();
        CacheBuilder _initialCapacity = _newBuilder.initialCapacity(8);
        CacheBuilder _concurrencyLevel = _initialCapacity.concurrencyLevel(2);
        CacheBuilder _maximumSize = _concurrencyLevel.maximumSize(32L);
        CacheBuilder _expireAfterAccess = _maximumSize.expireAfterAccess(5L, TimeUnit.MINUTES);
        return _expireAfterAccess.build();
    }

    protected Cache<Pair<URI, Collection<String>>, Iterable<ITypeDescriptor>> createUriCache() {
        CacheBuilder _newBuilder = CacheBuilder.newBuilder();
        CacheBuilder _initialCapacity = _newBuilder.initialCapacity(64);
        CacheBuilder _concurrencyLevel = _initialCapacity.concurrencyLevel(2);
        CacheBuilder _maximumSize = _concurrencyLevel.maximumSize(256L);
        CacheBuilder _expireAfterAccess = _maximumSize.expireAfterAccess(30L, TimeUnit.MINUTES);
        return _expireAfterAccess.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ITypeDescriptor> getDescriptors(final ClassLoader classLoader, final Collection<String> packagePrefixes) {
        try {
            ClasspathScanner classpathScanner = this;
            synchronized (classpathScanner) {
                if (this.classLoaderDescriptors == null) {
                    Cache<Pair<ClassLoader, Collection<String>>, Iterable<ITypeDescriptor>> _createClassLoaderCache = this.createClassLoaderCache();
                    this.classLoaderDescriptors = _createClassLoaderCache;
                }
            }
            Pair _mappedTo = Pair.of((Object)classLoader, packagePrefixes);
            Callable<Iterable<ITypeDescriptor>> _function = new Callable<Iterable<ITypeDescriptor>>(){

                @Override
                public Iterable<ITypeDescriptor> call() throws Exception {
                    return ClasspathScanner.this.loadDescriptors(classLoader, (Collection<String>)packagePrefixes);
                }
            };
            return (Iterable)this.classLoaderDescriptors.get((Object)_mappedTo, (Callable)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ITypeDescriptor> getDescriptors(final URI uri, final Collection<String> packagePrefixes) {
        try {
            ClasspathScanner classpathScanner = this;
            synchronized (classpathScanner) {
                if (this.uriDescriptors == null) {
                    Cache<Pair<URI, Collection<String>>, Iterable<ITypeDescriptor>> _createUriCache = this.createUriCache();
                    this.uriDescriptors = _createUriCache;
                }
            }
            Pair _mappedTo = Pair.of((Object)uri, packagePrefixes);
            Callable<Iterable<ITypeDescriptor>> _function = new Callable<Iterable<ITypeDescriptor>>(){

                @Override
                public Iterable<ITypeDescriptor> call() throws Exception {
                    return ClasspathScanner.this.loadDescriptors(uri, (Collection<String>)packagePrefixes);
                }
            };
            return (Iterable)this.uriDescriptors.get((Object)_mappedTo, (Callable)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<ITypeDescriptor> getBootClasspathDescriptors(final Collection<String> packagePrefixes) {
        Iterable _xblockexpression = null;
        String classpath = System.getProperty("sun.boot.class.path");
        if (classpath == null) {
            return Collections.emptyList();
        }
        Iterable _split = PROPERTY_CLASSPATH_SPLITTER.split((CharSequence)classpath);
        Functions.Function1<String, Iterable<ITypeDescriptor>> _function = new Functions.Function1<String, Iterable<ITypeDescriptor>>(){

            public Iterable<ITypeDescriptor> apply(String path) {
                File _file = new File(path);
                URI _uRI = _file.toURI();
                return ClasspathScanner.this.getDescriptors(_uRI, (Collection<String>)packagePrefixes);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_split, (Functions.Function1)_function);
        _xblockexpression = Iterables.concat((Iterable)_map);
        return _xblockexpression;
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ClassLoader classLoader, final Collection<String> packagePrefixes) {
        try {
            Iterable _xblockexpression = null;
            LinkedList<ClassLoader> classLoaderHierarchy = new LinkedList<ClassLoader>();
            ClassLoader cl = classLoader;
            while (cl != null) {
                ClassLoader _parent;
                classLoaderHierarchy.push(cl);
                cl = _parent = cl.getParent();
            }
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            while (!classLoaderHierarchy.isEmpty()) {
                URL[] _uRLs;
                ClassLoader _pop = (ClassLoader)classLoaderHierarchy.pop();
                cl = _pop;
                if (!(cl instanceof URLClassLoader)) continue;
                URL[] uRLArray = _uRLs = ((URLClassLoader)cl).getURLs();
                int n = _uRLs.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    URI _uRI = url.toURI();
                    uris.add(_uRI);
                    ++n2;
                }
            }
            Functions.Function1<URI, Iterable<ITypeDescriptor>> _function = new Functions.Function1<URI, Iterable<ITypeDescriptor>>(){

                public Iterable<ITypeDescriptor> apply(URI it) {
                    return ClasspathScanner.this.getDescriptors(it, (Collection<String>)packagePrefixes);
                }
            };
            Iterable _map = IterableExtensions.map(uris, (Functions.Function1)_function);
            _xblockexpression = Iterables.concat((Iterable)_map);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(URI uri, Collection<String> packagePrefixes) {
        String _scheme = uri.getScheme();
        boolean _equals = Objects.equal((Object)_scheme, (Object)"file");
        if (_equals) {
            File file = new File(uri);
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                ArrayList<ITypeDescriptor> descriptors = new ArrayList<ITypeDescriptor>();
                this.loadDirectoryDescriptors(file, "", descriptors, packagePrefixes);
                return descriptors;
            }
            boolean _exists = file.exists();
            if (_exists) {
                return this.loadJarDescriptors(file, true, packagePrefixes);
            }
        }
        return Collections.emptyList();
    }

    protected void loadDirectoryDescriptors(File directory, String packageName, List<ITypeDescriptor> descriptors, Collection<String> packagePrefixes) {
        File[] children = directory.listFiles();
        boolean _equals = Objects.equal((Object)children, null);
        if (_equals) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                String _xifexpression = null;
                boolean _isEmpty = packageName.isEmpty();
                if (_isEmpty) {
                    _xifexpression = file.getName();
                } else {
                    String _name = file.getName();
                    _xifexpression = String.valueOf(packageName) + "." + _name;
                }
                String subPackageName = _xifexpression;
                this.loadDirectoryDescriptors(file, subPackageName, descriptors, packagePrefixes);
            } else {
                ClasspathTypeDescriptor typeDesc = ClasspathTypeDescriptor.forFile(file, packageName, packagePrefixes);
                if (typeDesc != null) {
                    descriptors.add(typeDesc);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterable<ITypeDescriptor> loadJarDescriptors(File file, boolean includeManifestEntries, Collection<String> packagePrefixes) {
        try {
            ZipFile jarFile = null;
            try {
                Manifest _manifest_1;
                Attributes _mainAttributes;
                String classpath;
                Manifest _manifest;
                boolean _tripleNotEquals;
                JarFile _jarFile = new JarFile(file, false);
                jarFile = _jarFile;
                ArrayList<Iterable<ITypeDescriptor>> descriptorCollections = null;
                boolean _and = false;
                _and = !includeManifestEntries ? false : (_tripleNotEquals = (_manifest = ((JarFile)jarFile).getManifest()) != null);
                if (_and && (classpath = (_mainAttributes = (_manifest_1 = ((JarFile)jarFile).getManifest()).getMainAttributes()).getValue("Class-Path")) != null) {
                    ArrayList<Iterable<ITypeDescriptor>> _arrayList;
                    descriptorCollections = _arrayList = new ArrayList<Iterable<ITypeDescriptor>>();
                    Iterable _split = MANIFEST_CLASSPATH_SPLITTER.split((CharSequence)classpath);
                    for (String path : _split) {
                        try {
                            boolean _not;
                            URI uri = new URI(path);
                            boolean _isAbsolute = uri.isAbsolute();
                            boolean bl = _not = !_isAbsolute;
                            if (_not) {
                                URI _uRI;
                                File _parentFile = file.getParentFile();
                                String _replace = path.replace("/", File.separator);
                                File _file = new File(_parentFile, _replace);
                                uri = _uRI = _file.toURI();
                            }
                            Iterable<ITypeDescriptor> _descriptors = this.getDescriptors(uri, packagePrefixes);
                            descriptorCollections.add(_descriptors);
                        }
                        catch (Throwable _t) {
                            if (!(_t instanceof URISyntaxException)) throw Exceptions.sneakyThrow((Throwable)_t);
                            URISyntaxException _isAbsolute = (URISyntaxException)_t;
                        }
                    }
                }
                ArrayList<ITypeDescriptor> descriptors = new ArrayList<ITypeDescriptor>();
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (true) {
                    ClasspathTypeDescriptor typeDesc;
                    String _name;
                    boolean _startsWith;
                    boolean _not_2;
                    boolean _not_1;
                    if (!entries.hasMoreElements()) {
                        if (descriptorCollections != null) break;
                        ArrayList<ITypeDescriptor> arrayList = descriptors;
                        return arrayList;
                    }
                    JarEntry entry = entries.nextElement();
                    boolean _and_1 = false;
                    boolean _isDirectory = entry.isDirectory();
                    boolean bl = _not_1 = !_isDirectory;
                    _and_1 = !_not_1 ? false : (_not_2 = !(_startsWith = (_name = entry.getName()).startsWith("META-INF")));
                    if (!_and_1 || (typeDesc = ClasspathTypeDescriptor.forJarEntry(entry, (JarFile)jarFile, packagePrefixes)) == null) continue;
                    descriptors.add(typeDesc);
                }
                descriptorCollections.add(descriptors);
                Iterable iterable = Iterables.concat(descriptorCollections);
                return iterable;
            }
            catch (Throwable _t_1) {
                if (!(_t_1 instanceof IOException)) throw Exceptions.sneakyThrow((Throwable)_t_1);
                IOException exception_1 = (IOException)_t_1;
                List<ITypeDescriptor> list = Collections.emptyList();
                return list;
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

