/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.inject.Inject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;

public class DontAskAgainDialogs {
    public static final String DONT_ASK_AGAIN_DIALOG_PREFIX = "dont_ask_again_dialog";
    @Inject
    private IDialogSettings dialogSettings;

    public String getUserDecision(String key) {
        String userDecision = this.getDontAskAgainDialogSettings().get(key);
        if (userDecision == null) {
            userDecision = "prompt";
        }
        return userDecision;
    }

    public int askUser(String question, String dialogTitle, String storeKey, Shell shell) {
        MessageDialogWithToggle dialogWithToggle = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)dialogTitle, (String)question, null, (boolean)false, null, null);
        boolean rememberDecision = dialogWithToggle.getToggleState();
        int userAnswer = dialogWithToggle.getReturnCode();
        if (rememberDecision) {
            if (userAnswer == 3) {
                this.storeUserDecision(storeKey, "never");
            } else if (userAnswer == 2) {
                this.storeUserDecision(storeKey, "always");
            }
        }
        return userAnswer;
    }

    public void forgetAllUserDecisions() {
        this.dialogSettings.addNewSection(DONT_ASK_AGAIN_DIALOG_PREFIX);
    }

    private IDialogSettings getDontAskAgainDialogSettings() {
        IDialogSettings section = this.dialogSettings.getSection(DONT_ASK_AGAIN_DIALOG_PREFIX);
        if (section == null) {
            return this.dialogSettings.addNewSection(DONT_ASK_AGAIN_DIALOG_PREFIX);
        }
        return section;
    }

    private void storeUserDecision(String key, String value) {
        this.getDontAskAgainDialogSettings().put(key, value);
    }
}

