/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.XtextSpellingReconcileStrategy;
import org.eclipse.xtext.util.CancelIndicator;

public class XtextDocumentReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ISourceViewerAware {
    private static final Logger log = Logger.getLogger(XtextDocumentReconcileStrategy.class);
    @Inject
    private XtextSpellingReconcileStrategy.Factory spellingReconcileStrategyFactory;
    private XtextSpellingReconcileStrategy spellingReconcileStrategy;
    private XtextResource resource;
    private IProgressMonitor monitor;
    private XtextEditor editor;

    public void reconcile(IRegion region) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reconcile region: " + region));
        }
        this.doReconcile(region);
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.reconcile(region);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        if (!(document instanceof XtextDocument)) {
            throw new IllegalArgumentException("Document must be an " + XtextDocument.class.getSimpleName());
        }
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setDocument(document);
        }
    }

    @Override
    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.spellingReconcileStrategy = this.spellingReconcileStrategyFactory.create(sourceViewer);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.initialReconcile();
        }
    }

    public void setResource(XtextResource resource) {
        this.resource = resource;
    }

    protected void doReconcile(IRegion region) {
        if (this.resource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource is null in XtextReconcilerUnitOfWork.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        try {
            if (!(region instanceof ReconcilerReplaceRegion)) {
                throw new IllegalArgumentException("Region to be reconciled must be a ReplaceRegion");
            }
            ReconcilerReplaceRegion replaceRegionToBeProcessed = (ReconcilerReplaceRegion)region;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing replace region '" + (Object)((Object)replaceRegionToBeProcessed) + "'."));
            }
            this.resource.update(replaceRegionToBeProcessed.getOffset(), replaceRegionToBeProcessed.getLength(), replaceRegionToBeProcessed.getText());
            this.resource.setModificationStamp(replaceRegionToBeProcessed.getModificationStamp());
            this.postParse(this.resource, this.monitor);
        }
        catch (OperationCanceledException e) {
            this.resource.getCache().clear((Resource)this.resource);
        }
        catch (OperationCanceledError e) {
            this.resource.getCache().clear((Resource)this.resource);
        }
        catch (RuntimeException exc) {
            log.error((Object)"Parsing in reconciler failed.", (Throwable)exc);
            throw exc;
        }
    }

    protected void postParse(XtextResource resource, final IProgressMonitor monitor) throws OperationCanceledError, OperationCanceledException {
        CancelIndicator cancelIndicator = new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
        try {
            DirtyStateEditorSupport dirtyStateEditorSupport;
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
            if (this.editor != null && (dirtyStateEditorSupport = this.editor.getDirtyStateEditorSupport()) != null && !monitor.isCanceled()) {
                dirtyStateEditorSupport.announceDirtyState(resource);
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"Error post-processing resource", (Throwable)e);
            resource.getCache().clear((Resource)resource);
        }
    }
}

