/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractJavaBasedContentProposalProvider
extends AbstractContentProposalProvider {
    private static final Logger log = Logger.getLogger(AbstractJavaBasedContentProposalProvider.class);
    @Inject
    private IEObjectHover hover;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private ReferenceProposalCreator crossReferenceProposalCreator;
    private final Map<String, PolymorphicDispatcher<Void>> dispatchers = new HashMap<String, PolymorphicDispatcher<Void>>();
    private Set<List<?>> handledArguments;

    protected AbstractJavaBasedContentProposalProvider() {
    }

    @Override
    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal proposal = this.createCompletionProposal(keyword.getValue(), this.getKeywordDisplayString(keyword), this.getImage((EObject)keyword), contentAssistContext);
        this.getPriorityHelper().adjustKeywordPriority(proposal, contentAssistContext.getPrefix());
        acceptor.accept(proposal);
    }

    @Override
    public void completeRuleCall(RuleCall ruleCall, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        AbstractRule calledRule = ruleCall.getRule();
        String methodName = "complete_" + calledRule.getName();
        this.invokeMethod(methodName, acceptor, contentAssistContext.getCurrentModel(), ruleCall, contentAssistContext);
    }

    @Override
    public void completeAssignment(Assignment assignment, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ParserRule parserRule = GrammarUtil.containingParserRule((EObject)assignment);
        String methodName = "complete" + Strings.toFirstUpper((String)parserRule.getName()) + "_" + Strings.toFirstUpper((String)assignment.getFeature());
        this.invokeMethod(methodName, acceptor, contentAssistContext.getCurrentModel(), assignment, contentAssistContext);
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, (Predicate<IEObjectDescription>)Predicates.alwaysTrue());
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, (Predicate<IEObjectDescription>)Predicates.alwaysTrue(), proposalFactory);
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule)) {
            EReference ref = GrammarUtil.getReference((CrossReference)crossReference);
            this.lookupCrossReference(crossReference, ref, contentAssistContext, acceptor, filter);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule)) {
            EReference ref = GrammarUtil.getReference((CrossReference)crossReference);
            this.lookupCrossReference((EObject)crossReference, ref, acceptor, filter, proposalFactory);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        String ruleName = null;
        if (crossReference.getTerminal() instanceof RuleCall) {
            ruleName = ((RuleCall)crossReference.getTerminal()).getRule().getName();
        }
        this.lookupCrossReference(contentAssistContext.getCurrentModel(), reference, acceptor, filter, this.getProposalFactory(ruleName, contentAssistContext));
    }

    protected void lookupCrossReference(EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        this.crossReferenceProposalCreator.lookupCrossReference(model, reference, acceptor, filter, proposalFactory);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        return new DefaultProposalCreator(contentAssistContext, ruleName, this.getQualifiedNameConverter());
    }

    @Override
    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            this.handledArguments = Sets.newHashSet();
            super.createProposals(context, acceptor);
        }
        finally {
            this.handledArguments = null;
        }
    }

    protected void invokeMethod(String methodName, ICompletionProposalAcceptor acceptor, Object ... params) {
        PolymorphicDispatcher<Void> dispatcher = this.dispatchers.get(methodName);
        if (dispatcher == null) {
            PolymorphicDispatcher.ErrorHandler errorHandler = PolymorphicDispatcher.WarningErrorHandler.get((Logger)log);
            dispatcher = new PolymorphicDispatcher<Void>(methodName, params.length + 1, params.length + 1, Collections.singletonList(this), errorHandler){

                public Class<?> getDefaultClass(int paramIndex) {
                    if (paramIndex == 0) {
                        return EObject.class;
                    }
                    return super.getDefaultClass(paramIndex);
                }
            };
            this.dispatchers.put(methodName, dispatcher);
        }
        Object[] paramAsArray = new Object[params.length + 1];
        System.arraycopy(params, 0, paramAsArray, 0, params.length);
        paramAsArray[params.length] = acceptor;
        if (this.announceProcessing(Lists.asList((Object)methodName, (Object[])paramAsArray))) {
            dispatcher.invoke(paramAsArray);
        }
    }

    protected boolean announceProcessing(List<?> key) {
        return this.handledArguments.add(key);
    }

    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public void setCrossReferenceProposalCreator(ReferenceProposalCreator crossReferenceProposalCreator) {
        this.crossReferenceProposalCreator = crossReferenceProposalCreator;
    }

    public ReferenceProposalCreator getCrossReferenceProposalCreator() {
        return this.crossReferenceProposalCreator;
    }

    public IEObjectHover getHover() {
        return this.hover;
    }

    protected class DefaultProposalCreator
    implements Function<IEObjectDescription, ICompletionProposal> {
        private final ContentAssistContext contentAssistContext;
        private final String ruleName;
        private final IQualifiedNameConverter qualifiedNameConverter;
        protected final IValueConverter<Object> valueConverter;

        public DefaultProposalCreator(ContentAssistContext contentAssistContext, String ruleName, IQualifiedNameConverter qualifiedNameConverter) {
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
            this.qualifiedNameConverter = qualifiedNameConverter;
            this.valueConverter = this.ruleName != null && AbstractJavaBasedContentProposalProvider.this.getValueConverter() instanceof IValueConverterService.Introspectable ? ((IValueConverterService.Introspectable)AbstractJavaBasedContentProposalProvider.this.getValueConverter()).getConverter(ruleName) : null;
        }

        public ICompletionProposal apply(IEObjectDescription candidate) {
            if (candidate == null) {
                return null;
            }
            ICompletionProposal result = null;
            String proposal = this.qualifiedNameConverter.toString(candidate.getName());
            if (this.valueConverter != null) {
                try {
                    proposal = this.valueConverter.toString((Object)proposal);
                }
                catch (ValueConverterException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            if (this.ruleName != null) {
                try {
                    proposal = AbstractJavaBasedContentProposalProvider.this.getValueConverter().toString((Object)proposal, this.ruleName);
                }
                catch (ValueConverterException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            EObject objectOrProxy = candidate.getEObjectOrProxy();
            StyledString displayString = AbstractJavaBasedContentProposalProvider.this.getStyledDisplayString(candidate);
            Image image = AbstractJavaBasedContentProposalProvider.this.getImage(objectOrProxy);
            result = AbstractJavaBasedContentProposalProvider.this.createCompletionProposal(proposal, displayString, image, this.contentAssistContext);
            if (result instanceof ConfigurableCompletionProposal) {
                ((ConfigurableCompletionProposal)result).setProposalContextResource((Resource)this.contentAssistContext.getResource());
                ((ConfigurableCompletionProposal)result).setAdditionalProposalInfo(objectOrProxy);
                ((ConfigurableCompletionProposal)result).setHover(AbstractJavaBasedContentProposalProvider.this.hover);
            }
            AbstractJavaBasedContentProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, this.contentAssistContext.getPrefix());
            return result;
        }
    }

    public static class ReferenceProposalCreator {
        @Inject
        private IScopeProvider scopeProvider;

        public final void lookupCrossReference(EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
            if (model != null) {
                IScope scope = this.getScopeProvider().getScope(model, reference);
                this.lookupCrossReference(scope, model, reference, acceptor, filter, proposalFactory);
            }
        }

        protected Function<IEObjectDescription, ICompletionProposal> getWrappedFactory(EObject model, EReference reference, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
            return proposalFactory;
        }

        public void lookupCrossReference(IScope scope, EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
            Function<IEObjectDescription, ICompletionProposal> wrappedFactory = this.getWrappedFactory(model, reference, proposalFactory);
            Iterable<IEObjectDescription> candidates = this.queryScope(scope, model, reference, filter);
            for (IEObjectDescription candidate : candidates) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                if (!filter.apply((Object)candidate)) continue;
                acceptor.accept((ICompletionProposal)wrappedFactory.apply((Object)candidate));
            }
        }

        public void setScopeProvider(IScopeProvider scopeProvider) {
            this.scopeProvider = scopeProvider;
        }

        public IScopeProvider getScopeProvider() {
            return this.scopeProvider;
        }

        public Iterable<IEObjectDescription> queryScope(IScope scope, EObject model, EReference reference, Predicate<IEObjectDescription> filter) {
            return scope.getAllElements();
        }
    }
}

