/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.generic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.IResourceScopeCache;

@Singleton
public class GenericResourceDescriptionManager
implements IResourceDescription.Manager {
    @Inject
    private IDefaultResourceDescriptionStrategy resourceDescriptionStrategy;
    @Inject
    private DescriptionUtils descriptionUtils;
    @Inject
    private IResourceScopeCache cache = new IResourceScopeCache.NullImpl();

    @Override
    public IResourceDescription getResourceDescription(Resource resource) {
        return new DefaultResourceDescription(resource, this.resourceDescriptionStrategy, this.cache);
    }

    @Override
    public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new DefaultResourceDescriptionDelta(oldDescription, newDescription);
    }

    @Override
    public boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate) throws IllegalArgumentException {
        return this.isAffected(Collections.singleton(delta), candidate, null);
    }

    @Override
    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
        Set<URI> outgoingReferences = this.descriptionUtils.collectOutgoingReferences(candidate);
        if (!outgoingReferences.isEmpty()) {
            for (IResourceDescription.Delta delta : deltas) {
                if (!delta.haveEObjectDescriptionsChanged() || !outgoingReferences.contains(delta.getUri())) continue;
                return true;
            }
        }
        return false;
    }
}

