/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.ui.containers.AbstractAllContainersState;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.ui.util.JavaProjectClasspathChangeAnalyzer;

public abstract class AbstractJavaProjectsState
extends AbstractAllContainersState
implements IElementChangedListener {
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private JavaProjectClasspathChangeAnalyzer javaProjectClasspathChangeAnalyzer;

    @Override
    protected void registerAsListener() {
        super.registerAsListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void unregisterAsListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        super.unregisterAsListener();
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getDelta() != null && this.isAffectingPackageFragmentRoots(event.getDelta())) {
            this.initialize();
        }
    }

    private boolean isAffectingPackageFragmentRoots(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            if (this.javaProjectClasspathChangeAnalyzer.isRelevantPackageFragmentRootChange(delta)) {
                return true;
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.isAffectingPackageFragmentRoots(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if (this.javaProjectClasspathChangeAnalyzer.isClasspathChangeOnProject(delta)) {
                    return !this.javaProjectClasspathChangeAnalyzer.isAttachmentChangeOnly(delta);
                }
                return this.isAffectingPackageFragmentRoots(delta.getAffectedChildren());
            }
        }
        return false;
    }

    private boolean isAffectingPackageFragmentRoots(IJavaElementDelta[] affectedChildren) {
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            if (this.isAffectingPackageFragmentRoots(delta)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected boolean isIgnoredResource(IResource resource) {
        return this.jdtHelper.isFromOutputPath(resource);
    }

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }

    public void setJavaProjectClasspathChangeAnalyzer(JavaProjectClasspathChangeAnalyzer javaProjectClasspathChangeAnalyzer) {
        this.javaProjectClasspathChangeAnalyzer = javaProjectClasspathChangeAnalyzer;
    }
}

