/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColoringInformation;
import org.eclipse.lsp4j.ColoringParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticHighlightingServerCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageClientExtensions;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ICapabilitiesContributor;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.ILanguageServerExtension;
import org.eclipse.xtext.ide.server.ILanguageServerShutdownAndExitHandler;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.codelens.ICodeLensResolver;
import org.eclipse.xtext.ide.server.codelens.ICodeLensService;
import org.eclipse.xtext.ide.server.coloring.IColoringService;
import org.eclipse.xtext.ide.server.commands.ExecutableCommandRegistry;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.ide.server.contentassist.ContentAssistService;
import org.eclipse.xtext.ide.server.findReferences.WorkspaceResourceAccess;
import org.eclipse.xtext.ide.server.formatting.FormattingService;
import org.eclipse.xtext.ide.server.hover.IHoverService;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.rename.IRenameService;
import org.eclipse.xtext.ide.server.rename.IRenameService2;
import org.eclipse.xtext.ide.server.semanticHighlight.SemanticHighlightingRegistry;
import org.eclipse.xtext.ide.server.signatureHelp.ISignatureHelpService;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.WorkspaceSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Log
public class LanguageServerImpl
implements LanguageServer,
WorkspaceService,
TextDocumentService,
LanguageClientAware,
Endpoint,
JsonRpcMethodProvider,
ILanguageServerAccess.IBuildListener {
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private RequestManager requestManager;
    @Inject
    private WorkspaceSymbolService workspaceSymbolService;
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    @Extension
    private IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    private ExecutableCommandRegistry commandRegistry;
    @Inject
    private SemanticHighlightingRegistry semanticHighlightingRegistry;
    @Inject
    private ILanguageServerShutdownAndExitHandler shutdownAndExitHandler;
    private WorkspaceManager workspaceManager;
    private InitializeParams params;
    private InitializeResult initializeResult;
    private CompletableFuture<InitializedParams> initialized = new CompletableFuture();
    private WorkspaceResourceAccess resourceAccess;
    private LanguageClient client;
    private Map<String, JsonRpcMethod> supportedMethods = null;
    private Multimap<String, Endpoint> extensionProviders = LinkedListMultimap.create();
    private ILanguageServerAccess access = new ILanguageServerAccess(){

        @Override
        public <T> CompletableFuture<T> doRead(String uri, Function<ILanguageServerAccess.Context, T> function) {
            Functions.Function1 _function = cancelIndicator -> {
                Functions.Function2 _function_1 = (document, resource) -> {
                    boolean _isDocumentOpen = LanguageServerImpl.this.workspaceManager.isDocumentOpen(resource.getURI());
                    ILanguageServerAccess.Context ctx = new ILanguageServerAccess.Context((Resource)resource, (Document)document, _isDocumentOpen, (CancelIndicator)cancelIndicator);
                    return function.apply(ctx);
                };
                return LanguageServerImpl.this.workspaceManager.doRead(LanguageServerImpl.this._uriExtensions.toUri(uri), _function_1);
            };
            return LanguageServerImpl.this.requestManager.runRead(_function);
        }

        @Override
        public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
            LanguageServerImpl.this.workspaceManager.addBuildListener(listener);
        }

        @Override
        public LanguageClient getLanguageClient() {
            return LanguageServerImpl.this.client;
        }

        @Override
        public ResourceSet newLiveScopeResourceSet(URI uri) {
            XtextResourceSet _xblockexpression = null;
            ProjectManager projectManager = LanguageServerImpl.this.workspaceManager.getProjectManager(uri);
            XtextResourceSet resourceSet = projectManager.createNewResourceSet(projectManager.getIndexState().getResourceDescriptions());
            resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.LIVE_SCOPE", true);
            _xblockexpression = resourceSet;
            return _xblockexpression;
        }

        @Override
        public InitializeParams getInitializeParams() {
            return LanguageServerImpl.this.params;
        }

        @Override
        public <T> CompletableFuture<T> doReadIndex(Function<? super ILanguageServerAccess.IndexContext, ? extends T> function) {
            Functions.Function1 _function = cancelIndicator -> {
                IResourceDescriptions _index = LanguageServerImpl.this.workspaceManager.getIndex();
                ILanguageServerAccess.IndexContext ctx = new ILanguageServerAccess.IndexContext(_index, (CancelIndicator)cancelIndicator);
                return function.apply(ctx);
            };
            return LanguageServerImpl.this.requestManager.runRead(_function);
        }

        @Override
        public InitializeResult getInitializeResult() {
            return LanguageServerImpl.this.initializeResult;
        }
    };
    private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class);

    @Inject
    public void setWorkspaceManager(WorkspaceManager manager) {
        WorkspaceResourceAccess _workspaceResourceAccess;
        this.workspaceManager = manager;
        this.resourceAccess = _workspaceResourceAccess = new WorkspaceResourceAccess(this.workspaceManager);
    }

    private Iterable<? extends IResourceServiceProvider> getAllLanguages() {
        Functions.Function1 _function = ext -> {
            URI synthUri = URI.createURI((String)("synth:///file." + ext));
            return this.languagesRegistry.getResourceServiceProvider(synthUri);
        };
        return IterableExtensions.toSet((Iterable)ListExtensions.map((List)IterableExtensions.sort((Iterable)IterableExtensions.toList(this.languagesRegistry.getExtensionToFactoryMap().keySet())), (Functions.Function1)_function));
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.params != null) {
            throw new IllegalStateException("This language server has already been initialized.");
        }
        URI baseDir = this.getBaseDir(params);
        boolean _isEmpty = this.languagesRegistry.getExtensionToFactoryMap().isEmpty();
        if (_isEmpty) {
            throw new IllegalStateException("No Xtext languages have been registered. Please make sure you have added the languages's setup class in '/META-INF/services/org.eclipse.xtext.ISetup'");
        }
        this.params = params;
        InitializeResult result = new InitializeResult();
        ServerCapabilities _serverCapabilities = new ServerCapabilities();
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            it.setHoverProvider(Boolean.valueOf(true));
            it.setDefinitionProvider(Boolean.valueOf(true));
            it.setReferencesProvider(Boolean.valueOf(true));
            it.setDocumentSymbolProvider(Boolean.valueOf(true));
            it.setWorkspaceSymbolProvider(Boolean.valueOf(true));
            Functions.Function1 _function_1 = it_1 -> {
                ICodeLensService _get = (ICodeLensService)it_1.get(ICodeLensService.class);
                return _get != null;
            };
            boolean _exists = IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_1);
            if (_exists) {
                CodeLensOptions _codeLensOptions = new CodeLensOptions();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    Functions.Function1 _function_3 = it_2 -> {
                        ICodeLensResolver _get = (ICodeLensResolver)it_2.get(ICodeLensResolver.class);
                        return _get != null;
                    };
                    it_1.setResolveProvider(IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_3));
                };
                CodeLensOptions _doubleArrow = (CodeLensOptions)ObjectExtensions.operator_doubleArrow((Object)_codeLensOptions, (Procedures.Procedure1)_function_2);
                it.setCodeLensProvider(_doubleArrow);
            }
            Functions.Function1 _function_3 = it_1 -> it_1.get(ICodeActionService.class) != null || it_1.get(ICodeActionService2.class) != null;
            it.setCodeActionProvider(Boolean.valueOf(IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_3)));
            SignatureHelpOptions _signatureHelpOptions = new SignatureHelpOptions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"(", ","})));
            it.setSignatureHelpProvider(_signatureHelpOptions);
            it.setTextDocumentSync(TextDocumentSyncKind.Incremental);
            CompletionOptions _completionOptions = new CompletionOptions();
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.setResolveProvider(Boolean.valueOf(false));
                it_1.setTriggerCharacters(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"."})));
            };
            CompletionOptions _doubleArrow_1 = (CompletionOptions)ObjectExtensions.operator_doubleArrow((Object)_completionOptions, (Procedures.Procedure1)_function_4);
            it.setCompletionProvider(_doubleArrow_1);
            it.setDocumentFormattingProvider(Boolean.valueOf(true));
            it.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
            it.setDocumentHighlightProvider(Boolean.valueOf(true));
            ClientCapabilities _capabilities = null;
            if (params != null) {
                _capabilities = params.getCapabilities();
            }
            TextDocumentClientCapabilities _textDocument = null;
            if (_capabilities != null) {
                _textDocument = _capabilities.getTextDocument();
            }
            RenameCapabilities _rename = null;
            if (_textDocument != null) {
                _rename = _textDocument.getRename();
            }
            Boolean _prepareSupport = null;
            if (_rename != null) {
                _prepareSupport = _rename.getPrepareSupport();
            }
            boolean clientPrepareSupport = Objects.equal((Object)Boolean.TRUE, (Object)_prepareSupport);
            Either _xifexpression = null;
            if (clientPrepareSupport && IterableExtensions.exists(this.getAllLanguages(), it_1 -> {
                IRenameService2 _get = (IRenameService2)it_1.get(IRenameService2.class);
                return _get != null;
            })) {
                RenameOptions _renameOptions = new RenameOptions();
                Procedures.Procedure1 _function_5 = it_1 -> it_1.setPrepareProvider(Boolean.valueOf(true));
                RenameOptions _doubleArrow_2 = (RenameOptions)ObjectExtensions.operator_doubleArrow((Object)_renameOptions, (Procedures.Procedure1)_function_5);
                _xifexpression = Either.forRight((Object)_doubleArrow_2);
            } else {
                Functions.Function1 _function_6 = it_1 -> it_1.get(IRenameService.class) != null || it_1.get(IRenameService2.class) != null;
                _xifexpression = Either.forLeft((Object)IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_6));
            }
            it.setRenameProvider(_xifexpression);
            ClientCapabilities clientCapabilities = params.getCapabilities();
            WorkspaceClientCapabilities _workspace = null;
            if (clientCapabilities != null) {
                _workspace = clientCapabilities.getWorkspace();
            }
            ExecuteCommandCapabilities _executeCommand = null;
            if (_workspace != null) {
                _executeCommand = _workspace.getExecuteCommand();
            }
            boolean bl = _tripleNotEquals = _executeCommand != null;
            if (_tripleNotEquals) {
                this.commandRegistry.initialize(this.getAllLanguages(), clientCapabilities, this.client);
                ExecuteCommandOptions _executeCommandOptions = new ExecuteCommandOptions();
                Procedures.Procedure1 _function_7 = it_1 -> it_1.setCommands(this.commandRegistry.getCommands());
                ExecuteCommandOptions _doubleArrow_3 = (ExecuteCommandOptions)ObjectExtensions.operator_doubleArrow((Object)_executeCommandOptions, (Procedures.Procedure1)_function_7);
                it.setExecuteCommandProvider(_doubleArrow_3);
            }
            this.semanticHighlightingRegistry.initialize(this.getAllLanguages(), clientCapabilities, this.client);
            List<List<String>> _allScopes = this.semanticHighlightingRegistry.getAllScopes();
            SemanticHighlightingServerCapabilities _semanticHighlightingServerCapabilities = new SemanticHighlightingServerCapabilities(_allScopes);
            it.setSemanticHighlighting(_semanticHighlightingServerCapabilities);
        };
        ServerCapabilities capabilities = (ServerCapabilities)ObjectExtensions.operator_doubleArrow((Object)_serverCapabilities, (Procedures.Procedure1)_function);
        Iterable<? extends IResourceServiceProvider> _allLanguages = this.getAllLanguages();
        for (IResourceServiceProvider iResourceServiceProvider : _allLanguages) {
            ICapabilitiesContributor _get = (ICapabilitiesContributor)iResourceServiceProvider.get(ICapabilitiesContributor.class);
            if (_get == null) continue;
            _get.contribute(capabilities, params);
        }
        result.setCapabilities(capabilities);
        this.access.addBuildListener(this);
        Functions.Function0 _function_1 = () -> {
            Procedures.Procedure2 _function_2 = ($0, $1) -> this.publishDiagnostics((URI)$0, (Iterable<? extends Issue>)$1);
            this.workspaceManager.initialize(baseDir, (Procedures.Procedure2<? super URI, ? super Iterable<Issue>>)_function_2, CancelIndicator.NullImpl);
            return null;
        };
        Functions.Function2 function2 = ($0, $1) -> null;
        Function<Object, InitializeResult> _function_3 = it -> {
            this.initializeResult = result;
            return result;
        };
        return this.requestManager.runWrite(_function_1, function2).thenApply(_function_3);
    }

    public void initialized(InitializedParams params) {
        this.initialized.complete(params);
    }

    @Deprecated
    private URI deprecatedToBaseDir(InitializeParams params) {
        boolean _tripleNotEquals;
        String _rootPath = params.getRootPath();
        boolean bl = _tripleNotEquals = _rootPath != null;
        if (_tripleNotEquals) {
            return this._uriExtensions.toUri(this._uriExtensions.toUriString(URI.createFileURI((String)params.getRootPath())));
        }
        return null;
    }

    protected URI getBaseDir(InitializeParams params) {
        boolean _tripleNotEquals;
        String _rootUri = params.getRootUri();
        boolean bl = _tripleNotEquals = _rootUri != null;
        if (_tripleNotEquals) {
            return this._uriExtensions.toUri(params.getRootUri());
        }
        return this.deprecatedToBaseDir(params);
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        this.shutdownAndExitHandler.exit();
    }

    public CompletableFuture<Object> shutdown() {
        this.shutdownAndExitHandler.shutdown();
        Object _object = new Object();
        return CompletableFuture.completedFuture(_object);
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        Functions.Function0 _function = () -> this.workspaceManager.didOpen(this._uriExtensions.toUri(params.getTextDocument().getUri()), params.getTextDocument().getVersion(), params.getTextDocument().getText());
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Functions.Function0 _function = () -> this.workspaceManager.didChangeTextDocumentContent(this._uriExtensions.toUri(params.getTextDocument().getUri()), params.getTextDocument().getVersion(), params.getContentChanges());
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Functions.Function0 _function = () -> this.workspaceManager.didClose(this._uriExtensions.toUri(params.getTextDocument().getUri()));
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        Functions.Function0 _function = () -> {
            ArrayList dirtyFiles = CollectionLiterals.newArrayList();
            ArrayList deletedFiles = CollectionLiterals.newArrayList();
            Functions.Function1 _function_1 = fileEvent -> {
                URI _uri = this._uriExtensions.toUri(fileEvent.getUri());
                FileChangeType _type = fileEvent.getType();
                return Pair.of((Object)_uri, (Object)_type);
            };
            Functions.Function1 _function_2 = it -> {
                boolean _isDocumentOpen = this.workspaceManager.isDocumentOpen((URI)it.getKey());
                return !_isDocumentOpen;
            };
            Consumer<Pair> _function_3 = it -> {
                boolean _tripleEquals;
                FileChangeType _value = (FileChangeType)it.getValue();
                boolean bl = _tripleEquals = _value == FileChangeType.Deleted;
                if (_tripleEquals) {
                    URI _key = (URI)it.getKey();
                    deletedFiles.add(_key);
                } else {
                    URI _key_1 = (URI)it.getKey();
                    dirtyFiles.add(_key_1);
                }
            };
            IterableExtensions.filter((Iterable)ListExtensions.map((List)params.getChanges(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
            return this.workspaceManager.didChangeFiles(dirtyFiles, deletedFiles);
        };
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Functions.Function0 _function = () -> {
            this.workspaceManager.refreshWorkspaceConfig(CancelIndicator.NullImpl);
            return null;
        };
        Functions.Function2 _function_1 = ($0, $1) -> null;
        this.requestManager.runWrite(_function, _function_1);
    }

    private void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        Consumer<InitializedParams> _function = it -> {
            PublishDiagnosticsParams _publishDiagnosticsParams = new PublishDiagnosticsParams();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setUri(this._uriExtensions.toUriString(uri));
                Functions.Function1 _function_2 = it_2 -> {
                    Severity _severity = it_2.getSeverity();
                    return _severity != Severity.IGNORE;
                };
                Functions.Function1 _function_3 = it_2 -> this.toDiagnostic((Issue)it_2);
                it_1.setDiagnostics(IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function_2), (Functions.Function1)_function_3)));
            };
            PublishDiagnosticsParams diagnostics = (PublishDiagnosticsParams)ObjectExtensions.operator_doubleArrow((Object)_publishDiagnosticsParams, (Procedures.Procedure1)_function_1);
            this.client.publishDiagnostics(diagnostics);
        };
        this.initialized.thenAccept((Consumer)_function);
    }

    private Diagnostic toDiagnostic(Issue issue) {
        Diagnostic _diagnostic = new Diagnostic();
        Procedures.Procedure1 _function = it -> {
            it.setCode(issue.getCode());
            DiagnosticSeverity _switchResult = null;
            Severity _severity = issue.getSeverity();
            if (_severity != null) {
                switch (_severity) {
                    case ERROR: {
                        _switchResult = DiagnosticSeverity.Error;
                        break;
                    }
                    case WARNING: {
                        _switchResult = DiagnosticSeverity.Warning;
                        break;
                    }
                    case INFO: {
                        _switchResult = DiagnosticSeverity.Information;
                        break;
                    }
                    default: {
                        _switchResult = DiagnosticSeverity.Hint;
                        break;
                    }
                }
            } else {
                _switchResult = DiagnosticSeverity.Hint;
            }
            it.setSeverity(_switchResult);
            it.setMessage(issue.getMessage());
            Integer _elvis = null;
            Integer _lineNumber = issue.getLineNumber();
            _elvis = _lineNumber != null ? _lineNumber : Integer.valueOf(1);
            int lineNumber = _elvis - 1;
            Integer _elvis_1 = null;
            Integer _column = issue.getColumn();
            _elvis_1 = _column != null ? _column : Integer.valueOf(1);
            int column = _elvis_1 - 1;
            Integer _elvis_2 = null;
            Integer _length = issue.getLength();
            _elvis_2 = _length != null ? _length : Integer.valueOf(0);
            Integer length = _elvis_2;
            Position _position = new Position(lineNumber, column);
            Position _position_1 = new Position(lineNumber, column + length);
            Range _range = new Range(_position, _position_1);
            it.setRange(_range);
        };
        return (Diagnostic)ObjectExtensions.operator_doubleArrow((Object)_diagnostic, (Procedures.Procedure1)_function);
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        Functions.Function1 _function = cancelIndicator -> this.completion((CancelIndicator)cancelIndicator, params);
        return this.requestManager.runRead(_function);
    }

    protected Either<List<CompletionItem>, CompletionList> completion(CancelIndicator originalCancelIndicator, CompletionParams params) {
        ContentAssistService contentAssistService;
        BufferedCancelIndicator cancelIndicator = new BufferedCancelIndicator(originalCancelIndicator);
        URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        ContentAssistService _get = null;
        if (resourceServiceProvider != null) {
            _get = (ContentAssistService)resourceServiceProvider.get(ContentAssistService.class);
        }
        if ((contentAssistService = _get) == null) {
            CompletionList _completionList = new CompletionList();
            return Either.forRight((Object)_completionList);
        }
        Functions.Function2 _function = (document, resource) -> contentAssistService.createCompletionList((Document)document, (XtextResource)resource, (TextDocumentPositionParams)params, cancelIndicator);
        CompletionList completionList = (CompletionList)this.workspaceManager.doRead(uri, _function);
        return Either.forRight((Object)completionList);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> Either.forLeft(this.definition((CancelIndicator)cancelIndicator, params));
        return this.requestManager.runRead(_function);
    }

    protected List<? extends Location> definition(CancelIndicator cancelIndicator, TextDocumentPositionParams params) {
        DocumentSymbolService documentSymbolService;
        URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        DocumentSymbolService _get = null;
        if (resourceServiceProvider != null) {
            _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
        }
        if ((documentSymbolService = _get) == null) {
            return CollectionLiterals.emptyList();
        }
        Functions.Function2 _function = (document, resource) -> documentSymbolService.getDefinitions((Document)document, (XtextResource)resource, params, this.resourceAccess, cancelIndicator);
        return (List)this.workspaceManager.doRead(uri, _function);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> documentSymbolService.getReferences((Document)document, (XtextResource)resource, params, this.resourceAccess, this.workspaceManager.getIndex(), (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IDocumentSymbolService documentSymbolService = this.getIDocumentSymbolService(resourceServiceProvider);
            if (documentSymbolService == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> documentSymbolService.getSymbols((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    protected IDocumentSymbolService getIDocumentSymbolService(IResourceServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            return null;
        }
        Class _xifexpression = null;
        boolean _isHierarchicalDocumentSymbolSupport = this.isHierarchicalDocumentSymbolSupport();
        _xifexpression = _isHierarchicalDocumentSymbolSupport ? HierarchicalDocumentSymbolService.class : DocumentSymbolService.class;
        Class documentSymbolServiceClass = _xifexpression;
        return (IDocumentSymbolService)serviceProvider.get(documentSymbolServiceClass);
    }

    protected boolean isHierarchicalDocumentSymbolSupport() {
        Boolean _elvis = null;
        ClientCapabilities _capabilities = this.params.getCapabilities();
        TextDocumentClientCapabilities _textDocument = null;
        if (_capabilities != null) {
            _textDocument = _capabilities.getTextDocument();
        }
        DocumentSymbolCapabilities _documentSymbol = null;
        if (_textDocument != null) {
            _documentSymbol = _textDocument.getDocumentSymbol();
        }
        Boolean _hierarchicalDocumentSymbolSupport = null;
        if (_documentSymbol != null) {
            _hierarchicalDocumentSymbolSupport = _documentSymbol.getHierarchicalDocumentSymbolSupport();
        }
        _elvis = _hierarchicalDocumentSymbolSupport != null ? _hierarchicalDocumentSymbolSupport : Boolean.valueOf(false);
        return _elvis;
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IResourceDescriptions indexData = this.workspaceManager.getIndex();
            return this.workspaceSymbolService.getSymbols(params.getQuery(), this.resourceAccess, indexData, (CancelIndicator)cancelIndicator);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IHoverService hoverService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IHoverService _get = null;
            if (resourceServiceProvider != null) {
                _get = (IHoverService)resourceServiceProvider.get(IHoverService.class);
            }
            if ((hoverService = _get) == null) {
                return IHoverService.EMPTY_HOVER;
            }
            Functions.Function2 _function_1 = (document, resource) -> hoverService.hover((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (Hover)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ISignatureHelpService helper;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ISignatureHelpService _get = null;
            if (serviceProvider != null) {
                _get = (ISignatureHelpService)serviceProvider.get(ISignatureHelpService.class);
            }
            if ((helper = _get) == null) {
                return ISignatureHelpService.EMPTY;
            }
            Functions.Function2 _function_1 = (doc, resource) -> helper.getSignatureHelp((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (SignatureHelp)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IDocumentHighlightService service;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IDocumentHighlightService _get = null;
            if (serviceProvider != null) {
                _get = (IDocumentHighlightService)serviceProvider.get(IDocumentHighlightService.class);
            }
            if ((service = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (doc, resource) -> service.getDocumentHighlights((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeActionService _get = null;
            if (serviceProvider != null) {
                _get = (ICodeActionService)serviceProvider.get(ICodeActionService.class);
            }
            ICodeActionService service = _get;
            ICodeActionService2 _get_1 = null;
            if (serviceProvider != null) {
                _get_1 = (ICodeActionService2)serviceProvider.get(ICodeActionService2.class);
            }
            ICodeActionService2 service2 = _get_1;
            if (service == null && service2 == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (doc, resource) -> {
                List<Either<Command, CodeAction>> _emptyList_1;
                List<Either<Command, CodeAction>> _emptyList;
                ArrayList result = CollectionLiterals.newArrayList();
                List<Either<Command, CodeAction>> _elvis = null;
                List<Either<Command, CodeAction>> _codeActions = null;
                if (service != null) {
                    _codeActions = service.getCodeActions((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
                }
                _elvis = _codeActions != null ? _codeActions : (_emptyList = CollectionLiterals.emptyList());
                Iterables.addAll((Collection)result, _elvis);
                List<Either<Command, CodeAction>> _elvis_1 = null;
                List<Either<Command, CodeAction>> _codeActions_1 = null;
                if (service2 != null) {
                    ICodeActionService2.Options _options = new ICodeActionService2.Options();
                    Procedures.Procedure1 _function_2 = o -> {
                        o.setDocument((Document)doc);
                        o.setResource((XtextResource)resource);
                        o.setLanguageServerAccess(this.access);
                        o.setCodeActionParams(params);
                        o.setCancelIndicator((CancelIndicator)cancelIndicator);
                    };
                    ICodeActionService2.Options _doubleArrow = (ICodeActionService2.Options)ObjectExtensions.operator_doubleArrow((Object)_options, (Procedures.Procedure1)_function_2);
                    _codeActions_1 = service2.getCodeActions(_doubleArrow);
                }
                _elvis_1 = _codeActions_1 != null ? _codeActions_1 : (_emptyList_1 = CollectionLiterals.emptyList());
                Iterables.addAll((Collection)result, (Iterable)_elvis_1);
                return result;
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    private void installURI(List<? extends CodeLens> codeLenses, String uri) {
        for (CodeLens codeLens : codeLenses) {
            boolean _tripleNotEquals;
            Object _data = codeLens.getData();
            boolean bl = _tripleNotEquals = _data != null;
            if (_tripleNotEquals) {
                codeLens.setData((Object)CollectionLiterals.newArrayList((Object[])new Object[]{uri, codeLens.getData()}));
                continue;
            }
            codeLens.setData((Object)uri);
        }
    }

    private URI uninstallURI(CodeLens lens) {
        URI result = null;
        Object _data = lens.getData();
        if (_data instanceof String) {
            result = URI.createURI((String)lens.getData().toString());
            lens.setData(null);
        } else {
            Object _data_1 = lens.getData();
            if (_data_1 instanceof List) {
                Object _data_2 = lens.getData();
                List l = (List)_data_2;
                result = URI.createURI((String)IterableExtensions.head((Iterable)l).toString());
                lens.setData(l.get(1));
            }
        }
        return result;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ICodeLensService codeLensService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeLensService _get = null;
            if (resourceServiceProvider != null) {
                _get = (ICodeLensService)resourceServiceProvider.get(ICodeLensService.class);
            }
            if ((codeLensService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                List<? extends CodeLens> result = codeLensService.computeCodeLenses((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
                this.installURI(result, uri.toString());
                return result;
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        URI uri = this.uninstallURI(unresolved);
        if (uri == null) {
            return CompletableFuture.completedFuture(unresolved);
        }
        Functions.Function1 _function = cancelIndicator -> {
            ICodeLensResolver resolver;
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeLensResolver _get = null;
            if (resourceServiceProvider != null) {
                _get = (ICodeLensResolver)resourceServiceProvider.get(ICodeLensResolver.class);
            }
            if ((resolver = _get) == null) {
                return unresolved;
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                CodeLens result = resolver.resolveCodeLens((Document)document, (XtextResource)resource, unresolved, (CancelIndicator)cancelIndicator);
                return result;
            };
            return (CodeLens)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Functions.Function1 _function = cancelIndicator -> this.commandRegistry.executeCommand(params, this.access, (CancelIndicator)cancelIndicator);
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams renameParams) {
        Functions.Function1 _function = cancelIndicator -> {
            IRenameService2 renameService2;
            IRenameService renameServiceOld;
            URI uri = this._uriExtensions.toUri(renameParams.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IRenameService _get = null;
            if (resourceServiceProvider != null) {
                _get = (IRenameService)resourceServiceProvider.get(IRenameService.class);
            }
            if ((renameServiceOld = _get) != null) {
                return renameServiceOld.rename(this.workspaceManager, renameParams, (CancelIndicator)cancelIndicator);
            }
            IRenameService2 _get_1 = null;
            if (resourceServiceProvider != null) {
                _get_1 = (IRenameService2)resourceServiceProvider.get(IRenameService2.class);
            }
            if ((renameService2 = _get_1) != null) {
                IRenameService2.Options _options = new IRenameService2.Options();
                Procedures.Procedure1 _function_1 = o -> {
                    o.setLanguageServerAccess(this.access);
                    o.setRenameParams(renameParams);
                    o.setCancelIndicator((CancelIndicator)cancelIndicator);
                };
                IRenameService2.Options _doubleArrow = (IRenameService2.Options)ObjectExtensions.operator_doubleArrow((Object)_options, (Procedures.Procedure1)_function_1);
                return renameService2.rename(_doubleArrow);
            }
            return new WorkspaceEdit();
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Either<Range, PrepareRenameResult>> prepareRename(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IRenameService2 renameService;
            Either<Range, PrepareRenameResult> _xblockexpression = null;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IRenameService2 _get = null;
            if (resourceServiceProvider != null) {
                _get = (IRenameService2)resourceServiceProvider.get(IRenameService2.class);
            }
            if ((renameService = _get) == null) {
                throw new UnsupportedOperationException();
            }
            IRenameService2.PrepareRenameOptions _prepareRenameOptions = new IRenameService2.PrepareRenameOptions();
            Procedures.Procedure1 _function_1 = it -> {
                it.setLanguageServerAccess(this.access);
                it.setParams(params);
                it.setCancelIndicator((CancelIndicator)cancelIndicator);
            };
            IRenameService2.PrepareRenameOptions _doubleArrow = (IRenameService2.PrepareRenameOptions)ObjectExtensions.operator_doubleArrow((Object)_prepareRenameOptions, (Procedures.Procedure1)_function_1);
            _xblockexpression = renameService.prepareRename(_doubleArrow);
            return _xblockexpression;
        };
        return this.requestManager.runRead(_function);
    }

    public void notify(String method, Object parameter) {
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                endpoint.notify(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        boolean _not;
        boolean _containsKey = this.extensionProviders.containsKey((Object)method);
        boolean bl = _not = !_containsKey;
        if (_not) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                return endpoint.request(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionProviders;
        synchronized (multimap) {
            LinkedHashMap supportedMethods = CollectionLiterals.newLinkedHashMap();
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.getClass()));
            LinkedHashMap extensions = CollectionLiterals.newLinkedHashMap();
            Iterable _filter = Iterables.filter((Iterable)IterableExtensions.toSet(this.languagesRegistry.getExtensionToFactoryMap().values()), IResourceServiceProvider.class);
            for (IResourceServiceProvider resourceServiceProvider : _filter) {
                ILanguageServerExtension ext = (ILanguageServerExtension)resourceServiceProvider.get(ILanguageServerExtension.class);
                if (ext == null) continue;
                ext.initialize(this.access);
                Map _xifexpression = null;
                _xifexpression = ext instanceof JsonRpcMethodProvider ? ((JsonRpcMethodProvider)ext).supportedMethods() : ServiceEndpoints.getSupportedMethods(ext.getClass());
                Map supportedExtensions = _xifexpression;
                Set _entrySet = supportedExtensions.entrySet();
                for (Map.Entry entry : _entrySet) {
                    boolean _containsKey = supportedMethods.containsKey(entry.getKey());
                    if (_containsKey) {
                        String _key = (String)entry.getKey();
                        String _plus = "The json rpc method '" + _key;
                        String _plus_1 = _plus + "' can not be an extension as it is already defined in the LSP standard.";
                        LOG.error((Object)_plus_1);
                        continue;
                    }
                    JsonRpcMethod existing = (JsonRpcMethod)extensions.put(entry.getKey(), entry.getValue());
                    if (existing != null && !Objects.equal((Object)existing, entry.getValue())) {
                        String _key_1 = (String)entry.getKey();
                        String _plus_2 = "An incompatible LSP extension '" + _key_1;
                        String _plus_3 = _plus_2 + "' has already been registered. Using 1 ignoring 2. \n1 : ";
                        String _plus_4 = _plus_3 + existing;
                        String _plus_5 = _plus_4 + " \n2 : ";
                        JsonRpcMethod _value = (JsonRpcMethod)entry.getValue();
                        String _plus_6 = _plus_5 + _value;
                        LOG.error((Object)_plus_6);
                        extensions.put(entry.getKey(), existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    this.extensionProviders.put(entry.getKey(), (Object)endpoint);
                    supportedMethods.put(entry.getKey(), entry.getValue());
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    @Override
    public void afterBuild(List<IResourceDescription.Delta> deltas) {
        Functions.Function1 _function = it -> {
            IResourceDescription _new = it.getNew();
            return _new != null;
        };
        Functions.Function1 _function_1 = it -> it.getUri().toString();
        Consumer<String> _function_2 = it -> {
            Function<ILanguageServerAccess.Context, Void> _function_3 = ctx -> {
                Resource _resource;
                boolean _isDocumentOpen = ctx.isDocumentOpen();
                if (_isDocumentOpen && (_resource = ctx.getResource()) instanceof XtextResource) {
                    IColoringService coloringService;
                    Resource _resource_1 = ctx.getResource();
                    XtextResource resource = (XtextResource)_resource_1;
                    IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(resource.getURI());
                    IColoringService _get = null;
                    if (serviceProvider != null) {
                        _get = (IColoringService)serviceProvider.get(IColoringService.class);
                    }
                    if ((coloringService = _get) != null && this.client instanceof LanguageClientExtensions) {
                        boolean _not;
                        Document doc = ctx.getDocument();
                        List<? extends ColoringInformation> coloringInfos = coloringService.getColoring(resource, doc);
                        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(coloringInfos);
                        boolean bl = _not = !_isNullOrEmpty;
                        if (_not) {
                            String uri = resource.getURI().toString();
                            ColoringParams _coloringParams = new ColoringParams(uri, coloringInfos);
                            ((LanguageClientExtensions)this.client).updateColoring(_coloringParams);
                        }
                    }
                }
                this.semanticHighlightingRegistry.update((ILanguageServerAccess.Context)ctx);
                return null;
            };
            this.access.doRead((String)it, _function_3);
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter(deltas, (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    protected ILanguageServerAccess getLanguageServerAccess() {
        return this.access;
    }

    protected LanguageClient getLanguageClient() {
        return this.client;
    }

    protected ExecutableCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    protected Multimap<String, Endpoint> getExtensionProviders() {
        return ImmutableMultimap.copyOf(this.extensionProviders);
    }

    protected Map<String, JsonRpcMethod> getSupportedMethods() {
        return ImmutableMap.copyOf(this.supportedMethods);
    }

    protected IResourceServiceProvider.Registry getLanguagesRegistry() {
        return this.languagesRegistry;
    }

    protected IReferenceFinder.IResourceAccess getWorkspaceResourceAccess() {
        return this.resourceAccess;
    }

    protected WorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    protected WorkspaceSymbolService getWorkspaceSymbolService() {
        return this.workspaceSymbolService;
    }

    @Pure
    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    @FinalFieldsConstructor
    public static class BufferedCancelIndicator
    implements CancelIndicator {
        private final CancelIndicator delegate;
        private Long canceledSince;

        public boolean isCanceled() {
            if (this.canceledSince == null && this.delegate.isCanceled()) {
                this.canceledSince = System.currentTimeMillis();
                return false;
            }
            return this.canceledSince != null && System.currentTimeMillis() > this.canceledSince + 1000L;
        }

        public BufferedCancelIndicator(CancelIndicator delegate) {
            this.delegate = delegate;
        }
    }
}

