/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor.actions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.util.ClipboardUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.ui.editor.actions.IClipboardActionFactory;
import org.eclipse.xtext.xbase.ui.imports.ImportsUtil;
import org.eclipse.xtext.xbase.ui.internal.XbaseActivator;

public class ImportsAwareClipboardAction
extends TextEditorAction {
    private static final XbaseClipboardTransfer TRANSFER_INSTANCE = new XbaseClipboardTransfer();
    private final int operationCode;
    private ITextOperationTarget textOperationTarget;
    @Inject
    private ImportsUtil importsUtil;

    public ImportsAwareClipboardAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.operationCode = operationCode;
        if (operationCode == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (operationCode == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (operationCode == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    protected void internalDoOperation() {
        if (this.operationCode == 5) {
            this.doPasteWithImportsOperation();
        } else {
            this.doCutCopyWithImportsOperation();
        }
    }

    private void doCutCopyWithImportsOperation() {
        try {
            final XbaseClipboardData cbData = this.createClipboardData();
            if (cbData != null) {
                ClipboardUtil.clipboardOperation((Function)new Function<Clipboard, Boolean>(){

                    public Boolean apply(Clipboard clipboard) {
                        LinkedHashMap payload = Maps.newLinkedHashMap();
                        payload.put(cbData, TRANSFER_INSTANCE);
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        String textData = (String)clipboard.getContents((Transfer)textTransfer);
                        if (textData == null || textData.isEmpty()) {
                            return Boolean.FALSE;
                        }
                        payload.put(textData, textTransfer);
                        RTFTransfer rtfTransfer = RTFTransfer.getInstance();
                        String rtfData = (String)clipboard.getContents((Transfer)rtfTransfer);
                        if (rtfData != null && !rtfData.isEmpty()) {
                            payload.put(rtfData, rtfTransfer);
                        }
                        ArrayList datas = Lists.newArrayList();
                        ArrayList dataTypes = Lists.newArrayList();
                        for (Map.Entry entry : payload.entrySet()) {
                            datas.add(entry.getKey());
                            dataTypes.add((Transfer)entry.getValue());
                        }
                        try {
                            clipboard.setContents(datas.toArray(), dataTypes.toArray(new Transfer[0]));
                            return Boolean.TRUE;
                        }
                        catch (SWTError e) {
                            if (e.code != 2002) {
                                throw e;
                            }
                            if (MessageDialog.openQuestion((Shell)ImportsAwareClipboardAction.this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_ErrorTitle, (String)ActionMessages.CopyQualifiedNameAction_ErrorDescription)) {
                                clipboard.setContents(datas.toArray(), dataTypes.toArray(new Transfer[0]));
                                return Boolean.TRUE;
                            }
                            return Boolean.FALSE;
                        }
                    }
                });
            }
        }
        finally {
            this.textOperationTarget.doOperation(this.operationCode);
        }
    }

    private void doPasteWithImportsOperation() {
        XbaseClipboardData xbaseClipboardData = (XbaseClipboardData)ClipboardUtil.clipboardOperation((Function)new Function<Clipboard, XbaseClipboardData>(){

            public XbaseClipboardData apply(Clipboard input) {
                Object content = input.getContents((Transfer)TRANSFER_INSTANCE);
                if (content instanceof XbaseClipboardData) {
                    return (XbaseClipboardData)content;
                }
                return null;
            }
        });
        ClipboardUtil.JavaImportData javaImportsContent = ClipboardUtil.getJavaImportsContent();
        String textFromClipboard = ClipboardUtil.getTextFromClipboard();
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)this.getTextEditor());
        boolean addImports = this.shouldAddImports((IDocument)xtextEditor.getDocument(), this.caretOffset(xtextEditor));
        if (xbaseClipboardData != null && !this.sameTarget(xbaseClipboardData)) {
            this.doPasteXbaseCode(xbaseClipboardData, addImports);
        } else if (javaImportsContent != null) {
            this.doPasteJavaCode(textFromClipboard, javaImportsContent, addImports);
        } else {
            this.textOperationTarget.doOperation(this.operationCode);
        }
    }

    protected boolean shouldAddImports(IDocument document, int caretOffset) {
        if (caretOffset == 0) {
            return true;
        }
        String typeRight = "__dftl_partition_content_type";
        String typeLeft = "__dftl_partition_content_type";
        try {
            typeRight = TextUtilities.getContentType((IDocument)document, (String)"__dftl_partitioning", (int)caretOffset, (boolean)false);
            typeLeft = TextUtilities.getContentType((IDocument)document, (String)"__dftl_partitioning", (int)(caretOffset > 0 ? caretOffset - 1 : caretOffset), (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return !"__comment".equals(typeRight) && !"__string".equals(typeRight) && !"__sl_comment".equals(typeRight) && !"__rich_string".equals(typeRight) || !typeLeft.equals(typeRight);
    }

    private int caretOffset(XtextEditor xtextEditor) {
        ISourceViewer sourceViewer = xtextEditor.getInternalSourceViewer();
        int caretOffset = sourceViewer.getTextWidget().getCaretOffset();
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
        }
        return caretOffset;
    }

    private void doPasteXbaseCode(XbaseClipboardData xbaseClipboardData, boolean withImports) {
        IRewriteTarget target = (IRewriteTarget)this.getTextEditor().getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        try {
            try {
                this.textOperationTarget.doOperation(this.operationCode);
                if (withImports) {
                    this.importsUtil.addImports(xbaseClipboardData.getImports(), xbaseClipboardData.getStaticImports(), xbaseClipboardData.getExtensionImports(), this.getXtextDocument());
                }
            }
            catch (Exception e) {
                XbaseActivator.getInstance().getLog().log((IStatus)new Status(4, XbaseActivator.getInstance().getBundle().getSymbolicName(), "Unexpected internal error: ", (Throwable)e));
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private void doPasteJavaCode(String textFromClipboard, ClipboardUtil.JavaImportData javaImportsContent, boolean withImports) {
        IRewriteTarget target = (IRewriteTarget)this.getTextEditor().getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        try {
            try {
                this.textOperationTarget.doOperation(this.operationCode);
                if (withImports) {
                    this.importsUtil.addImports(javaImportsContent.getImports(), javaImportsContent.getStaticImports(), new String[0], this.getXtextDocument());
                }
            }
            catch (Exception e) {
                XbaseActivator.getInstance().getLog().log((IStatus)new Status(4, XbaseActivator.getInstance().getBundle().getSymbolicName(), "Unexpected internal error: ", (Throwable)e));
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private boolean sameTarget(XbaseClipboardData xbaseClipboardData) {
        IEditorInput editorInput = this.getTextEditor().getEditorInput();
        if (editorInput == null) {
            return false;
        }
        return xbaseClipboardData.getSourceIndentifier().equals(editorInput.toString());
    }

    private XbaseClipboardData createClipboardData() {
        try {
            IEditorInput editorInput = this.getTextEditor().getEditorInput();
            final String sourceIdentifier = editorInput != null ? editorInput.toString() : "nullEditorInput";
            IXtextDocument document = this.getXtextDocument();
            ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && !selection.isEmpty()) {
                final ITextSelection textSelection = (ITextSelection)selection;
                return (XbaseClipboardData)document.readOnly((IUnitOfWork)new IUnitOfWork<XbaseClipboardData, XtextResource>(){

                    public XbaseClipboardData exec(XtextResource state) throws Exception {
                        TextRegion region = new TextRegion(textSelection.getOffset(), textSelection.getLength() - 1);
                        Triple<Set<String>, Set<String>, Set<String>> imports = ImportsAwareClipboardAction.this.importsUtil.collectImports(state, (ITextRegion)region);
                        XbaseClipboardData clipboardData = new XbaseClipboardData(sourceIdentifier, (String[])Iterables.toArray((Iterable)((Iterable)imports.getFirst()), String.class), (String[])Iterables.toArray((Iterable)((Iterable)imports.getSecond()), String.class), (String[])Iterables.toArray((Iterable)((Iterable)imports.getThird()), String.class));
                        return clipboardData;
                    }
                });
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private IXtextDocument getXtextDocument() {
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)this.getTextEditor());
        IXtextDocument document = xtextEditor.getDocument();
        return document;
    }

    public void update() {
        super.update();
        if (this.isModifyOperation() && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.textOperationTarget == null && editor != null) {
            this.textOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        boolean isEnabled = this.textOperationTarget != null && this.textOperationTarget.canDoOperation(this.getOperationCode());
        this.setEnabled(isEnabled);
    }

    private int getOperationCode() {
        return this.operationCode;
    }

    public void run() {
        if (this.textOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (this.isModifyOperation() && !this.validateEditorInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ImportsAwareClipboardAction.this.internalDoOperation();
            }
        });
    }

    private boolean isModifyOperation() {
        return this.operationCode != 4;
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (shell = (site = editor.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.textOperationTarget = null;
    }

    public static class Factory
    implements IClipboardActionFactory {
        @Inject
        private MembersInjector<ImportsAwareClipboardAction> injector;

        @Override
        public TextEditorAction create(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
            ImportsAwareClipboardAction action = new ImportsAwareClipboardAction(bundle, prefix, editor, operationCode);
            this.injector.injectMembers((Object)action);
            return action;
        }
    }

    public static final class XbaseClipboardData {
        private String sourceIndentifier;
        private String[] imports;
        private String[] staticImports;
        private String[] extensionImports;

        public XbaseClipboardData(String sourceIndentifier, String[] imports, String[] staticImports, String[] extensionImports) {
            this.sourceIndentifier = sourceIndentifier;
            this.imports = imports;
            this.staticImports = staticImports;
            this.extensionImports = extensionImports;
        }

        public XbaseClipboardData(byte[] bytes) throws IOException {
            try (DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));){
                this.sourceIndentifier = dataIn.readUTF();
                this.imports = this.readArray(dataIn);
                this.staticImports = this.readArray(dataIn);
                this.extensionImports = this.readArray(dataIn);
            }
        }

        protected final String[] readArray(DataInputStream dataIn) throws IOException {
            int count = dataIn.readInt();
            String[] array = new String[count];
            int i = 0;
            while (i < count) {
                array[i] = dataIn.readUTF();
                ++i;
            }
            return array;
        }

        public byte[] serialize() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            try {
                dataOut.writeUTF(this.sourceIndentifier);
                this.writeArray(dataOut, this.imports);
                this.writeArray(dataOut, this.staticImports);
                this.writeArray(dataOut, this.extensionImports);
            }
            finally {
                dataOut.close();
                out.close();
            }
            return out.toByteArray();
        }

        protected final void writeArray(DataOutputStream dataOut, String[] array) throws IOException {
            dataOut.writeInt(array.length);
            int i = 0;
            while (i < array.length) {
                dataOut.writeUTF(array[i]);
                ++i;
            }
        }

        public String getSourceIndentifier() {
            return this.sourceIndentifier;
        }

        public String[] getImports() {
            return this.imports;
        }

        public String[] getStaticImports() {
            return this.staticImports;
        }

        public String[] getExtensionImports() {
            return this.extensionImports;
        }
    }

    private static class XbaseClipboardTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "xbase-source-with-imports-transfer-format";
        private static final int TYPEID = XbaseClipboardTransfer.registerType((String)"xbase-source-with-imports-transfer-format");

        private XbaseClipboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object data, TransferData transferData) {
            if (data instanceof XbaseClipboardData) {
                try {
                    super.javaToNative((Object)((XbaseClipboardData)data).serialize(), transferData);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return new XbaseClipboardData(bytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

