/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseFileSystemSupportImpl
extends AbstractFileSystemSupport {
    @Inject
    private IWorkspaceRoot _workspaceRoot;

    public IWorkspaceRoot getWorkspaceRoot() {
        return this._workspaceRoot;
    }

    public void setWorkspaceRoot(IWorkspaceRoot workspaceRoot) {
        this._workspaceRoot = workspaceRoot;
    }

    protected IFile getFile(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IFile _file = _workspaceRoot.getFile((IPath)_path);
        return _file;
    }

    protected IFolder getFolder(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IFolder _folder = _workspaceRoot.getFolder((IPath)_path);
        return _folder;
    }

    protected IResource findResource(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IResource _findMember = _workspaceRoot.findMember((IPath)_path);
        return _findMember;
    }

    protected org.eclipse.core.runtime.Path toEclipsePath(Path path) {
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        return _path;
    }

    public Iterable<? extends Path> getChildren(Path path) {
        try {
            IFolder _folder = this.getFolder(path);
            IResource[] _members = _folder.members();
            Functions.Function1<IResource, Path> _function = new Functions.Function1<IResource, Path>(){

                public Path apply(IResource it) {
                    IPath _fullPath = it.getFullPath();
                    String _string = _fullPath.toString();
                    Path _path = new Path(_string);
                    return _path;
                }
            };
            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_members)), (Functions.Function1)_function);
            return _map;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean exists(Path path) {
        IResource _findResource = this.findResource(path);
        boolean _notEquals = !Objects.equal((Object)_findResource, null);
        return _notEquals;
    }

    public boolean isFolder(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IFolder;
    }

    public boolean isFile(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IFile;
    }

    public long getLastModification(Path path) {
        IResource _findResource = this.findResource(path);
        long _modificationStamp = _findResource.getModificationStamp();
        return _modificationStamp;
    }

    public String getCharset(Path path) {
        boolean _isFile = this.isFile(path);
        if (_isFile) {
            try {
                IFile _file = this.getFile(path);
                return _file.getCharset();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        boolean _isFolder = this.isFolder(path);
        if (_isFolder) {
            try {
                IFolder _folder = this.getFolder(path);
                return _folder.getDefaultCharset();
            }
            catch (Throwable _e_1) {
                throw Exceptions.sneakyThrow((Throwable)_e_1);
            }
        }
        Path _parent = path.getParent();
        return this.getCharset(_parent);
    }

    public InputStream getContentsAsStream(Path path) {
        try {
            IFile _file = this.getFile(path);
            InputStream _contents = _file.getContents();
            return _contents;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean delete(Path path) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IResource _findResource = this.findResource(path);
                _findResource.delete(true, null);
                return true;
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean mkdir(Path path) {
        boolean _not;
        block4: {
            try {
                boolean _exists = this.exists(path);
                if (!_exists) break block4;
                return false;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Path _parent = path.getParent();
        boolean _exists_1 = this.exists(_parent);
        boolean bl = _not = !_exists_1;
        if (_not) {
            Path _parent_1 = path.getParent();
            this.mkdir(_parent_1);
        }
        IFolder _folder = this.getFolder(path);
        _folder.create(true, true, null);
        return true;
    }

    public void setContentsAsStream(Path path, InputStream stream) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IFile _file = this.getFile(path);
                _file.setContents(stream, true, true, null);
            } else {
                Path _parent = path.getParent();
                this.mkdir(_parent);
                IFile _file_1 = this.getFile(path);
                _file_1.create(stream, true, null);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

