/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveAwareScope
extends AbstractScope {
    private AbstractTypeScope typeScope;
    private AbstractScope parent;

    protected PrimitiveAwareScope(AbstractScope parent, AbstractTypeScope typeScope) {
        this.parent = parent;
        this.typeScope = typeScope;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (this.isPrimitive(name)) {
            return this.typeScope.getSingleElement(name, true);
        }
        return this.parent.getSingleElement(name);
    }

    protected boolean isPrimitive(QualifiedName name) {
        return name.getSegmentCount() == 1 && Primitives.forName((String)name.getFirstSegment()) != null;
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (type instanceof JvmVoid) {
            result.add(EObjectDescription.create((String)"void", (EObject)type));
            return;
        }
        if (type instanceof JvmPrimitiveType) {
            result.add(EObjectDescription.create((String)((JvmPrimitiveType)type).getSimpleName(), (EObject)type));
            return;
        }
        this.parent.doGetElements(type, result);
    }
}

