/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XExpressionHelper {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private OperatorMapping operatorMapping;

    public boolean hasSideEffects(XExpression expr) {
        if (expr instanceof XClosure || expr instanceof XStringLiteral || expr instanceof XTypeLiteral || expr instanceof XBooleanLiteral || expr instanceof XNumberLiteral || expr instanceof XNullLiteral || expr instanceof XAnnotation) {
            return false;
        }
        if (expr instanceof XCollectionLiteral) {
            for (XExpression element : ((XCollectionLiteral)expr).getElements()) {
                if (!this.hasSideEffects(element)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expr;
            return this.hasSideEffects(featureCall, true);
        }
        if (expr instanceof XConstructorCall) {
            XConstructorCall constrCall = (XConstructorCall)expr;
            return this.findPureAnnotation((JvmExecutable)constrCall.getConstructor()) == null;
        }
        return true;
    }

    public boolean hasSideEffects(XAbstractFeatureCall featureCall, boolean inspectContents) {
        if (featureCall instanceof XAssignment) {
            return true;
        }
        if (featureCall.isPackageFragment() || featureCall.isTypeLiteral()) {
            return false;
        }
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature == null || feature.eIsProxy()) {
            return true;
        }
        if (feature instanceof JvmConstructor) {
            return true;
        }
        if (feature instanceof JvmOperation) {
            JvmOperation jvmOperation = (JvmOperation)feature;
            if (this.findPureAnnotation((JvmExecutable)jvmOperation) == null) {
                return true;
            }
            if (inspectContents) {
                for (XExpression param : featureCall.getActualArguments()) {
                    if (!this.hasSideEffects(param)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public JvmAnnotationReference findInlineAnnotation(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmAnnotationTarget) {
            return this.findAnnotation((JvmAnnotationTarget)feature, Inline.class.getName());
        }
        return null;
    }

    public JvmAnnotationReference findPureAnnotation(JvmExecutable featureCall) {
        return this.findAnnotation((JvmAnnotationTarget)featureCall, Pure.class.getName());
    }

    protected JvmAnnotationReference findAnnotation(JvmAnnotationTarget feature, String annotationType) {
        if (annotationType == null) {
            throw new NullPointerException();
        }
        EList annotations = feature.getAnnotations();
        for (JvmAnnotationReference annotation : annotations) {
            if (!annotationType.equals(annotation.getAnnotation().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    public String getAndOperator() {
        return "&&";
    }

    public String getOrOperator() {
        return "||";
    }

    public String getElvisOperator() {
        return "?:";
    }

    public boolean isShortCircuitOperation(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            if (this.isOperatorFromExtension(featureCall, OperatorMapping.ELVIS, ObjectExtensions.class)) {
                return true;
            }
            return this.isOperatorFromExtension(featureCall, OperatorMapping.AND, BooleanExtensions.class) || this.isOperatorFromExtension(featureCall, OperatorMapping.OR, BooleanExtensions.class);
        }
        return false;
    }

    public boolean isOperatorFromExtension(XExpression expression, QualifiedName operatorSymbol, Class<?> definingExtensionClass) {
        return expression instanceof XAbstractFeatureCall && this.isOperatorFromExtension((XAbstractFeatureCall)expression, operatorSymbol, definingExtensionClass);
    }

    public boolean isOperatorFromExtension(XAbstractFeatureCall featureCall, QualifiedName operatorSymbol, Class<?> definingExtensionClass) {
        if (!Strings.equal((String)featureCall.getConcreteSyntaxFeatureName(), (String)operatorSymbol.getLastSegment())) {
            return false;
        }
        QualifiedName methodName = this.operatorMapping.getMethodName(operatorSymbol);
        JvmDeclaredType definingJvmType = (JvmDeclaredType)this.typeReferences.findDeclaredType(definingExtensionClass, (Notifier)featureCall);
        Iterable operatorImplementations = definingJvmType.findAllFeaturesByName(methodName.getLastSegment());
        return Iterables.contains((Iterable)operatorImplementations, (Object)featureCall.getFeature());
    }

    public boolean isInlined(XAbstractFeatureCall call) {
        return this.findInlineAnnotation(call) != null;
    }
}

