/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class GuiceModuleAccess {
    private static final Logger LOG = Logger.getLogger(GuiceModuleAccess.class);
    private final Set<Binding> bindings = new LinkedHashSet<Binding>();
    private TypeReference superClass;

    public void add(Binding newBinding) {
        if (this.bindings.contains(newBinding)) {
            Iterator<Binding> iterator = this.bindings.iterator();
            boolean found = false;
            while (iterator.hasNext() && !found) {
                Binding oldBinding = iterator.next();
                if (!Objects.equal((Object)oldBinding, (Object)newBinding)) continue;
                if (oldBinding.isFinal) {
                    if (newBinding.isFinal) {
                        throw new IllegalStateException("Conflicting final bindings for '" + oldBinding.key.type + "' from fragments " + oldBinding.contributedBy + " and " + newBinding.contributedBy);
                    }
                    LOG.warn((Object)("Cannot override final binding '" + oldBinding + "'. Ignoring binding from fragment '" + newBinding.contributedBy + "'"));
                } else {
                    LOG.debug((Object)("replacing binding : " + oldBinding));
                    LOG.debug((Object)(" with new binding : " + newBinding));
                    iterator.remove();
                }
                found = true;
            }
        }
        this.bindings.add(newBinding);
    }

    public void addAll(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.add(binding);
        }
    }

    public Set<Binding> getBindings() {
        return Collections.unmodifiableSet(this.bindings);
    }

    public TypeReference getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(TypeReference superClass) {
        this.superClass = superClass;
    }

    public static class BindingFactory {
        private final String contributedBy;
        private final Set<Binding> bindings = new LinkedHashSet<Binding>();

        public BindingFactory() {
            this.contributedBy = new Exception().getStackTrace()[1].getClassName();
        }

        public BindingFactory(String contributedBy) {
            this.contributedBy = contributedBy;
        }

        private void add(BindKey type, BindValue expr) {
            this.add(type, expr, false);
        }

        private void add(BindKey type, BindValue expr, boolean isFinal) {
            this.add(new Binding(type, expr, isFinal, this.contributedBy));
        }

        private void add(Binding binding) {
            if (!this.bindings.add(binding)) {
                throw new IllegalArgumentException("Duplicate binding for " + binding.key + " in " + this.contributedBy);
            }
        }

        private BindKey key(TypeReference type) {
            return new BindKey(null, type, false, false);
        }

        private BindKey key(String name) {
            return new BindKey(name, null, false, false);
        }

        private BindKey eagerSingleton(TypeReference type) {
            return new BindKey(null, type, true, true);
        }

        private BindKey singleton(TypeReference type) {
            return new BindKey(null, type, true, false);
        }

        private BindValue value(TypeReference type) {
            return new BindValue(null, type, false, Collections.emptyList());
        }

        private BindValue expr(Object expr) {
            return new BindValue(expr, null, false, Collections.emptyList());
        }

        private BindValue provider(TypeReference type) {
            return new BindValue(null, type, true, Collections.emptyList());
        }

        private BindValue providerExpr(Object expr) {
            return new BindValue(expr, null, true, Collections.emptyList());
        }

        private BindValue statements(Object[] statements) {
            return new BindValue(null, null, false, Arrays.asList(statements));
        }

        public BindingFactory addTypeToInstance(TypeReference type, StringConcatenationClient expression) {
            this.add(this.key(type), this.expr(expression));
            return this;
        }

        public BindingFactory addTypeToProviderInstance(TypeReference type, StringConcatenationClient expression) {
            this.add(this.key(type), this.providerExpr(expression));
            return this;
        }

        public BindingFactory addConfiguredBinding(String name, StringConcatenationClient statement) {
            this.add(this.key(name), this.statements(new Object[]{statement}));
            return this;
        }

        public BindingFactory addTypeToType(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToTypeSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToTypeEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToProvider(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addTypeToProviderSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addTypeToProviderEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addfinalTypeToType(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToTypeSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToTypeEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProvider(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.provider(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProviderSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.provider(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProviderEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.provider(valueType), true);
            return this;
        }

        public void contributeTo(GuiceModuleAccess module) {
            module.addAll(this.bindings);
        }

        public String getContributedBy() {
            return this.contributedBy;
        }
    }

    public static class Binding {
        private final BindKey key;
        private final BindValue value;
        private final boolean isFinal;
        private final String contributedBy;

        public boolean equals(Object other) {
            if (other instanceof Binding) {
                return Objects.equal((Object)this.key, (Object)((Binding)other).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public Binding(BindKey key, BindValue value, boolean isFinal, String contributedBy) {
            this.key = key;
            this.value = value;
            this.isFinal = isFinal;
            this.contributedBy = contributedBy;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("key", (Object)this.key);
            b.add("value", (Object)this.value);
            b.add("isFinal", (Object)this.isFinal);
            b.add("contributedBy", (Object)this.contributedBy);
            return b.toString();
        }

        public BindKey getKey() {
            return this.key;
        }

        public BindValue getValue() {
            return this.value;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public String getContributedBy() {
            return this.contributedBy;
        }
    }

    public static class BindValue {
        private final Object expression;
        private final TypeReference type;
        private final boolean provider;
        private final List<Object> statements;

        public BindValue(Object expression, TypeReference type, boolean provider, List<Object> statements) {
            this.expression = expression;
            this.type = type;
            this.provider = provider;
            this.statements = statements;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.provider ? 1231 : 1237);
            return 31 * result + (this.statements == null ? 0 : this.statements.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindValue other = (BindValue)obj;
            if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (other.provider != this.provider) {
                return false;
            }
            return !(this.statements == null ? other.statements != null : !this.statements.equals(other.statements));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("expression", this.expression);
            b.add("type", (Object)this.type);
            b.add("provider", (Object)this.provider);
            b.add("statements", this.statements);
            return b.toString();
        }

        public Object getExpression() {
            return this.expression;
        }

        public TypeReference getType() {
            return this.type;
        }

        public boolean isProvider() {
            return this.provider;
        }

        public List<Object> getStatements() {
            return this.statements;
        }
    }

    public static class BindKey {
        private final String name;
        private final TypeReference type;
        private final boolean singleton;
        private final boolean eagerSingleton;

        public boolean equals(Object other) {
            if (other instanceof BindKey) {
                return Objects.equal((Object)this.name, (Object)((BindKey)other).name) && Objects.equal((Object)this.type, (Object)((BindKey)other).type);
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            if (this.name != null) {
                h += this.name.hashCode();
            }
            if (this.type != null) {
                h += this.type.hashCode();
            }
            return h;
        }

        public BindKey(String name, TypeReference type, boolean singleton, boolean eagerSingleton) {
            this.name = name;
            this.type = type;
            this.singleton = singleton;
            this.eagerSingleton = eagerSingleton;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("type", (Object)this.type);
            b.add("singleton", (Object)this.singleton);
            b.add("eagerSingleton", (Object)this.eagerSingleton);
            return b.toString();
        }

        public String getName() {
            return this.name;
        }

        public TypeReference getType() {
            return this.type;
        }

        public boolean isSingleton() {
            return this.singleton;
        }

        public boolean isEagerSingleton() {
            return this.eagerSingleton;
        }
    }
}

