/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension;
import org.eclipse.xtext.generator.OutputConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSystemAccess
implements IFileSystemAccess,
IFileSystemAccessExtension {
    private Map<String, OutputConfiguration> outputs = Maps.newLinkedHashMap();

    public void setOutputConfigurations(Map<String, OutputConfiguration> outputs) {
        this.outputs = outputs;
    }

    public Map<String, OutputConfiguration> getOutputConfigurations() {
        return this.outputs;
    }

    protected OutputConfiguration getOutputConfig(String outputName) {
        if (!this.getOutputConfigurations().containsKey(outputName)) {
            throw new IllegalArgumentException("No output configuration with name '" + outputName + "' exists.");
        }
        return this.getOutputConfigurations().get(outputName);
    }

    protected Map<String, String> getPathes() {
        return Maps.transformValues(this.outputs, (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getOutputDirectory();
            }
        });
    }

    public void setOutputPath(String outputName, String path) {
        OutputConfiguration configuration = this.outputs.get(outputName);
        if (configuration == null) {
            configuration = new OutputConfiguration(outputName);
            this.outputs.put(outputName, configuration);
        }
        configuration.setOutputDirectory(path);
    }

    public void setOutputPath(String path) {
        this.setOutputPath("DEFAULT_OUTPUT", path);
    }

    @Override
    public void generateFile(String fileName, CharSequence contents) {
        this.generateFile(fileName, "DEFAULT_OUTPUT", contents);
    }

    @Override
    public void deleteFile(String fileName) {
        this.deleteFile(fileName, "DEFAULT_OUTPUT");
    }

    @Override
    public void deleteFile(String fileName, String outputConfigurationName) {
        throw new UnsupportedOperationException();
    }
}

