/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;
import org.eclipse.xtext.ui.internal.Activator;

@Singleton
public class PreferenceStoreAccessImpl
implements IPreferenceStoreAccess {
    private String qualifier;
    private boolean initialized = false;
    @Inject
    private IPreferenceStoreInitializer.CompositeImpl initializer;

    public IPreferenceStore getPreferenceStore() {
        this.lazyInitialize();
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(), Activator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()});
    }

    public IPreferenceStore getContextPreferenceStore(Object context) {
        this.lazyInitialize();
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(context), Activator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()});
    }

    public IPreferenceStore getWritablePreferenceStore() {
        this.lazyInitialize();
        ScopedPreferenceStore result = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getQualifier());
        result.setSearchContexts(new IScopeContext[]{new InstanceScope(), new ConfigurationScope()});
        return result;
    }

    public IPreferenceStore getWritablePreferenceStore(Object context) {
        this.lazyInitialize();
        if (context instanceof IFileEditorInput) {
            context = ((IFileEditorInput)context).getFile().getProject();
        }
        if (context instanceof IProject) {
            ProjectScope projectScope = new ProjectScope((IProject)context);
            ScopedPreferenceStore result = new ScopedPreferenceStore((IScopeContext)projectScope, this.getQualifier());
            result.setSearchContexts(new IScopeContext[]{projectScope, new InstanceScope(), new ConfigurationScope()});
            return result;
        }
        return this.getWritablePreferenceStore();
    }

    @Inject
    public void setLanguageNameAsQualifier(@Named(value="languageName") String languageName) {
        this.qualifier = languageName;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected void lazyInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.initializer.initialize(this);
        }
    }
}

