/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.Strings;

public class Xtend2RenameElementProcessor
extends RenameElementProcessor {
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject(optional=true)
    private IWorkbench workbench;

    public boolean hasUnsavedEditors() {
        return (Boolean)new DisplayRunnableWithResult<Boolean>(){

            protected Boolean run() throws Exception {
                IWorkbenchPage workbenchPage = Xtend2RenameElementProcessor.this.workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart[] iEditorPartArray = workbenchPage.getDirtyEditors();
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPart = iEditorPartArray[n2];
                    if (Strings.equal((String)editorPart.getSite().getId(), (String)Xtend2RenameElementProcessor.this.languageName)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }.syncExec();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.hasUnsavedEditors()) {
            this.getStatus().add(2, "Unsaved changes in Xtend editors could collide with this refactoring.", new Object[0]);
        }
        return super.checkInitialConditions(pm);
    }
}

