/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.AbstractBuilderState;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.clustering.Messages;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringBuilderState
extends AbstractBuilderState {
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.clustering.ClusteringBuilderState.clusterSize")
    private int clusterSize = 20;

    @Override
    protected Collection<IResourceDescription.Delta> doUpdate(ResourceSet resourceSet, Set<URI> toBeAddedOrUpdated, Set<URI> toBeRemoved, Map<URI, IResourceDescription> newMap, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<IResourceDescription.Delta> deltas = this.collectResources(resourceSet, toBeAddedOrUpdated, toBeRemoved, (IProgressMonitor)progress.newChild(20));
        HashSet allCopiedDeltas = Sets.newHashSet();
        Iterator<IResourceDescription.Delta> deltaIterator = deltas.iterator();
        int noOfDeltas = deltas.size();
        int currentDeltaIndex = 1;
        while (deltaIterator.hasNext()) {
            progress.setWorkRemaining(2 * (noOfDeltas - currentDeltaIndex));
            ImmutableList<IResourceDescription.Delta> copiedDeltas = this.updateAndCopyDescriptions(resourceSet, deltaIterator, newMap, currentDeltaIndex, noOfDeltas, (IProgressMonitor)progress.newChild(this.clusterSize));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            currentDeltaIndex += copiedDeltas.size();
            this.updateMarkers(resourceSet, copiedDeltas, (IProgressMonitor)progress.newChild(copiedDeltas.size()));
            resourceSet.getResources().clear();
            allCopiedDeltas.addAll(copiedDeltas);
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return allCopiedDeltas;
    }

    protected Collection<IResourceDescription.Delta> collectResources(ResourceSet resourceSet, Set<URI> toBeAddedOrUpdated, Set<URI> toBeRemoved, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        Collection<IResourceDescription.Delta> result = this.transitiveUpdate(resourceSet, toBeAddedOrUpdated, toBeRemoved, (IProgressMonitor)progress.newChild(1));
        return result;
    }

    protected ImmutableList<IResourceDescription.Delta> updateAndCopyDescriptions(ResourceSet resourceSet, Iterator<IResourceDescription.Delta> deltaIterator, Map<URI, IResourceDescription> newMap, int firstIndex, int noOfDeltas, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ClusteringBuilderState_0, (int)this.clusterSize);
        HashSet result = Sets.newHashSet();
        int i = 0;
        while (i < this.clusterSize && deltaIterator.hasNext()) {
            IResourceDescription.Delta delta = deltaIterator.next();
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            progress.subTask(String.valueOf(Messages.ClusteringBuilderState_1) + firstIndex + Messages.ClusteringBuilderState_2 + noOfDeltas);
            IResourceDescription newDescription = null;
            if (delta.getNew() != null) {
                Resource resource = resourceSet.getResource(delta.getUri(), true);
                IResourceDescription.Manager manager = this.getResourceDescriptionManager(delta.getUri());
                newDescription = manager.getResourceDescription(resource);
            }
            DefaultResourceDescriptionDelta copiedDelta = new DefaultResourceDescriptionDelta(delta.getOld(), this.copy(newDescription));
            result.add(copiedDelta);
            if (copiedDelta.getNew() == null) {
                newMap.remove(copiedDelta.getUri());
            } else {
                newMap.put(copiedDelta.getUri(), copiedDelta.getNew());
            }
            ++firstIndex;
            progress.worked(1);
            ++i;
        }
        return ImmutableList.copyOf((Iterable)result);
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }

    private IResourceDescription copy(IResourceDescription toCopy) {
        if (toCopy == null) {
            return null;
        }
        ResourceDescriptionImpl result = BuilderStateUtil.create(toCopy);
        return result;
    }
}

