/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.internal.Activator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextPluginImages {
    private static final String NAME_PREFIX = "org.eclipse.xtext.ui.";
    private static ImageRegistry PLUGIN_REGISTRY;
    public static final String ICONS_PATH = "icons/";
    private static final String PATH_OBJ = "icons/obj16/";
    private static final String PATH_LCL = "icons/elcl16/";
    private static final String PATH_LCL_DISABLED = "icons/dlcl16/";
    private static final String PATH_OVR = "icons/ovr16/";
    public static final String OBJ_DESC_SERVICE_LOADED = "org.eclipse.xtext.ui.OBJ_DESC_SERVICE_LOADED";
    public static final String OBJ_DESC_SERVICE_NOT_LOADED = "org.eclipse.xtext.ui.OBJ_DESC_SERVICE_NOT_LOADED";
    public static final String OBJ_DESC_LANGUAGE = "org.eclipse.xtext.ui.OBJ_DESC_LANGUAGE";
    public static final String OBJ_CORRECTION_CHANGE = "org.eclipse.xtext.ui.CORRECTION_CHANGE";
    public static final String OBJ_FIXABLE_ERROR = "org.eclipse.xtext.ui.OBJ_FIXABLE_ERROR";
    public static final String OBJ_FIXABLE_WARNING = "org.eclipse.xtext.ui.OBJ_FIXABLE_WARNING";
    public static final ImageDescriptor DESC_SERVICE_LOADED_OBJ;
    public static final ImageDescriptor DESC_SERVICE_NOT_LOADED_OBJ;
    public static final ImageDescriptor DESC_LANGUAGE_OBJ;
    public static final ImageDescriptor DESC_CORRECTION_CHANGE;
    public static final ImageDescriptor DESC_FIXABLE_ERROR;
    public static final ImageDescriptor DESC_FIXABLE_WARNING;
    public static final ImageDescriptor DESC_OVR_ERROR;
    public static final ImageDescriptor DESC_OVR_WARNING;
    public static final ImageDescriptor DESC_LINK_WITH_EDITOR;
    public static final ImageDescriptor DESC_ALPHAB_SORT_CO;
    public static final ImageDescriptor DESC_LINK_WITH_EDITOR_DISABLED;
    public static final ImageDescriptor DESC_ALPHAB_SORT_CO_DISABLED;
    public static final ImageDescriptor DESC_SEARCH_PREVIOUS;
    public static final ImageDescriptor DESC_SEARCH_NEXT;
    public static final ImageDescriptor DESC_EXPAND_ALL;
    public static final ImageDescriptor DESC_COLLAPSE_ALL;
    private static boolean imagesInitialized;
    private static final Map<String, Image> annotationImagesFixable;
    private static final Map<String, Image> annotationImagesNonFixable;
    private static final Map<String, Image> annotationImagesDeleted;

    static {
        DESC_SERVICE_LOADED_OBJ = XtextPluginImages.create(PATH_OBJ, "service_loaded.gif");
        DESC_SERVICE_NOT_LOADED_OBJ = XtextPluginImages.create(PATH_OBJ, "service_not_loaded.gif");
        DESC_LANGUAGE_OBJ = XtextPluginImages.create(PATH_OBJ, "font.gif");
        DESC_CORRECTION_CHANGE = XtextPluginImages.create(PATH_OBJ, "correction_change.gif");
        DESC_FIXABLE_ERROR = XtextPluginImages.create(PATH_OBJ, "quickfix_error_obj.gif");
        DESC_FIXABLE_WARNING = XtextPluginImages.create(PATH_OBJ, "quickfix_warning_obj.gif");
        DESC_OVR_ERROR = XtextPluginImages.create(PATH_OVR, "error_co.gif");
        DESC_OVR_WARNING = XtextPluginImages.create(PATH_OVR, "warning_co.gif");
        DESC_LINK_WITH_EDITOR = XtextPluginImages.create(PATH_LCL, "synced.gif");
        DESC_ALPHAB_SORT_CO = XtextPluginImages.create(PATH_LCL, "alphab_sort_co.gif");
        DESC_LINK_WITH_EDITOR_DISABLED = XtextPluginImages.create(PATH_LCL_DISABLED, "synced.gif");
        DESC_ALPHAB_SORT_CO_DISABLED = XtextPluginImages.create(PATH_LCL_DISABLED, "alphab_sort_co.gif");
        DESC_SEARCH_PREVIOUS = XtextPluginImages.create(PATH_LCL, "prev_nav.gif");
        DESC_SEARCH_NEXT = XtextPluginImages.create(PATH_LCL, "next_nav.gif");
        DESC_EXPAND_ALL = XtextPluginImages.create(PATH_LCL, "expandall.gif");
        DESC_COLLAPSE_ALL = XtextPluginImages.create(PATH_LCL, "collapseall.gif");
        annotationImagesFixable = new HashMap<String, Image>();
        annotationImagesNonFixable = new HashMap<String, Image>();
        annotationImagesDeleted = new HashMap<String, Image>();
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)XtextPluginImages.makeImageURL(prefix, name));
    }

    public static Image get(String key) {
        XtextPluginImages.ensureInitialized();
        return PLUGIN_REGISTRY.get(key);
    }

    private static void ensureInitialized() {
        if (PLUGIN_REGISTRY == null) {
            XtextPluginImages.initialize();
        }
    }

    private static final void initializeImageMaps() {
        if (imagesInitialized) {
            return;
        }
        annotationImagesFixable.put("org.eclipse.xtext.ui.editor.error", XtextPluginImages.get(OBJ_FIXABLE_ERROR));
        annotationImagesFixable.put("org.eclipse.xtext.ui.editor.warning", XtextPluginImages.get(OBJ_FIXABLE_WARNING));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image error = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        Image warning = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        annotationImagesNonFixable.put("org.eclipse.xtext.ui.editor.error", error);
        annotationImagesNonFixable.put("org.eclipse.xtext.ui.editor.warning", warning);
        Display display = Display.getCurrent();
        annotationImagesDeleted.put("org.eclipse.xtext.ui.editor.error", new Image((Device)display, error, 2));
        annotationImagesDeleted.put("org.eclipse.xtext.ui.editor.warning", new Image((Device)display, warning, 2));
    }

    private static final void initialize() {
        PLUGIN_REGISTRY = new ImageRegistry();
        XtextPluginImages.manage(OBJ_DESC_SERVICE_LOADED, DESC_SERVICE_LOADED_OBJ);
        XtextPluginImages.manage(OBJ_DESC_SERVICE_NOT_LOADED, DESC_SERVICE_NOT_LOADED_OBJ);
        XtextPluginImages.manage(OBJ_DESC_LANGUAGE, DESC_LANGUAGE_OBJ);
        XtextPluginImages.manage(OBJ_CORRECTION_CHANGE, DESC_CORRECTION_CHANGE);
        XtextPluginImages.manage(OBJ_FIXABLE_ERROR, DESC_FIXABLE_ERROR);
        XtextPluginImages.manage(OBJ_FIXABLE_WARNING, DESC_FIXABLE_WARNING);
        XtextPluginImages.initializeImageMaps();
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = "$nl$/" + prefix + name;
        return FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(path), null);
    }

    public static Image manage(String key, ImageDescriptor desc) {
        Image image = desc.createImage();
        PLUGIN_REGISTRY.put(key, image);
        return image;
    }

    public static Map<String, Image> getAnnotationImagesNonfixable() {
        XtextPluginImages.ensureInitialized();
        return annotationImagesNonFixable;
    }

    public static Map<String, Image> getAnnotationImagesFixable() {
        XtextPluginImages.ensureInitialized();
        return annotationImagesFixable;
    }

    public static Map<String, Image> getAnnotationImagesDeleted() {
        XtextPluginImages.ensureInitialized();
        return annotationImagesDeleted;
    }
}

