/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class FQNPrefixMatcher
extends PrefixMatcher {
    @Inject
    private PrefixMatcher.IgnoreCase delegate;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher.delimiter")
    private char delimiter = (char)46;
    @Inject
    private LastSegmentFinder lastSegmentFinder;

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
            return true;
        }
        if (name.indexOf(this.delimiter) >= 0) {
            if (prefix.indexOf(this.delimiter) < 0) {
                String lastSegment = this.lastSegmentFinder.getLastSegment(name, this.delimiter);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                String[] splitPrefix = prefix.split("\\.");
                String[] splitName = name.split("\\.", splitPrefix.length);
                if (splitName.length < splitPrefix.length) {
                    return false;
                }
                int i = 0;
                while (i < splitPrefix.length) {
                    if (!this.delegate.isCandidateMatchingPrefix(splitName[i], splitPrefix[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelegate(PrefixMatcher.IgnoreCase delegate) {
        this.delegate = delegate;
    }

    public PrefixMatcher.IgnoreCase getDelegate() {
        return this.delegate;
    }

    public void setLastSegmentFinder(LastSegmentFinder lastSegmentFinder) {
        this.lastSegmentFinder = lastSegmentFinder;
    }

    public LastSegmentFinder getLastSegmentFinder() {
        return this.lastSegmentFinder;
    }

    public static class DefaultLastSegmentFinder
    implements LastSegmentFinder {
        public String getLastSegment(String fqn, char delimiter) {
            if (fqn == null || fqn.length() == 0) {
                return null;
            }
            boolean lookForUppercase = true;
            int i = 0;
            while (i < fqn.length()) {
                if (lookForUppercase && Character.isUpperCase(fqn.charAt(i))) {
                    return fqn.substring(i);
                }
                lookForUppercase = delimiter == fqn.charAt(i);
                ++i;
            }
            return null;
        }
    }

    @ImplementedBy(value=DefaultLastSegmentFinder.class)
    public static interface LastSegmentFinder {
        public String getLastSegment(String var1, char var2);
    }
}

