/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxRegistry;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContextImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;

public class BlackboxUnitResolver
implements UnitResolver {
    public static final URI GLOBAL_CONTEXT = URI.createURI((String)"/");
    public static final BlackboxUnitResolver DEFAULT = new BlackboxUnitResolver(GLOBAL_CONTEXT);
    private ResolutionContext fContext;

    public BlackboxUnitResolver(URI context) {
        this.fContext = new ResolutionContextImpl(context);
    }

    public static boolean isBlackboxUnitURI(URI uri) {
        return "qvto".equals(uri.scheme()) && "blackbox".equals(uri.authority());
    }

    public UnitProxy resolveUnit(String qualifiedName) {
        BlackboxUnitDescriptor descriptor = BlackboxRegistry.INSTANCE.getCompilationUnitDescriptor(qualifiedName, this.fContext);
        if (descriptor != null) {
            String name;
            String namespace;
            int namePos = qualifiedName.lastIndexOf(46);
            if (namePos > 0) {
                namespace = qualifiedName.substring(0, namePos);
                if (namePos + 1 < qualifiedName.length()) {
                    ++namePos;
                }
                name = qualifiedName.substring(namePos);
            } else {
                name = qualifiedName;
                namespace = null;
            }
            return new BlackboxUnitProxy(namespace, name, descriptor);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BlackboxUnitContents
    implements UnitContents.ModelContents {
        private BlackboxUnitDescriptor fDescriptor;
        private Diagnostic fProblems;

        BlackboxUnitContents(BlackboxUnitDescriptor descriptor) {
            assert (descriptor != null);
            this.fDescriptor = descriptor;
        }

        @Override
        public Diagnostic getProblems() {
            return this.fProblems;
        }

        public List<Module> loadElements(EPackage.Registry packageRegistry) {
            LoadContext loadContext = new LoadContext(packageRegistry);
            BlackboxUnit cunit = null;
            try {
                cunit = this.fDescriptor.load(loadContext);
                if (cunit.getDiagnostic().getSeverity() == 4) {
                    String errMessage = NLS.bind(ValidationMessages.FailedToLoadUnit, this.fDescriptor.getQualifiedName());
                    this.fProblems = new BasicDiagnostic(cunit.getDiagnostic().getSource(), cunit.getDiagnostic().getCode(), QvtOperationalParserUtil.wrappInSeeErrorLogMessage(errMessage), null);
                }
            }
            catch (BlackboxException e) {
                Diagnostic diagnostic = e.getDiagnostic();
                if (diagnostic != null) {
                    QvtPlugin.logDiagnostic(diagnostic);
                } else {
                    QvtPlugin.error(NLS.bind(ValidationMessages.FailedToLoadUnit, new Object[]{this.fDescriptor.getQualifiedName()}), e);
                }
                String errMessage = NLS.bind(ValidationMessages.FailedToLoadUnit, this.fDescriptor.getQualifiedName());
                this.fProblems = new BasicDiagnostic(diagnostic.getSource(), diagnostic.getCode(), QvtOperationalParserUtil.wrappInSeeErrorLogMessage(errMessage), null);
            }
            if (cunit == null) {
                return Collections.emptyList();
            }
            List<QvtOperationalModuleEnv> elementEnvs = cunit.getElements();
            ArrayList<Module> unitElements = new ArrayList<Module>(elementEnvs.size());
            for (QvtOperationalModuleEnv nextEnv : elementEnvs) {
                Module module = nextEnv.getModuleContextType();
                if (module == null) continue;
                unitElements.add(module);
                ASTBindingHelper.setEnvironment((EObject)module, nextEnv);
            }
            return unitElements;
        }
    }

    class BlackboxUnitProxy
    extends UnitProxy {
        private BlackboxUnitDescriptor fDescriptor;

        BlackboxUnitProxy(String namespace, String name, BlackboxUnitDescriptor descriptor) {
            super(namespace, name, descriptor.getURI());
            this.fDescriptor = descriptor;
        }

        public int getContentType() {
            return 1;
        }

        public BlackboxUnitContents getContents() {
            return new BlackboxUnitContents(this.fDescriptor);
        }

        public UnitResolver getResolver() {
            return BlackboxUnitResolver.this;
        }

        public CompiledUnit load(IMetamodelRegistryProvider provider) {
            BlackboxUnitContents contents = this.getContents();
            List<Module> modules = contents.loadElements(CompilerUtils.getEPackageRegistry(this.getURI(), provider));
            ArrayList<QvtOperationalModuleEnv> modelEnvs = new ArrayList<QvtOperationalModuleEnv>(modules.size());
            for (Module nextModule : modules) {
                QvtOperationalModuleEnv nextEnv = ASTBindingHelper.getEnvironment((EObject)nextModule, QvtOperationalModuleEnv.class);
                if (nextEnv == null) continue;
                nextEnv.clearProblems();
                modelEnvs.add(nextEnv);
            }
            CompiledUnit compiledUnit = new CompiledUnit(Arrays.asList(ResolverUtils.getNameSegments(this.getQualifiedName())), this.getURI(), modelEnvs);
            Diagnostic loadProblems = contents.getProblems();
            if (loadProblems != null) {
                compiledUnit.addProblem(new QvtMessage(loadProblems.getMessage()));
            }
            return compiledUnit;
        }
    }
}

